#!/usr/bin/perl5

require "/usr/OnRamp/lib/OnRamp.pm";

$conf = "/etc/mrouted.conf";
$options = "/etc/config/mrouted.options";
$dummy = "/etc/mrouted.conf.tmp";
$data = "/etc/mrouted.conf.data";
$myname = "mrouted.cgi";
$title = "Multicast Routing";

print "Content-type: text/html\n\n";
&title_block($title);

&get_fields;

&getInfo;

$help = $ENV{"DOCUMENT_ROOT"} . $ENV{"SCRIPT_NAME"};
$help =~ s/cgi$/hlp/;
exec $help if ($fld{'help'} eq "Help");

if ($fld{"doit"} eq "Ok") { 
    if ($fld{'tun'} eq 'Yes' && $fld{'emr'} eq 'Yes') { &formValidation; }
    &edit; 
    &getInfo; 
}

if (-e "/usr/etc/mrouted") { &generic; }
else { 
    &header_block($title);
    print "<i>Multicast routing software not installed.  Install
		subsystem </i><b>eoe.sw.ipgate</b><i> from the 6.2 CD.</i>";
}

sub error {
    &error_block($_[0]);
    %val = %fld;
    &generic;
    exit 0;
}

sub edit {
    `/etc/killall mrouted`;
    if ($fld{'emr'} eq 'Yes') {
	if ($val{'emr'} eq 'No') { $message = "Multicast routing enabled.  "; }
	if ($fld{'tun'} eq 'Yes') { 
	    &writeTunnel;
	    $message .= "Tunnel information updated.";
	}
	else { 
	    &turnOffTunnel;
	    $message .= "Tunnel disabled."; 
	}
	&restartDeamon("mrouted","/usr/etc/mrouted",$options);
	`/etc/chkconfig mrouted on`;
    } else { 
	`/etc/chkconfig mrouted off`;
	if ($val{'emr'} eq 'Yes') { 
	    $message = "Multicast routing disabled.";
	} else { $message = "No change made."; }
	$val{'emr'} = "No";
    }
}

sub turnOffTunnel {
    ($dummy,$local) = split(/ /,$fld{'int'});

    open(IN,"< $conf");
    open(OUT,"> $dummy");
    while(<IN>) {
	$line = $_;
	@items = split(/\s+/,$line);
	if ($items[0] eq "tunnel"  && $items[1] eq $local) { 
	    $line = "# $line"; 
	}
	print OUT $line;
    }
    close(IN);
    close(OUT);
    rename($dummy,$conf);
}    

sub writeTunnel {
    ($skip,$local) = split(/ /,$fld{'int'});

    open(IN,"< $conf");
    open(OUT,"> $dummy");
    $printed = 0;
    while(<IN>) {
	@items = split(/\s+/);
	if ($items[0] ne "tunnel") { print OUT $_; }
	else {
	    if ($items[1] eq $local) {
		if ($items[2] eq $fld{'rip'}) {
		    print OUT $_;
		    $printed = 1;
		} else {
		    print OUT "# $_";
		    print OUT "tunnel $local $fld{'rip'}\n";
		    $printed = 1;
		}
	    } 
	}
    }
    if (!$printed) { print OUT "tunnel $local $fld{'rip'}\n"; }
    close(OUT);
    close(IN);
    rename($dummy,$conf);
}

sub restartDeamon {
    $command = "$_[1] ";
    open(IN,"< $_[2]");
    while(<IN>) { chop($_); $command .= " $_"; }
    close(IN);
    `$command`;
}

sub formValidation {
	&error("Remote IP address required.") if $fld{'rip'} eq "";
	if (&check_ipaddr($fld{'rip'})) {
		&error("Invalid remote IP address");
		&generic;
		exit 0;
	}
}
   
sub generic {
    &header_block($title);

    print "<i>$message</i>";

    print "<form action=$myname method=post>";

    print "<center><table cellpadding=5 width=450>";

    print "<tr><th align=left>Enable multicast routing:</th><th align=left>",
	  &radio('emr',$val{'emr'},"Yes","No"), "</th></tr><tr></tr>";

    print "<tr><th align=left>Setup IP tunnel (if needed):</th><th></th></tr>";

    print "</table>";

    print '<table cellpadding=5 width=350>';

    print '<tr><th align=left>Enable tunnel:</th>',
	  '<td align=left><strong>';
    print &radio('tun',$val{'tun'},"Yes","No");
    print '</strong></td></tr>';
    print '<tr><th align=left>Interface:</th><td align=left>';
    print qq|<select name="int">|;
    for ($i=0;$i<=$#myInt;$i++) {
	if ($locIP ne $myIP[$i]) { print "<option>$myInt[$i] $myIP[$i]"; }
	else { print "<option selected>$myInt[$i] $myIP[$i]"; }
    }
    print "</select>";
    print '</td></tr><tr><th align=left>Remote IP address:</th><td align=left>';
    print &text('rip',$val{'rip'},14);
    print '</td></tr>';
    print '</table><br>';

    print &buttons('doit','Ok');

    print '</form>';
}

sub getInfo {
    undef @myInt;
    undef @myIP;
    `/usr/OnRamp/bin/htnetwork > $data`;
    open(IN,"< $data");
    while(<IN>) {
	@items = split(/:/);
	if ($items[3]) {
	    push(@myInt,$items[1]);
	    push(@myIP,$items[3]);
	}
    }
    close(IN);

    $val{'rip'} = "";
    $met = 1;
    $val{'tun'} = "No";

    `/etc/chkconfig mrouted`;
    $output = $? >> 8;
    if ($output) { $val{'emr'} = "No"; }
    else { $val{'emr'} = "Yes"; }

    open(IN,"< $conf");
    while(<IN>) {
	@items = split(/\s+/);
	if ($items[0] ne 'tunnel') { next; }
	for($i=0;$i<=$#myIP;$i++) {
	    if ($myIP[$i] eq $items[1]) {
		$val{'rip'} = $items[2];
		$locIP = $myIP[$i];
		$val{'tun'} = "Yes";
	    }
	}
    }
    close(IN); 
}
