#!/usr/bin/perl5

require "/usr/OnRamp/lib/OnRamp.pm";

$conf = "/etc/named.boot";
$dummy = "/etc/named.boot.dummy";
$myname = "named-config.cgi";
$title = "Domain Name Server";

print "Content-type: text/html\n\n";
&title_block($title);

&get_fields;

`/etc/chkconfig named`;
$status = $? >> 8;
if ($status) { $srv_on = 'No'; }
else { $srv_on = 'Yes'; }

$edit = 0;
$delete = 0;

&getDomains;

if (%fld) {
    $fld{'chosen'} =~ /([\w.]+)/;
    $fld{'chosen'} = $1;

    $help = $ENV{"DOCUMENT_ROOT"} . $ENV{"SCRIPT_NAME"};
    $help =~ s/cgi$/hlp/;
    exec $help if ($fld{'help'} eq "Help");

    if ($fld{'doit'} eq 'Ok') {
	if ($srv_on ne $fld{'server'}) { &changeStatus; }
	if ($fld{'delFile'}) { &delete($fld{'delFile'}); }
	&ckeckForwarders;
	&checkSlave;
	if (!$message) { 
	    if (!$fld{'newDomain'}) { $message = "No changes made."; }
	    else { $message = qq|To add a new domain, click the "Add New Domain"
		    button.|; }
	}
    }
    elsif ($fld{'add'}) { 
	&formValid_add;
	$val{'domain'} = $fld{'newDomain'};
	$val{'type'} = $type; 
	&getAdd; 
    }
    elsif ($fld{'delete'}) {
	&error(0,"No domain selected.") if !$fld{'chosen'};
	$message = qq|Click "Ok" to save changes.|; 
	$delete = 1; 
    }
    elsif ($fld{'doAdd'} eq 'Ok') { &formValid_doAdd; &addDomain; &getDomains; }
    elsif ($fld{'doEdit'} eq 'Ok') { &formValid_doEdit; &editDomain; &getDomains; }
    elsif ($fld{'edit'}) {
	&error(0,"No domain selected.") if !$fld{'chosen'}; 
	&getDomains($fld{'chosen'});
	&putEdit;
	&getEdit;
	$edit = 1;
    }
}

if (($fld{'add'} ne 'Add New Domain') && ($edit == 0)) {
    if (-e "/usr/sbin/named") { &generic; }
    else { 
	&header_block($title);
	print "<i>The domain name server software is not installed on this
		machine.  Install subsystem </i><b>eoe.sw.named</b><i>
		from the 6.2 CD.</i>";
    }   
}

sub checkSlave {
    if ($val{'slave'} ne $fld{'slave'}) {
	if ($fld{'slave'} eq 'Yes') {
	    open(OUT,">> $conf");
	    print OUT "slave\n";
	    close(OUT);
	    $val{'slave'} = 'Yes';
	    $message = "Dynamic creation of direct links disabled.";
	} else {
	    open(IN,"< $conf");
	    open(OUT,"> $dummy");
	    while(<IN>) {
		@items = split(/\s+/);
		if ($items[0] ne 'slave') { print OUT $_; }
	    }
	    close(IN);
	    close(OUT);
	    rename($dummy,$conf);
	    $val{'slave'} = 'No';
	    $message = "Dynamic creation of direct links enabled.";
	}
    }
}

sub changeStatus {
    if($fld{'server'} eq 'Yes') { 
	`/etc/chkconfig named on`;
	`/usr/sbin/named.restart`;
	$srv_on = "Yes"; 
	$message = "Name server enabled.";
    }
    else { 
	`/etc/chkconfig named off`; 
	`/etc/killall named`;
	$srv_on = "No";
	$message = "Name server disabled.";
    }
}

sub formValid_add {
    &error(0,"Cannot add duplicate domain name.") 
	if grep($_ eq $fld{'newDomain'},@domainList);
    if (! ( $fld{'newDomain'} =~ /(\d+)\.(\d+)\.(\d+)\.(\d+)\.in-addr\.arpa/ )) {
	&error(0,"Invalid domain name.") if &check_hostname($fld{'newDomain'});
    } else {
	$reverse = "$4.$3.$2.$1";
	&error(0,"Invalid IP address: $reverse.") if &check_ipaddr($reverse);
    }
}

sub formValid_doAdd {
    my $erval = &check_fname($fld{'newFile'});
    &error(1,$erval) if $erval;

    if ($fld{'newType'} eq 'secondary') {
	&error(1,"Server addresses required for secondary domain.") if !$fld{'list'};
	@list = split(/[\n\s]+/,$fld{'list'});
	foreach $arg (@list) {
	    &error(1,"Invalid IP address: $arg.") if &check_ipaddr($arg);
	}
    }
}

sub formValid_doEdit {
    my $erval = &check_fname($fld{'newFile'});
    &error(2,$erval) if $erval;

    if ($fld{'type'} eq 'secondary') {
	&error(2,"Server addresses required for secondary domain.") if !$fld{'list'};
	@list = split(/[\n\s]+/,$fld{'list'});
	foreach $arg (@list) {
	    &error(2,"Invalid IP address: $arg.") if &check_ipaddr($arg);
	}
    }
}

sub error {
    $mes = $_[1];
    $send = $_[0];
    &error_block($mes);
    %val = %fld;
    if ($send == 0) { &generic; }
    elsif ($send == 1) { &getAdd; }
    elsif ($send == 2) { &getEdit; }
    exit 0;
}

sub editDomain {
    open(IN,"< $conf");
    open(OUT,"> $dummy");

    while(<IN>) {
	$line = $_;
	@items = split(/\s+/,$line);
	if ($items[1] ne $fld{'chosen'}) { print OUT $line; next; }
	else { 
	    print OUT "# $line";
	}   
    }

    $numTab1 = 2 - length($fld{'type'})/8;
    $numTab2 = 4 - length($fld{'domain'})/8;

    print OUT $fld{'type'};

    for ($i=0;$i<$numTab1;$i++) { print OUT "\t"; }
    print OUT $fld{'chosen'};
    if ($fld{'type'} eq 'primary') {
	for ($i=0;$i<$numTab2;$i++) { print OUT "\t"; }
    } else {
	print OUT " ";
	foreach $arg (@list) {
	    print OUT "$arg ";
	}
    }
    print OUT "$fld{'newFile'}\n";    

    close(IN);
    close(OUT);
    rename($dummy, $conf);
    $message = "Domain edited.";
}

sub putEdit {
    $val{'newFile'} = $file;
    $val{'list'} = "";
    foreach $arg (@listServe) {
	$val{'list'} .= "$arg\n";
    }
}

sub getEdit {
    $num = $_[0];

    &header_block("Edit Domain");

    print "<form action=$myname method=post><center><table>";

    print "<input type=hidden name=chosen value=$fld{'chosen'}>";
    print "<input type=hidden name=type value=$val{'type'}>";

    print "<tr><th align=left>Domain name:</th><td><tt>$fld{'chosen'}</tt></td></tr>";
    print "<tr><th align=left>Name server type:</th><td><tt>$val{'type'}</tt></td></tr>";

    print "<tr><th align=left>File name for domain information:</th><td>";
    print &text("newFile",$val{'newFile'},21);
    print "</td></tr>\n";

    if ($fld{'type'.$num} ne 'primary') {
	print "<tr><th align=left valign=top>List of server addresses:</th>";
	print "<td><textarea name=list rows=5 cols=20>";
	print $val{'list'};
	print "</textarea></td>";
	print "</tr>\n";
    }
    print "</table></center><br>";

    print "<i>&nbsp&nbspNote:  server address list required only for secondary domains.</i><br><br>";

    print &buttons("doEdit","Ok");

    print "</form>";
}

sub delete {
    $num = $_[0];

    open(IN,"< $conf");
    open(OUT,"> $dummy");

    while(<IN>) {
	@items = split(/\s+/);
	if ($items[1] eq $_[0]) { print OUT "# $_"; }
	else { print OUT $_; }
    }
    close(IN);
    close(OUT);
    rename($dummy, $conf);
    $message = "Domain deleted.";
}
     
sub addDomain {
    $numTab1 = 2 - length($fld{'newType'})/8;
    $numTab2 = 4 - length($fld{'domain'})/8;

    open(OUT,">> $conf");
    print OUT $fld{'newType'};
    for ($i=0;$i<$numTab1;$i++) { print OUT "\t"; }
    print OUT $fld{'domain'};
    if ($fld{'newType'} eq 'primary') {
	for ($i=0;$i<$numTab2;$i++) { print OUT "\t"; }
    } else {
	print OUT " ";
	foreach $arg (@list) {
	    print OUT "$arg ";
	}
    }
    print OUT "$fld{'newFile'}\n";

    close(OUT);
    $message = "$fld{'domain'} domain added.";
}

sub turnOn  { `/etc/chkconfig named on`; 
	$srv_on = 'Yes'; 
	$message = "Named enabled";
}
sub turnOff { `/etc/chkconfig named off`; 
	$srv_on = 'No'; 
	$message = "Named disabled";
}

sub getDomains {
    $getDomain = $_[0];
    undef @domainList;
    undef @listServe;
    undef @forwarders, $forwarders;
    $val{'slave'} = "No";

    open(IN,"< $conf");

    $i = 0;
    while(<IN>) {
	$line = $_;
	@items = split(/\s+/,$line);
	$domain = $items[1];

	if ($items[0] eq 'slave') { $val{'slave'} = "Yes"; }
	elsif ($items[0] eq 'forwarders') { 
	    for ($i=1;$i<=$#items;$i++) { 
		push(@forwarders,$items[$i]);
	    }
	} elsif ($items[0] eq 'primary' || $items[0] eq 'secondary') {
	    push(@domainList,$domain);
	    if ($getDomain eq $domain) {
		$val{'type'} = $items[0];
		$file = $items[$#items];
		if ($val{'type'} eq 'secondary') {
		    for ($i=2;$i<$#items;$i++) { push(@listServe,$items[$i]); }
		}
	    }
	} else { next; } # cache not supported yet
    }
    close(IN);
    $val{'forwarders'} = join("\n",@forwarders);  
}

sub ckeckForwarders {
    &getDomains;
    @list = split(/[\n\s]+/,$fld{'forwarders'});
    $newForwarders = join("\n",@list);
    if ($newForwarders ne $val{'forwarders'}) { 
	open(IN,"< $conf");
	open(OUT,"> $dummy");
	while(<IN>) {
	    @items = split(/\s+/);
	    if ($items[0] ne 'forwarders') { print OUT $_; }
	    else { print OUT "# $_"; }
	}
	if (@list) {
	    print OUT "forwarders\t@list\n";
	}
	close(IN);
	close(OUT);
	rename($dummy, $conf);

	$val{'forwarders'} = join("\n",@list);
	
	$message = "List of other servers that can resolve names edited.";
    }
} 

sub getAdd {
    &header_block("Add New Domain");

    if (!$val{'newFile'}) { $val{'newFile'} = "/etc/named.d/db.".$val{'domain'}; }

    print "<form action=$myname method=post><center><table>";

    print qq|<input type=hidden name="domain" value=$val{'domain'}>|;

    print "<tr><th align=left>Domain name:</th><td><tt>$val{'domain'}</tt></td></tr>";
    print "<tr><th align=left>Name server type:</th><td><tt>",
	    &select('newType',$val{'newType'},'primary','secondary'), "</tt></td></tr>";

    print "<tr><th align=left>File name for domain information:</th>";
    print "<td>", &text("newFile",$val{'newFile'},21), "</td>";
    print "</tr>\n";
    
    print "<tr><th align=left valign=top>List of server addresses:</th>";
    print "<td><textarea name=list rows=5 cols=20>",
		$val{'list'},"</textarea></td>";
    print "</tr>\n";

    print "</table></center><br>";

    print "<i>&nbsp&nbspNote:  server address list required only for secondary domains.</i><br><br>";

    print &buttons("doAdd","Ok");

    print "</form>";
}

sub generic {
    &header_block($title);

    $val{'newDomain'} = $fld{'newDomain'};

    print "<i>$message</i>";

    print "<form action=$myname method=post>";

    if ($delete) { print "<input type=hidden name=delFile value=$fld{'chosen'}>"; }

    print "<center><table cellpadding=5 width=450>";
    print "<tr><th align=left>Enable DNS server:</th><th>";
    print &radio('server',$srv_on,'Yes','No');
    print "</th></tr>";
    print "</table>";

    print "<table width=400>";

    print qq|<tr><th align=left><input type=submit name="add" 
		value="Add New Domain"></th>|;
    print qq|<td>|,&text("newDomain",$val{'newDomain'},19),qq|</td></tr>|;

    if ($delete) {
	undef @locList;
	foreach $arg (@domainList) {
	    if ($fld{'chosen'} ne $arg) { push(@locList,$arg); }
	}
    } else { @locList = @domainList; }

    print qq|<tr><th align=left><input type=submit name="edit" 
		value="Edit Selected Domain"></th>|;
    print qq|<td rowspan=2>|, &choice_list(*locList,"chosen",20), qq|</td></tr>|;

    print qq|<tr><th align=left><input type=submit name="delete" 
		value="Delete Selected Domain"></th></tr>|;

    print "<tr><td>&nbsp</td></tr>";

    print "<tr><th valign=top>Other servers to contact if name cannot be resolved:</th><td>";

    print "<textarea name=forwarders rows=6 cols=18>$val{'forwarders'}</textarea></td></tr>";

    print "<tr><th align=left>Limit contact hosts to above:</th><th align=left>";
    print &radio('slave',$val{'slave'},'Yes','No');
    print "</th></tr>"; 

    print "</table></center>";    

    print "<br>", &buttons('doit','Ok');

    print "</form>";
}

