#!/usr/bin/perl5

# fix slave_list substitution call

use CGI;
require "/usr/OnRamp/lib/OnRamp.pm";

$query = new CGI;

$dmfile = "/usr/etc/yp/ypdomain";
$title = "NIS Master Server";

print $query->header;
&title_block($title);

$dmname = `/bin/domainname`; chop($dmname); 

$havenfs = system ("/etc/havenfs");
$nis_cl = system ("/etc/chkconfig", "yp");
$nis_sl = system ("/etc/chkconfig", "ypserv");
$nis_ms = system ("/etc/chkconfig", "ypmaster");
$nism = "Yes";
if ($nis_cl || $nis_sl || $nis_ms) {
    $nism = "No";
}

$help = $ENV{"DOCUMENT_ROOT"} . $ENV{"SCRIPT_NAME"};
$help =~ s/cgi$/hlp/;
exec $help if ($query->param('help') eq "Help");

if ($query->param('doit') eq 'Ok') {
    # Check domainname syntax XXX
    $newdm = $query->param('domain');
    $slave_list = $query->param('slave_list');
    $slave_list =~ s/\s{2,2}/,/g;
#    $slave_list =~ s/,\s+|\s+,/,/g; # Change all comma-space or space-comma pairs to comma
#    $slave_list =~ s/^\s+//;   # Remove leading spaces
#    $slave_list =~ s/\s+$//;   # Remove trailing spaces
#    $slave_list =~ s/\s+/,/g;  # Replace intervening spaces with commas

    &formValidation;

    if ($newdm ne $dmname) {
	&set_domain($newdm);
	$message = "Domain name changed.";
    }

    if ($query->param('nism') eq 'Yes') {
	if ($nism eq "No") {
  	    &enable_nism($newdm, $slave_list);
	    $message .= "  NIS Master Server enabled.";
	}
    } else { 
	if ($nism eq "Yes") {
	    &disable_nism;
	    $message .= "  NIS Master Server disabled.";
	}
    }
    if (!$message) { $message = "NIS Master Server configuration updated."; }
}
 
&generic;

print $query->end_html;

sub formValidation {
	my $error = &check_hostname($query->param('domain'));
	&error("Domain name cannot contain shell metacharacters") if $error == 911;
	&error("Domain name must exist") if $error == 4;
	&error("Invalid domain name") if $error;

	foreach (split(/,/, $slave_list)) {
		$error = &check_hostname($_);

		&error(qq|Slave server hostname "$_" cannot contain shell metacharacters|) if $error == 911;
		&error(qq|Slave server hostname "$_" must exist|) if $error == 4;
		&error(qq|Invalid slave server hostname "$_"|) if $error;
	}
}

sub error {
    &error_block($_[0]);
    &generic;
    exit 0;
}

sub set_domain {
    open(DMN, ">$dmfile") || print "Failed to open $dmfile.\n";
    print DMN $_[0]."\n";;
    close (DMN);
    `/bin/domainname $_[0]`;
}

sub enable_nism {
    `/etc/chkconfig yp on`;
    `/etc/chkconfig ypserv on`;
    `/etc/chkconfig ypmaster on`;

    if ($_[1] eq "") {
	`/usr/OnRamp/bin/inityp -m -d $_[0]`;
    }
    else {
	`/usr/OnRamp/bin/inityp -m -d $_[0] -l $_[1]`;
    }

    $ypbind_options = `cat /usr/etc/ypbind.options`;
    $ypserv_options = `cat /usr/etc/ypserv.options`;

    `/etc/killall ypbind ypserv rpc.passwd`;
    `/usr/etc/ypbind $ypbind_options > /dev/null 2>&1`;
    `/usr/etc/ypserv $ypserv_options > /dev/null 2>&1`;
    `/usr/etc/rpc.passwd /etc/passwd -m passwd > /dev/null 2>&1`;
}

sub disable_nism {
    `/etc/chkconfig ypmaster off`;
    `/etc/chkconfig ypserv off`;
    
    `/etc/killall rpc.passwd ypserv`;
}

sub generic {
    &header_block($title);

    print "<i>$message</i>";

    if ($havenfs != 0) {
	print "<i>NIS is not installed on this System.</i>\n";
	return 0;
    }
    print $query->startform;

    print "<center><table cellpadding=5 width=450>\n";

    print "<tr><th align=left>Enable NIS master server:</th><th align=left>",
	  $query->radio_group(-name=>'nism', -values=>['Yes','No'],
			      -default=>$nism),
	  "</th></tr>";

    print "<tr><th align=left>NIS domain name:</th><th align=left>",
	  $query->textfield('domain', $dmname, 20),
	  "</th></tr>";

    print "<tr><th align=left valign=top>List of NIS slave servers:</th><th align=left>",
	    $query->textarea('slave_list',"", 6),"</th></tr>";


    print "</table></center><br>\n";

    print &buttons("doit", "Ok", "help", "Help");

    print $query->endform;
}
