#!/usr/bin/perl5

# ppp-out.cgi
# Scott A. Hotes, 3 / 29 / 96
# Silicon Graphics
#
# User will only be allowed to edit (or add) entries to ppp.conf
# that correspond to existing configuration lines in the
# /etc/uucp/Systems file, thus insuring (we hope) that the 
# hardware is set up correctly.  Entries in ppp.conf that
# do not correspond to lines in the Systems file will be ignored.
#
# T1 is ignored for now.
# Also, does not deal with multiple isdn phone numbers!
#
# The following items are supported in the configuration file:
# - remotehost (both as IP number or qualified name)
# - localhost (same)
# - send_username
# - send_passwd
# - add_route
# - quiet
#
# Delete and edit both comment-out currently existing accounts.

require "/usr/OnRamp/lib/OnRamp.pm";

$confS = "/etc/uucp/Systems";
$conf = "/etc/ppp.conf";
$temp = "/etc/ppp.conf.temp";
$dummy = "/etc/ppp.conf.temp";
$myname = "ppp-out.cgi";
$title = "Dial-out PPP Accounts";

print "Content-type: text/html\n\n";
&title_block($title);

if ( ! -e "/usr/etc/ppp" ) {
    &header_block($title);
    print "<i>PPP software not installed.  Install subsystem 
		</i><b>eoe.sw.ppp</b><i> from the 6.2 CD.</i>";
    exit 0;
}

&get_fields;

&getAccounts;

if (%fld) {
    $fld{'chosen'} =~ /(\w+)/;
    $name = $1;

    $help = $ENV{"DOCUMENT_ROOT"} . $ENV{"SCRIPT_NAME"};
    $help =~ s/cgi$/hlp/;
    exec $help if ($fld{'help'} eq "Help");

    $hardware = &getHardware($name);

    if ($fld{'edit'}) { 
	&error(2,"To edit, first choose account from list.") if !$fld{'chosen'};
	&putEdit; 
	&editAccount; 
    }
    if ($fld{'doedit'}) { &formValid_doedit; &doEdit; &getAccounts; &generic; }
} else { &generic; }

sub getHardware {
    open(IN,"< $confS");
    while(<IN>) {
	@items = split/\s+/;
	if ($items[0] eq $_[0]) { $hw = $items[2]; last; }
    }
    close(IN);
    if ($hw eq "ACU") { return "Modem"; }
    elsif ($hw eq "ISDN") { return "ISDN"; }
    else { return "T1"; }
}

sub formValid_doadd {
    &error(0,"Invalid login name.") if &deluxe($fld{'login'});
    &error(0,"Invalid password.") if &deluxe($fld{'password'});
    &error(0,"Invalid remote IP address.") if &check_ipaddr($fld{'remote'});
}

sub formValid_doedit {
    &error(1,"Invalid login name.") if deluxe($fld{'login'});
    &error(1,"Invalid password.") if deluxe($fld{'password'});
    if ($fld{'remote'} ne "") {
	&error(1,"Invalid remote IP address.") if &check_ipaddr($fld{'remote'});
    }
}

sub deluxe {
    return 1 if $_[0] =~ /$METACHARS/;
    return 1 if $_[0] =~ /\s/;
    return 1 if length($_[0]) > 8;
    0;
}

sub error {
    &error_block($_[1]);
    %val = %fld;
    if ($_[0] == 0) { &addAccount; }
    elsif ($_[0] == 1) { &editAccount; }
    else { &generic; }
    exit 0;
}

sub putEdit {
    $val{'local'} = $local{$name};
    $val{'remote'} = $remote{$name};
    $val{'login'} = $login{$name};
    $val{'password'} = $password{$name};
    $val{'addRoute'} = $addRoute{$name};
    $val{'quiet'} = $quiet{$name};
}

sub doEdit {
    open(IN,"< $temp");
    $name = <IN>;
    close(IN);
    &clear($temp);
    chop $name;
    if ($name) { &delete($name); }

    &doAdd;

    $message = "Account edited.";
}   

sub clear {
    open(OUT_0,"> $_[0]");
    close(OUT_0);
}
 
sub editAccount {
    &header_block("Edit Dial-out PPP Account");

    print "<form action=$myname method=post>";

    print qq|<input type=hidden name="chosen" value=$name>|;

    print "<center><table cellpadding=5 width=450>";

    print "<tr><th align=left>Connection name:</th><th align=left>$name</th></tr>";

    print "<tr><th align=left>Hardware:</th><th align=left>$hardware</th></tr>";

    undef @list;
    `/usr/OnRamp/bin/htnetwork > $dummy`;
    open(IN,"< $dummy");
    while(<IN>) { 
	@items = split(/:/);
	if ($items[3]) { 
	    push(@list,$items[3]);
	}
    }
    close(IN);

    print "<tr><th align=left>IP address of local host:</th><th align=left>",
	  &select_list('local',$val{'local'},*list),
	  "</th></tr>";

    print "<tr><th align=left>IP address of remote host:</th><th align=left>",
	  &text('remote',$val{'remote'},20),
	  "</th></tr>";

    print "<tr><th align=left>Login name on remote host:</th><th align=left>",
	  &text('login',$val{'login'},20),
	  "</th></tr>";

    print "<tr><th align=left>Password on remote host:</th><th align=left>",
	  &text('password',$val{'password'},20),
	  "</th></tr>";

    print "<tr><th align=left>Add static route to PPP configuration file:
		</th><th align=left>",
	  &radio('addRoute',$val{'addRoute'},'Yes','No'),
	  "</th></tr>";

    print "<tr><th align=left>Disconnect when PPP line is idle:
	    </th><th align=left>",
	  &radio('quiet',$val{'quiet'},'Yes','No'),
	  "</th></tr>";

    print "</table></center><br>";

    print &buttons('doedit','Ok');

    print "</form></body></html>";

    open(OUT,"> $temp");
    print OUT "$name\n";
    close(OUT);
}
    
sub delete {
    $account = $_[0];
    open(IN,"< $conf");
    open(OUT,"> $dummy");
    while(<IN>) {
	$line = $_;
	if ($line =~ /^\s*\#/) { print OUT $line; next; }
	@items = split(/\s+/,$line);
	if ($items[0] eq $account) {
	    print OUT "# $line";
	    $line = <IN>;
	    while ($line ne "\n") {
		print OUT "# $line";
		$line = <IN>;
	    }
	    print OUT $line;
	} else { print OUT $line; }
    }
    close(IN);
    close(OUT);
    rename($dummy,$conf);

    $message = "Account deleted.";	
}

sub doAdd {
    undef @terms;
    $terms[0] = $name;
    if ($fld{'local'}) { push(@terms,'localhost='.$fld{'local'}); }
    if ($fld{'remote'}) { push(@terms,'remotehost='.$fld{'remote'}); }
    if ($fld{'login'}) { push(@terms,'send_username='.$fld{'login'}); }
    if ($fld{'password'}) { push(@terms,'send_passwd='.$fld{'password'}); }
    if ($fld{'addRoute'} eq 'Yes') { push(@terms,'add_route'); }
    if ($fld{'quiet'} eq 'Yes') { push(@terms,'quiet'); }
    &writeFile;
}

sub writeFile {
    $found = 0;
    open(IN,"< $conf");
    open(OUT,"> $dummy");
    while(<IN>) {
	$line = $_;
	if (substr($line,0,5) ne "# Add" || $found) {
	    print OUT $line;
	    next;
	}
	print OUT $line;
	print OUT "\n";
	$found = 1;
	&printAccount;
    }
    if ($found == 0) {
	print OUT "\n";
	&printAccount;
    }
    close(IN);
    close(OUT);
    rename($dummy,$conf);

    $message = "New account added.";
}

sub printAccount {
    print OUT shift(@terms),"\t\t",shift(@terms),"\n";
    while ($#terms >= 0) {
	print OUT "\t\t",shift(@terms),"\n";
    }
    print OUT "\n";
}

sub checkT1 {
    $ret = 0;
    `/usr/bin/hinv > $dummy`;
    open(IN,"< $dummy");
    while(<IN>) {
	@items = split(/\s+/);
	if ($items[0] eq 'GIO') { $ret = 1; }
    }
    close(IN);
    return $ret;
}

sub checkSystem {
    undef @modem;
    undef @isdn;
    undef @t1;
    open(IN,"< $confS");
    while(<IN>) {
	@items = split(/\s+/);
	if ($items[2] eq 'ACU' && substr($items[0],0,1) ne '#') 
	    { push(@modem,$items[0]); $hardware{$items[0]} = "modem";}
	if ($items[2] eq 'ISDN' && substr($items[0],0,1) ne '#') 
	    { push(@isdn,$items[0]); $hardware{$items[0]} = "isdn";}
	if ($items[2] eq 'WAN' && substr($items[0],0,1) ne '#') 
	    { push(@t1,$items[0]); $hardware{$items[0]} = "T1";}
    }
    close(IN);
}

sub getAccounts {
#   $enableT1 = &checkT1;
    &checkSystem;

   if (-r $conf) {
    	open(IN, $conf);
	$mode = "Out";
    	while (<IN>) {
	    $line = $_;
	    if (substr($line,0,1) eq "_") { last; }
	    if ($line =~ /^#/) { next; }
	    
	    if ($line eq "\n") {
		if ($mode eq "Out") { next; }
		else { $mode = "Out"; next; }
	    } 
	    
	    @terms = split(/\s+/,$line);

	    if ($mode eq "Out") {
		$mode = "In";
		$name = shift(@terms);
		$addToArray = 0;
		foreach $arg (@modem) {
		    if ($arg eq $name) { 
			$addToArray = 1;
		    }
		}
		foreach $arg (@isdn) {
		    if ($arg eq $name) { 
			$addToArray = 1; 
		    }
		}
		foreach $arg (@t1) {
		    if ($arg eq $name) { 
			$addToArray = 1; 
		    }
		}
	    }

	    if ($addToArray) {
		foreach $arg (@terms) {
		    if ($arg ne "") {
			($atr,$val) = split(/=/,$arg);
			if    ($atr eq "send_username") { $login{$name} = $val; }
			elsif ($atr eq "send_passwd") { $password{$name} = $val; }
			elsif ($atr eq "add_route") { $addRoute{$name} = "Yes" }
			elsif ($atr eq "localhost") { $local{$name} = $val; }
			elsif ($atr eq "remotehost") { $remote{$name} = $val; }
			elsif ($atr eq "quiet") { $quiet{$name} = "Yes"; }
		    }
		}
   	    }
	}
	close(IN);

	foreach $arg (keys(%hardware)) {
	    if ($quiet{$arg} ne "Yes") { $quiet{$arg} = "No"; }
	    if ($addRoute{$arg} ne "Yes") { $addRoute{$arg} = "No"; }
	}   
    }
}	

sub generic {
    &header_block($title);

    print "<i>$message</i>";

    print "<form action=$myname method=post>";

    if ($#modem + $#isdn + $#t1 > -3) {
	print "<center><br>";

	print "<table width=400><tr><td valign=top>";

	print qq|<input type=submit name="edit" 
	    value="Edit Selected Account">|;
	print "</td><td>";

	push(@modem,@isdn);
	push(@modem,@t1);
	print &choice_list(*modem,"chosen",20);

	print "</td></tr></table>";

	print "</center><br>";
    } else {
	print "<i>To configure dial-out PPP, first configure either
		modem or ISDN hardware.</i>";
    }

    print "</form></body></html>";
}

