#!/usr/bin/perl5

#.........................................................
#..  dns.cgi											..
#..  Scott A. Hotes  3 / 13 / 96						..
#.........................................................

use CGI;
require "/usr/OnRamp/lib/OnRamp.pm";

$query = new CGI;

$resolv_cf = "/etc/resolv.conf";
$title = "Name Resolver";

@order = ("nis", "bind", "local", "none");

print $query->header;
&title_block($title);

if (-r $resolv_cf) { &get_resolv; }

if ($query->param) { 
	$help = $ENV{"DOCUMENT_ROOT"} . $ENV{"SCRIPT_NAME"};
	$help =~ s/cgi$/hlp/;
	exec $help if ($query->param('help') eq "Help");

	if ($query->param('doit') eq 'Ok') {
	    &formValidation; 
	    &makeChanges; }
}

&generic;

sub formValidation {
	my($count, $which);

	foreach $count (1..3) {
		$which = $query->param("nmsrv$count");
		&error("Invalid name server IP address #$count.")
			if $which && &check_ipaddr($which); 
	}

	foreach $count (1..6) {
		$which = $query->param("dmsrch$count");
		&error("Invalid domain name #$which.") 
		    if $which && &check_hostname($which);
	}
}

sub error {
    &error_block($_[0]);
    &generic;
    exit 0;
}    

sub makeChanges {
 	$message = "The requested changes have been made.";

	open(OUT,"> $resolv_cf");
	print OUT "search ",$query->param('dmsrch1')," ",
		$query->param('dmsrch2')," ",$query->param('dmsrch3')," ",
		$query->param('dmsrch4')," ",$query->param('dmsrch5')," ",
		$query->param('dmsrch6'),"\n";
	print OUT "hostresorder";
	if ($query->param('hres1') ne 'none') 
		{ print OUT " ", $query->param('hres1'); }
	if ($query->param('hres2') ne 'none') 
		{ print OUT " ", $query->param('hres2'); }
	if ($query->param('hres3') ne 'none') 
		{ print OUT " ", $query->param('hres3'); }
	print OUT "\n\n";
	if ($query->param('nmsrv1')) { 
		print OUT "nameserver ",$query->param('nmsrv1'),"\n"; }
	if ($query->param('nmsrv2')) { 
		print OUT "nameserver ",$query->param('nmsrv2'),"\n"; }
	if ($query->param('nmsrv3')) { 
		print OUT "nameserver ",$query->param('nmsrv3'),"\n"; }
	close(OUT);
}

sub get_resolv {
    @ch_order = ("nis","bind","local","none");
    open(RESOLV, $resolv_cf);
    while (<RESOLV>) {
	if (/^\s*[#\n]/) {
	    next;
	}
	chop;
	@entlist = split(/\s+/);
	if ($entlist[0] eq "hostresorder") {
	    @ch_order = ("none","none","none","none");
	    for ($i = 1; $i <= $#entlist; $i++) {
		if ( ($entlist[$i] ne "nis") && ($entlist[$i] ne "bind") &&
		     ($entlist[$i] ne "local") ) {
		    print "<p>Illegal option $entlist[$i] in $resolv_cf.";
	    	    @ch_order = ("nis", "bind", "local", "none");
		    last;
		}
		$ch_order[$i-1] = $entlist[$i];
	    }
	}
	elsif ($entlist[0] eq "nameserver") {
	    $nmserver[$#nmserver+1] =  $entlist[1];
	}
	elsif ($entlist[0] eq "domain") {
		$dmname = $entlist[1];
	}
	elsif ($entlist[0] eq "search") {
	    for ($i = 1; $i <= $#entlist, $i <= 6; $i++) {
		$dmsearch[$i-1] =  $entlist[$i];
	    }
	}
	else {
	    print "<p>Illegal option $entlist[0] in $resolv_cf.";
	    last;
	}
    }
    close(RESOLV);
}  

sub generic {
	&header_block($title);

	print $query->startform;

	print "<i>$message</i>";

	print "<h3>Order of services for name and address resolution:</h3>";

	print "<font size=\"+1\"><center><table cellpadding=5 width=450>\n";
	print "<tr><th>First<th>Next<th>Last</tr>\n";

	print "<tr><td align=center>", $query->popup_menu(-name=>'hres1',
						-values=>\@order,
						-default=>$ch_order[0]);
	print "<td align=center>", $query->popup_menu(-name=>'hres2',
						-values=>\@order,
						-default=>$ch_order[1]);
	print "<td align=center>", $query->popup_menu(-name=>'hres3',
						-values=>\@order,
						-default=>$ch_order[2]);
	print "</tr></table></center>";

	print "<h3>Addresses of DNS servers to do name resolution:
		    </h3><center>";

	print "<table cellpadding=5 width=450>";

	print "<tr><td align=center><strong>1</strong>&nbsp;",
	      $query->textfield(-name=>'nmsrv1',
				-default=>$nmserver[0],
				-size=>13,
				-maxlength=>16);
	print "<td align=center><strong>2</strong>&nbsp;",
	      $query->textfield(-name=>'nmsrv2',
				-default=>$nmserver[1],
				-size=>13,
				-maxlength=>16);
	print "<td align=center><strong>3</strong>&nbsp;",
	      $query->textfield(-name=>'nmsrv3',
				-default=>$nmserver[2],
				-size=>13,
				-maxlength=>16);
	print "</tr>";
	print "</table></center></font>";

	print "<p>";
#	print "The Search list for host-name lookup can be specified below.\n",
#      "The search list is normally determined from the local domain name\n",
#      "by default, it begins with the local domain name, then successive\n",
#      "parent domains that have at least two components in their names.\n",
#      "This can be changed by listing the desired domain search path\n",
#      "following the search keyword with spaces or tabs separating the names.\n",
#      "Most resolver queries are attempted using each component of the search\n",
#      "path in turn until a match is found.  This process can be slow and\n",
#      "generates a lot of network traffic if the servers for the listed\n",
#      "domains are not local.  Queries time out if no server is available for\n",
#      "one of the domains.  The search list is limited to six domains with a\n",
#      "total of 256 characters.  The first item in the list becomes the\n",
#      "default domain name, the remaining items are the other domains to\n",
#      "search after the default one.\n";

	print "<h3>List of domains that DNS servers will search:</h3>";
	print "<font size=\"+1\"><center><table  cellpadding=5 width=450>\n";
	print "<tr><td align=center><strong>1</strong>&nbsp;",
	      $query->textfield(-name=>'dmsrch1',
				-default=>$dmsearch[0],
				-size=>13,
				-maxlength=>16);
	print "<td align=center><strong>2</strong>&nbsp;",
	      $query->textfield(-name=>'dmsrch2',
				-default=>$dmsearch[1],
				-size=>13,
				-maxlength=>16);
	print "<td align=center><strong>3</strong>&nbsp;",
	      $query->textfield(-name=>'dmsrch3',
				-default=>$dmsearch[2],
				-size=>13,
				-maxlength=>16),
      	"</tr>";
	print "<tr><td align=center><strong>4</strong>&nbsp;",
	      $query->textfield(-name=>'dmsrch4',
				-default=>$dmsearch[3],
				-size=>13,
				-maxlength=>16);
	print "<td align=center><strong>5</strong>&nbsp;",
	      $query->textfield(-name=>'dmsrch5',
				-default=>$dmsearch[4],
				-size=>13,
				-maxlength=>16);
	print "<td align=center><strong>6</strong>&nbsp;",
	      $query->textfield(-name=>'dmsrch6',
				-default=>$dmsearch[5],
				-size=>13,
				-maxlength=>16);
	print "</tr></table></center><br>";

	&button_table($query, "doit", "Ok", "help", "Help");

	print $query->endform;
}
