#!/usr/bin/perl5

# t1.cgi
# Scott A. Hotes, 3 / 25 / 96
# Silicon Graphics

require "/usr/OnRamp/lib/OnRamp.pm";

$confW = "/etc/config/wsyncd.options";
$dummy = "/etc/config/wsyncd.options.tmp";
$confDev = "/etc/uucp/Devices";
$confSys = "/etc/uucp/Systems";

$myname = "t1-config.cgi";
$title = "T1 Configuration";

print "Content-type: text/html\n\n";
&title_block($title);

&get_fields;

&getCurrentStatus;

$help = $ENV{"DOCUMENT_ROOT"} . $ENV{"SCRIPT_NAME"};
$help =~ s/cgi$/hlp/;
exec $help if ($fld{'help'} eq "Help");

if ($fld{'doit'} eq 'Ok') {
    if ($fld{'enable'} eq 'Yes') { &formValidation; }
    if ($fld{'port'} eq 'Port 1') { 
	$portOn = 0;
	$portOff = 1; 
    }
    else { 
	$portOn = 1;
	$portOff = 0; 
    }

    if ($fld{'enable'} eq 'Yes') { 
	    &turnOnPort($portOn);
	    &turnOffPort($portOff);
	    `/etc/chkconfig wsyncd on`;
	    `/etc/init.d/wsync stop > /dev/null 2>&1`;
	    `/etc/init.d/wsync start > /dev/null 2>&1`;
	    &handleSystems;
	    &handleDevices($portOn);
	    $message = "$fld{'port'} enabled."; 
    } else {
	    &turnOffPort(0);
	    &turnOffPort(1);
	    `/etc/chkconfig wsyncd off`;
	    `/etc/init.d/wsync stop > /dev/null 2>&1`;
	    $message = "T1 disabled";
    }
    if (!$message) { $message = "No change."; }

    &getCurrentStatus;
} elsif ($fld{'port'}) { $message = qq|Use "Ok" button to submit form.|; }

&generic;

sub formValidation {
    &error("Invalid host name.") if &check_login($fld{'name'});
}

sub error {
    &error_block($_[0]);
    &generic;
    exit 0;
}

sub handleDevices {
    $rename = 0;
    $found = 0;
    $dname = "/dev/gsc/wsty0".$_[0];
    open(IN,"< $confDev");
    open(OUT,"> $dummy");
    while(<IN>) {
	@items = split(/\s+/);
	if ($items[0] ne 'WAN') { print OUT $_; next; }
	if ($items[1] ne $dname) {
	    print OUT "# $_";
	    $rename = 1;
	    $found = 1;
	    print OUT qq|WAN $dname - - direct\n|;
	} else { print OUT $_; $found = 1; }
    }
    if (!$found) {
	print OUT qq|WAN $dname - - direct\n|;
	$rename = 1;
    }
    close(IN);
    close(OUT);
    if ($rename) { rename($dummy,$confDev); }
}	
    

sub handleSystems {
    $rename = 0;
    $found = 0;
    open(IN,"< $confSys");
    open(OUT,"> $dummy");
    while(<IN>) {
	@items = split(/\s+/);
	if ($items[2] ne 'WAN') { print OUT $_; next; }
	if ($items[0] ne $fld{'name'}) {
	    print OUT "# $_";
	    $rename = 1;
	    $found = 1;
	    print OUT qq|$fld{'name'} Any WAN - "" "" PPP CONNECTED\n|;
	} else { print OUT $_; $found = 1; }
    }
    if (!$found) {
	print OUT qq|$fld{'name'} Any WAN - "" "" PPP CONNECTED\n|;
	$rename = 1;
    }
    close(IN);
    close(OUT);
    `chmod 600 $confSys`;
    if ($rename) { rename($dummy,$confSys); }
    `chmod 400 $confSys`;
}	

sub turnOffPort {
    $nm = $_[0];

    undef @terms;
    $terms[0] = 'wan0'.$nm;
    if (&lookFor(0,$confW,*terms)) { &comment($confW,*terms); }

    $terms[0] = 'wstyd0'.$nm;
    if (&lookFor(0,$confW,*terms)) { &comment($confW,*terms); }

    $terms[0] = 'wstyd0'.$nm;
    $terms[1] = 'wan0'.$nm;
    if (&lookFor(0,$confW,*terms)) { &comment($confW,*terms); }
}

sub turnOnPort {
    $nm = $_[0];

    undef @terms;
    $terms[0] = 'wan0'.$nm;
    if (&lookFor(1,$confW,*terms)) { &uncomment($confW,*terms); }
    elsif (! &lookFor(0,$confW,*terms)) { 
	&writeTop($confW,"wan0".$nm."\td\t\t/dev/gsc/wan0".$nm); 
    }

    $terms[0] = 'wstyd0'.$nm;
    if (&lookFor(1,$confW,*terms)) { &uncomment($confW,*terms); }
    elsif (! &lookFor(0,$confW,*terms)) { 
	&writeTop($confW,"wstyd0".$nm."\t\td\t/dev/gsc/wstyd0".$nm); 
    }

    $terms[0] = 'wstyd0'.$nm;
    $terms[1] = 'wan0'.$nm;
    if (&lookFor(1,$confW,*terms)) { 
	&uncomment($confW,*terms); }
    elsif (! &lookFor(0,$confW,*terms)) {
	if ($nm == 0) { $let = "D"; } else { $let = "E"; }
	&writeBottom($confW,"$terms[0]\t\t$terms[1]\tWSYNCD_SNID=$let"); 
    }
}

sub writeTop {
    local($file) = $_[0];
    local($value) = $_[1];
    $found = 0;
    open(IN,"< $file");
    open(OUT,"> $dummy");
    while(<IN>) {
	if ($_ eq "%%\n" && $found == 0) {
	    $found = 1;
	    print OUT "$value\n\n%%\n";
	}
	if ($_ eq "\n" && $found == 0) {
	    $found = 1; 
	    print OUT "\n$value\n";
	} else { print OUT $_; }
    }
    close(IN);
    close(OUT);
    rename($dummy,$file);
}	        

sub writeBottom {
    local($file) = $_[0];
    local($value) = $_[1];
    $found = 0;
    open(IN,"< $file");
    open(OUT,"> $dummy");
    while(<IN>) {
	if (substr($_,0,2) eq '%%' && $found == 0) {
	    print OUT "%%\n\n$value\n";
	    $found = 1;
	} else { print OUT $_; }
    }
    if ($found == 0) { print OUT "$value\n"; }
    close(IN);
    close(OUT);
    rename($dummy,$file);
}
   
sub uncomment {
    local($file) = $_[0];
    local(*values) = @_[1];
    open(IN,"< $file");
    open(OUT,"> $dummy");
    $fix = "fix";

    while(<IN>) {
	$line = $_;
	if ($line eq "\n") { print OUT "\n"; next; }
	$fix =~ /(fix)/;
	$line =~ /^\s*\#\s*(\S.*)/;
	$line1 = $1;
	@items = split(/\s+/,$line1);
	$chk = 1;
	for ($ii=0;$ii<=$#values;$ii++) {
	    if ($items[$ii] ne $values[$ii]) { $chk = 0; }
	}
	if ($chk) { print OUT "$line1\n"; }
	else { print OUT $line; }
    }
    close(OUT);
    close(IN);
    rename($dummy,$file);
}

sub comment {	
    local($file) = $_[0];
    local(*values) = @_[1];
    open(IN,"< $file");
    open(OUT,"> $dummy");
    while(<IN>) {
	$line = $_;
	if ($line eq "\n") { print OUT "\n"; next; }
	@items = split(/\s+/,$line);
	$chk = 1;
	for ($ii=0;$ii<=$#values;$ii++) {
	    if ($items[$ii] ne $values[$ii]) { $chk = 0; }
	}
	if ($chk) { print OUT "#$line"; }
	else { print OUT $line; }
    }
    close(OUT);
    close(IN);
    rename($dummy,$file);
}

sub lookFor {
    local($ii);
    local($mode) = $_[0];
    local($file) = $_[1];
    local(*values) = @_[2];
    open(IN,"< $file");
    while(<IN>) {
	$line = $_;
	if ($mode == 1) {
	    $line =~ /^\s*\#\s*(\S.*)/;
	    $line1 = $1;
	} else { $line1 = $line; }
	@items = split(/\s+/,$line1);
	$chk = 1;
	for ($ii=0;$ii<=$#values;$ii++) {
	    if ($items[$ii] ne $values[$ii]) { $chk = 0; }
	}
	if ($chk) { close(IN); return 1; }
    }
    close(IN);
    return 0;
}

# will check for existance of correct, uncommented lines.  does 
# not check for conflicts with other devices (yet)
# Also checks chkconfig status of wsyncd.
sub getCurrentStatus {
    $wsyncd = "/usr/etc/wsyncd";
    if (! -e $wsyncd || !&isT1Board) {
	&header_block($title);
	if (! -e $wsyncd) { $message = "T1 software not installed.  Install subsystems </i><b>wsync.sw.sw</b><i> and
				</i><b>eoe.sw.dlpi</b><i> from the T1 software CD.</i>"; }
	else { $message = "T1 hardware not installed."; }
	print "<i>$message</i>";
	exit 0;
    }

    $port = "Port 1";
    $enable = 'No';
    for ($i=0;$i<2;$i++) {
	$chw[$i] = &checkWsyncd($i);
	if ($chw[$i]) { 
	    $enable = 'Yes';
	    if ($i) { $port = "Port 2"; } 
	}
#	else { $enable = 'No'; }
    }
    `/etc/chkconfig wsyncd`;
    $status = $? >> 8;
    if ($status) { $enable = 'No'; }

    $name = "";
    open(IN,"< $confSys");
    while(<IN>) {
	@items = split(/\s+/);
	if ($items[2] eq 'WAN') { $name = $items[0]; }
    }
    close(IN);
}

sub isT1Board {
    $ret = 0;
    open(IN,"/usr/bin/hinv | ");
    while(<IN>) {
	@items = split(/\s+/);
	if ($items[0] eq 'GIO') { 
	    $ret = 1;
	    $last;
	}
    }
    close(IN);
    return $ret;
}

# here only check that the line is uncommented
sub checkWsyncd {
    $nm = $_[0];
    $beforePercent = 1;
    $check1 = 0;
    $check2 = 0;

    open(IN,"< $confW");
    while(<IN>) {
	$line = $_;
	if (substr($line,0,1) eq '#') { next; }
	if ($line eq "%%\n") {
	    if ($check1 == 0 || $check2 == 0) { return 0; }
	    $beforePercent = 0; next; }
	@items = split(/\s+/,$line);

	if ($beforePercent && $items[0] eq "wan0".$nm) { $check1 = 1; }
	if ($beforePercent && $items[0] eq "wstyd0".$nm) { $check2 = 1; }
	if (!$beforePercent && $items[0] eq 'wstyd0'.$nm) { return 1; }
    }
    close(IN);
    return 0;
}
    
sub generic {
    &header_block($title);

    print "<form action=$myname method=post>";

    print "<i>$message</i>";

    print "<center><table cellpadding=5 width=450>";

#    print "<tr><th></th><th align=left>Port 1</th><th align=left>Port 2</th></tr>";

#    print "<tr><th align=left>Enable T1:</th><th align=left>",
#	  &radio('enable0',$enable[0],'Yes','No'),
#	  "</th><th align=left>",
#	  &radio('enable1',$enable[1],'Yes','No'),
#	  "</th></tr>";

    print qq|<tr><th align=left>Enable T1:</th><th align=left>|,
	    &radio("enable",$enable,"Yes","No"),"</th></tr>";

    print "<tr><th align=left>Port:</th><th align=left>",
	    &radio('port',$port,'Port 1','Port 2'),"</th></tr>";

    print "<tr><th align=left>Connection name for remote system:</th>
		<th align=left>",
	    &text('name',$name,12),"</th></tr>";

    print '</table></center><br>';

    print &buttons('doit','Ok');

    print '</form></body></html>';
}
