#!/bin/sh
#
# Top-level admin script for WebMeter
#
# $Id: webmeter0.frm,v 1.5 1996/05/01 09:02:38 kenmcd Exp $

TRACE=false			# make true to enable tracing
MYTITLE="WebMeter Adminstration for Host `hostname`"

# load common procedures
. ./webmetercommon.cgi

# get current settings
#
_current()
{
    PMCD_STATE="<strong><blink>disabled</blink></strong>"
    WEBLOG_STATE="<strong><blink>disabled</blink></strong>"
    WEBPING_STATE="<strong><blink>disabled</blink></strong>"
    PMLOGGER_STATE="<strong><blink>disabled</blink></strong>"
    CRON_STATE="<strong><blink>disabled</blink></strong>"
    if $IS_ON pmcd
    then
	if [ "`pminfo -f pmcd.numagents | grep value`" != "" ]
	then
	    PMCD_STATE="<strong>enabled</strong> and <strong>active</strong>"
	else
	    PMCD_STATE="<strong>enabled</strong> but <strong><blink>inactive</blink></strong>"
	fi
    fi
    if $IS_ON pmlogger
    then
	if [ "`ps -ef | grep pmlogger | grep -v grep | wc -l | sed -e 's/  *//g'" != "0" ]
	then
	    PMLOGGER_STATE="<strong>enabled</strong> and <strong>active</strong>"
	else
	    PMLOGGER_STATE="<strong>enabled</strong> but <strong><blink>inactive</blink></strong>"
	fi
    fi
    if grep '^weblog[ 	]' /etc/pmcd.conf >/dev/null 2>&1
    then
	if [ "`pminfo -f web.config.numservers | grep value`" != "" ]
	then
	    WEBLOG_STATE="<strong>enabled</strong> and <strong>active</strong>"
	else
	    WEBLOG_STATE="<strong>enabled</strong> but <strong><blink>inactive</blink></strong>"
	fi
    fi
    if grep '^webping[ 	]' /etc/pmcd.conf >/dev/null 2>&1
    then
	if [ "`pminfo -f webping.active | grep value`" != "" ]
	then
	    WEBPING_STATE="<strong>enabled</strong> and <strong>active</strong>"
	else
	    WEBPING_STATE="<strong>enabled</strong> but <strong><blink>inactive</blink></strong>"
	fi
    fi
    if grep '^[^#].*cron.pmcheck' $CRONTAB >/dev/null 2>&1
    then
	if grep '^[^#].*cron.pmdaily' $CRONTAB >/dev/null 2>&1
	then
	    CRON_STATE="<strong>enabled</strong>"
	fi
    fi
}

_default()
{
    :
}

# do default page set up
#
_home()
{
    _preamble "$MYTITLE"
    cat <<End-of-File
<form method="put" action="webmeter0.cgi">
<hr>The Performance Metrics Collection Daemon (<i>pmcd</i>) is
required to manage the collection of all WebMeter performance
information from the local host.
<table>
<tr align=left valign=center><td width=300>Currently <i>pmcd</i> is $PMCD_STATE.
<th width=100><input type=submit name="pmcd" value="Reconfigure"></p>
</tr></table>
The <i>weblog</i> agent may be used to collect information describing
the activity profile of HTTP requests for Web servers running on the
local host.
<table>
<tr align=left valign=center><td width=300>Currently the <i>weblog</i> is $WEBLOG_STATE.
<th width=100><input type=submit name="weblog" value="Reconfigure"></p>
</tr></table>
The <i>webping</i> agent may be used to collect information that measures
the quality of service for HTTP requests to local or remote Web servers.
<table>
<tr align=left valign=center><td width=300>Currently the <i>webping</i> is $WEBPING_STATE.
<th width=100><input type=submit name="webping" value="Reconfigure"></p>
</tr></table>
The WebMeter tools support the collection of archives
of performance data, to assist with retrospective performance analysis and
capacity planning.  The <i>pmlogger</i> utility may be configured to collect
archive logs for local and/or remote hosts.
<table>
<tr align=left valign=center><td width=300>Currently <i>pmlogger</i> is $PMLOGGER_STATE.
<th width=100><input type=submit name="pmlogger" value="Reconfigure"></p>
</tr></table>
The management of the <i>pmlogger</i> archives may be assisted via
assorted tasks run from <i>cron</i>.
<table>
<tr align=left valign=center><td width=300>Currently the <i>pmlogger</i> archive management tasks are $CRON_STATE.
<th width=100><input type=submit name="cron" value="Reconfigure"></p>
</tr></table>
<hr>
</form>
Display man pages:
<a href="webmeterman.cgi?entry=pmcd&from=$0"><i>pmcd</i></a>,
<a href="webmeterman.cgi?entry=pmdaweblog&from=$0"><i>pmdaweblog</i></a>,
<a href="webmeterman.cgi?entry=pmdawebping&from=$0"><i>pmdawebping</i></a>,
<a href="webmeterman.cgi?entry=pmlogger&from=$0"><i>pmlogger</i></a>.
End-of-File
    _postscript
}

# mainline
#
_form
_decode_params pmcd weblog webping pmlogger cron

if [ -n "$pmcd" ]
then
    SCRIPT_NAME=/webmeter1.cgi
    exec `pwd`$SCRIPT_NAME
fi
if [ -n "$weblog" ]
then
    SCRIPT_NAME=/webmeter2.cgi
    exec `pwd`$SCRIPT_NAME
fi
if [ -n "$webping" ]
then
    SCRIPT_NAME=/webmeter3.cgi
    exec `pwd`$SCRIPT_NAME
fi
if [ -n "$pmlogger" ]
then
    SCRIPT_NAME=/webmeter4.cgi
    exec `pwd`$SCRIPT_NAME
fi
if [ -n "$cron" ]
then
    SCRIPT_NAME=/webmeter6.cgi
    exec `pwd`$SCRIPT_NAME
fi

_yyerror "POST, but no recognized action"
_yyerror "Parameters: $PARAMS"
_yyfail
