#!/bin/sh
#
# webping PMDA admin script for WebMeter
#
# $Id: webmeter3.frm,v 1.8 1996/05/01 09:02:50 kenmcd Exp $

TRACE=false			# make true to enable tracing
MYTITLE="<i>webping</i> Agent Administration for Host `hostname`"

# load common procedures
. ./webmetercommon.cgi

# get current settings
#
_current()
{
    PMCD_STATE="<strong><blink>disabled</blink></strong>"
    if $IS_ON pmcd
    then
	if [ "`pminfo -f pmcd.numagents | grep value`" != "" ]
	then
	    PMCD_STATE="<strong>enabled</strong> and <strong>active</strong>"
	else
	    PMCD_STATE="<strong>enabled</strong> but <strong><blink>inactive</blink></strong>"
	fi
    fi
    WEBPING_STATE="<strong><blink>disabled</blink></strong>"
    if grep '^webping[ 	]' /etc/pmcd.conf >/dev/null 2>&1
    then
	webping=true
	webping_yes=checked
	webping_no=
	if [ "`pminfo -f webping.active | grep value`" != "" ]
	then
	    WEBPING_STATE="<strong>enabled</strong> and <strong>active</strong>"
	else
	    WEBPING_STATE="<strong>enabled</strong> but <strong><blink>inactive</blink></strong>"
	fi
	xxx=`grep '^webping[ 	]' /etc/pmcd.conf \
		  | sed -n -e 's/.*-e *//p' | sed -e 's/ .*//'`
	[ "X$xxx" != X ] && delay_in="$xxx"
	xxx=`grep '^webping[ 	]' /etc/pmcd.conf \
		| sed -n -e 's/.*-I *//p' | sed -e 's/ .*//'`
	[ "X$xxx" != X ] && period_in="$xxx"
	xxx=`grep '^webping[ 	]' /etc/pmcd.conf \
		| sed -n -e 's/.*-S *//p' | sed -e 's/ .*//'`
	if [ "X$xxx" != X ]
	then
	    socks=true
	    socks_yes=checked
	    socks_no=
	    eval `echo "$xxx" | sed -e 's/^/s_host_in=/' -e 's/:/ s_port_in=/'`
	fi
    else
	webping=false
	webping_yes=
	webping_no=checked
    fi
}

# restore sane defaults
#
_default()
{
    webping=false
    webping_yes=
    webping_no=checked
    delay_in=0
    delay=0
    period_in=120
    period=120
    socks=false
    socks_yes=
    socks_no=checked
    s_host_in=
    s_host=
    s_port_in=1080
    s_port=1080
    verify=false
    verify_yes=
    verify_no=checked
    url=
    pick=

    # config
    config=`grep '^webping[ 	]' /etc/pmcd.conf \
	    | sed -e 's/.*-c *//' -e 's/ .*//'`
    [ "X$config" = X ] && config=/usr/pcp/config/web/webping.conf
}

# do default page set up
#
_home()
{
    _preamble "$MYTITLE"

    cat <<End-of-File
<form method="post" action="webmeter3.cgi">
<p>Performance data is collected by Performance Metric Domain Agents (PMDAs or
simply &quotagents&quot) under the control of the
Performance Metrics Collection Daemon (<i>pmcd</i>).</p>
The <i>webping</i> agent collects data on quality of service (as measured by
response time for periodic URL probes) for
local and/or remote Web server(s).</p>
End-of-File

    if $IS_ON pmcd
    then
	:
    else
	cat <<End-of-File
<p>At present, <i>pmcd</i> is $PMCD_STATE, and must be enabled <strong>before</strong>
any configuration of the <i>webping</i> agent will be possible.<p>
<strong><input type=submit name="action" value="Reconfigure"></strong> &nbsp <i>pmcd</i>
End-of-File
	return
    fi

    cat <<End-of-File
<p>Currently the <i>webping</i> agent is $WEBPING_STATE.</p>
<p>For most systems, if the <i>webping</i> agent is enabled,
the default options should be appropriate.</p>
<hr>
<table valign=top border=0 cellspacing=0 cellpadding=1 width=450>
<tr valign=baseline align=left><th>Enable the <i>webping</i> agent?
<td><input type=radio name="webping" value="true" $webping_yes > Yes
<input type=radio name="webping" value="false" $webping_no > No
</tr>
End-of-File

    if [ "$webping_yes" = checked ]
    then
	cat <<End-of-File
<tr valign=baseline align=left><th>Probe all URLs once every ...
<td><input type="text" name="period" value="$period_in" size=5 maxlength=5> seconds
</tr>
<tr valign=baseline align=left><th>Delay between consecutive URLs ...
<td><input type="text" name="delay" value="$delay_in" size=5 maxlength=5> milliseconds
</tr>
<tr valign=baseline align=left><th>Require a SOCKS server?
<td><input type=radio name="socks" value="true" $socks_yes > Yes
<input type=radio name="socks" value="false" $socks_no > No
</tr>
<tr valign=baseline align=left><th>SOCKS host or IP address
<td><input type="text" name="s_host" value="$s_host_in" size=20>
</tr>
</tr>
<tr valign=baseline align=left><th>SOCKS port
<td><input type="text" name="s_port" value="$s_port_in" size=5 maxlength=5>
</tr>
End-of-File
    fi

    cat <<End-of-File
<tr valign=baseline align=left><th>Verify configuration outcome?
<td><input type=radio name="verify" value="true" $verify_yes > Yes
<input type=radio name="verify" value="false" $verify_no > No
</tr>
</table>
End-of-File

    if [ "$webping_yes" = checked ]
    then
	cat <<End-of-File
<hr>
<strong>URLs to be "probed"</strong>
<p>
End-of-File
	size=`sed -e '/^#/d' $config | wc -l | sed -e 's/  *//g'`
	[ "X$size" = X ] && size=1
	[ "$size" -gt 5 ] && size=5
	awk <$config '
BEGIN	{ print "<center><tt><select width=300 border=3 name=\"pick\" size='"$size"' multiple>" }
/^\#/	{ next }
	{ print "<option> &nbsp",$1,"&nbsp",$2,"&nbsp" }
END	{ print "</select></tt></center>" }'
	cat <<End-of-File
<p><strong>To Delete URLs</strong>, select one or more from the above list.</p>
<p>
<strong>To Add one URL</strong>,
choose a method
<select name="method">
  <option> GET
  <option> HEAD
</select>
and enter a new URL
<input type="text" name="url" value="" size=35>
End-of-File
    fi

    cat <<End-of-File
<hr>
<center><table border=5 cellpadding=1>
<tr align=center><th width=100><input type=submit name="action" value="Ok">
<th width=100><input type=reset value="Reset">
<th width=100><input type=submit name="action" value="Defaults">
<th width=100><input type=submit name="action" value="Cancel">
<th width=100><input type=submit name="action" value="Help">
</tr>
</center></table>
<hr>
</form>
Display the
<a href="webmeterman.cgi?entry=pmdawebping&from=$0"><i>pmdawebping</i></a>
man page.
End-of-File
    _postscript
}

# mainline
#
_form
_decode_params webping delay period socks s_host s_port pick method url action verify

if [ "$action" = "Cancel" ]
then
    echo "Location: webmeter0.cgi"
    echo
    exit
fi

if [ "$action" = Help ]
then
    echo "Location: http://$SERVER_NAME:$SERVER_PORT/pcpweb/custom.html#webping_PMDA"
    echo
    exit
fi

if [ "$action" = "Reconfigure" ]
then
    echo "Location: webmeter1.cgi"
    echo
    exit
fi

if [ "$action" = Defaults ]
then
    _default
    rm -f /usr/pcp/config/web/webping.conf
fi

if [ "X$url" != X ]
then
    # Add
    #
    echo "$method $url" >>$config
fi

# Delete is a bit harder, because of multiple selections
#
while [ "X$pick" != X ]
do
    eval `echo "$pick" | sed -e 's/^ */method=/' -e 's/  */ url=/' -e 's/ *$//'`
    awk <$config >$tmp.tmp '
$1 == "'$method'" && $2 == "'$url'"	{ next }
					{ print }'
    mv $tmp.tmp $config
    if [ -s $tmp.extra ]
    then
	xxx=`grep "^pick=" $tmp.extra`
	if [ "X$xxx" = X ]
	then
	    pick=
	else
	    eval $xxx
	    awk <$tmp.extra >$tmp.tmp '
BEGIN			{ seen = 0 }
/^pick=/ && seen == 0	{ seen = 1; next }
			{ print }'
	    mv $tmp.tmp $tmp.extra
	fi
    else
	pick=
    fi
done

# Ok, Default or \n from text input
#
if [ "$action" = Ok -o "$action" = Defaults ]
then
    here=`pwd`
    cd /usr/pcp/pmdas/webping
    if $webping
    then
	_trace "Install opts" "period=$period delay=$delay socks=$socks s_host=$s_host sport=$s_port"
	# set up defaults so Install script is deterministic
	./server.sh </dev/null >/dev/null 2>&1
	# both monitor and collector
	echo b >$tmp.cmd
	if [ -f $config ]
	then
	    # keep URLs from /usr/pcp/config/web/webping.conf
	    echo y >>$tmp.cmd
	fi
	# create links
	echo y >>$tmp.cmd
	# no FTP
	echo n >>$tmp.cmd
	if [ ! -f $config ]
	then
	    # use default URLs
	    echo y >>$tmp.cmd
	fi
	if [ "X$period" = X ]
	then
	    _yywarn "<strong>Probe all URLs</strong> period must be non-blank to enable <i>webping</i> agent." "$MYTITLE"
	    exit
	fi
	if echo "$period" | grep '[^0-9]' >/dev/null
	then
	    _yywarn "<strong>Probe all URLs</strong> period must be numeric and non-negative to enable <i>webping</i> agent." "$MYTITLE"
	    exit
	fi
	if [ "X$delay" = X ]
	then
	    _yywarn "<strong>Delay between URLs</strong> period must be non-blank to enable <i>webping</i> agent." "$MYTITLE"
	    exit
	fi
	if echo "$delay" | grep '[^0-9]' >/dev/null
	then
	    _yywarn "<strong>Delay between URLs</strong> period must be numeric and non-negative to enable <i>webping</i> agent." "$MYTITLE"
	    exit
	fi
	# period, delay between URLs, 32K buffers, 20 sec timeout
	( echo "$period"; echo "$delay"; echo 32768; echo 20 ) >>$tmp.cmd
	if $socks
	then
	    if [ "X$s_host" = X ]
	    then
		_yywarn "<strong>SOCKS host</strong> must be non-blank to enable <i>webping</i> agent." "$MYTITLE"
		exit
	    fi
	    if [ "X$s_port" = X ]
	    then
		_yywarn "<strong>SOCKS port</strong> must be non-blank to enable <i>webping</i> agent." "$MYTITLE"
		exit
	    fi
	    if echo "$s_port" | grep '[^0-9]' >/dev/null
	    then
		_yywarn "<strong>SOCKS port</strong> must be numeric and non-negative to enable <i>webping</i> agent." "$MYTITLE"
		exit
	    fi
	    # need socks server, no socks nameserver
	    ( echo y; echo "$s_host"; echo "$s_port"; echo n ) >>$tmp.cmd
	else
	    # no socks
	    echo n >>$tmp.cmd
	fi
	# no proxy
	echo n >>$tmp.cmd
	# IPC via pipe
	echo pipe >>$tmp.cmd
	./Remove >/dev/null 2>&1
	rm -f /var/tmp/webping.log /var/adm/pcplog/webping.log
	PAGER=cat; export PAGER
	./Install >/dev/null 2>&1 <$tmp.cmd
    else
	./Remove >/dev/null 2>&1
    fi
    cd $here
fi

if $verify
then
    _preamble "Status for <i>webping</i> Agent"
    _check_pmda webping.active webping
    _check_log webping
    echo "<hr>Return to the <a href=\"$SCRIPT_NAME\">$MYTITLE</a> page."
    _postscript
    exit
fi

exec `pwd`/webmeter3.cgi
