#!/bin/sh
#
# pmlogger detail admin script for WebMeter
#
# $Id: webmeter5.cgi,v 1.7 1996/05/01 09:03:03 kenmcd Exp $

TRACE=false			# make true to enable tracing
MYTITLE="<i>pmlogger</i> Configuration for Host `hostname`"

# load common procedures
. ./webmetercommon.cgi

# get current settings
#
_current()
{
    _pmlogger_status
    enable=false
    socks=false
    pid=0
    eval `awk -F: <$tmp.status '
$2 == "'$host'" { print "enable=true"
		  print "pid=" $1
		  if ($4 == "y")
		    print "socks=true"
		  print "dir_in=" $5
		  print "config_in=" $6
		}'`
    if $enable
    then
	enable_yes=checked
	enable_no=
	if [ $pid != 0 ]
	then
	    PMLOGGER_STATE="<strong>configured</strong> and <strong>active</strong> (pid $pid)"
	else
	    PMLOGGER_STATE="<strong>configured</strong> but <strong><blink>inactive</blink></strong>"
	fi
	if $socks
	then
	    socks_yes=checked
	    socks_no=
	fi
    else
	PMLOGGER_STATE="<strong><blink>disabled</blink></strong>"
    fi
    xxx=`sed -n -e 's/^\\$SOCKS_SERVER/s_host_in/p' <$CONTROL | sed -e 's/[; ].*//'`
    [ "X$xxx" != X ] && eval $xxx
    xxx=`sed -n -e 's/^\\$SOCKS_PORT/s_port_in/p' <$CONTROL | sed -e 's/[; ].*//'`
    [ "X$xxx" != X ] && eval $xxx
}

# restore sane defaults
#
_default()
{
    enable=true
    enable_yes=checked
    enable_no=
    dir_in=/var/adm/pcplog/$host
    dir=/var/adm/pcplog/$host
    config_in=/usr/pcp/pmlogger/config.webmeter
    config=/usr/pcp/pmlogger/config.webmeter
    socks=false
    socks_yes=
    socks_no=checked
    s_host_in=
    s_host=
    s_port_in=1080
    s_port=1080
    show=false
    show_yes=
    show_no=checked
}

# do default page set up
#
_home()
{
    localhost="<strong>`hostname`</strong>"
    _preamble "$MYTITLE"

    cat <<End-of-File
<form method="post" action="webmeter5.cgi">
<input name=pid value="$pid" type=hidden>
<input name=host value="$host" type=hidden>
This <i>pmlogger</i> instance runs on $localhost to collect and manage
archives of performance data collected from the host <strong>$host</strong>.</p>
<p>Currently this <i>pmlogger</i> instance is $PMLOGGER_STATE.</p>
<p>If <i>pmlogger</i> is enabled,
the default options should be appropriate in most cases.</p>
<hr>
<table valign=top border=0 cellspacing=0 cellpadding=1 width=500>
<tr valign=baseline align=left><th>Enable this <i>pmlogger</i>?
<td><input type=radio name="enable" value="true" $enable_yes > Yes
<input type=radio name="enable" value="false" $enable_no > No
</tr>
<tr valign=baseline align=left><th>Archive directory
<td><input type="text" name="dir" value="$dir_in" size=28>
</tr>
<tr valign=baseline align=left><th>Logger configuration file
<td><input type="text" name="config" value="$config_in" size=33>
</tr>
</tr>
<tr valign=baseline align=left><th>Require a SOCKS server?
<td><input type=radio name="socks" value="true" $socks_yes > Yes
<input type=radio name="socks" value="false" $socks_no > No
</tr>
<tr valign=baseline align=left><th>SOCKS host or IP address
<td><input type="text" name="s_host" value="$s_host_in" size=15>
</tr>
</tr>
<tr valign=baseline align=left><th>SOCKS port
<td><input type="text" name="s_port" value="$s_port_in" size=5 maxlength=5>
</tr>
<tr valign=baseline align=left><th>Show <i>pmlogger</i> configuration file?
<td><input type=radio name="show" value="true" $show_yes > Yes
<input type=radio name="show" value="false" $show_no > No
</tr>
</table>
<hr>
<center><table border=5 cellpadding=1>
<tr align=center><th width=100><input type=submit name="action" value="Ok">
<th width=100><input type=reset value="Reset">
<th width=100><input type=submit name="action" value="Defaults">
<th width=100><input type=submit name="action" value="Cancel">
<th width=100><input type=submit name="action" value="Help">
</tr>
</center></table>
<hr>
</form>
Display the
<a href="webmeterman.cgi?entry=pmlogger&from=$0"><i>pmlogger</i></a>
man page.
End-of-File
    _postscript
}

# mainline
#
if [ "$REQUEST_METHOD" = "GET" -a -z "$QUERY_STRING" ]
then
    # GET and no form data, should never happen
    _yywarn "Form launched without a host specification"
    exit
fi

SAVE_METHOD=$REQUEST_METHOD

_form
_decode_params enable pid dir config socks s_host s_port host action show

if [ "$SAVE_METHOD" = "GET" ]
then
    _default
    _current
    _home
    exit
fi

if [ "$action" = "Cancel" ]
then
    echo "Location: webmeter4.cgi"
    echo
    exit
fi

if [ "$action" = Help ]
then
    echo "Location: http://$SERVER_NAME:$SERVER_PORT/pcpweb/custom.html#Customizing-pmlogger"
    echo
    exit
fi

if [ "$action" = "Reconfigure" ]
then
    echo "Location: webmeter1.cgi"
    echo
    exit
fi

[ "$action" = Defaults -o "$action" = Add ] && _default

# kill off eny running logger
#
[ "$pid" != 0 ] && kill -TERM $pid

# reconfigure the control file
#
rm -f $tmp.cmd
if $enable
then
    if [ "X$dir" = X ]
    then
	_yywarn "<strong>Archive directory</strong> must be non-blank to enable <i>pmlogger</i>."
	exit
    fi
    mkdir -p $dir >/dev/null 2>&1
    err=`mkdir $dir 2>&1`
    if [ ! -d $dir ]
    then
	_yywarn 'Failed to create <strong>Archive directory</strong>:
<br>'"$err"
	exit
    fi
    case "$config"
    in
	"")
	    _yywarn "<strong>Logger configuration file</strong> must be non-blank to enable <i>pmlogger</i>."
	    exit
	    ;;
	/*)
	    if [ ! -f $config ]
	    then
		_yywarn "Cannot find <strong>Logger configuration file</strong>: $config"
		exit
	    fi
	    configpath=$config
	    ;;
	*)
	    if [ ! -f $dir/$config ]
	    then
		_yywarn "Cannot find <strong>Logger configuration file</strong>: $dir/$config"
		exit
	    fi
	    configpath=`echo $dir/$config | sed -e 's/\/\.\//\//'`
	    ;;
    esac
    # if localhost, assumed to be primary
    pflg=n
    [ "$host" = "`hostname`" ] && pflg=y
    sflg=n
    $socks && sflg=y
    if grep "^$host[ 	]" $CONTROL >/dev/null
    then
	echo "/^$host[ 	]/c" >>$tmp.cmd
    else
	echo '$a' >>$tmp.cmd
    fi
    echo "$host	$pflg	$sflg	$dir	-c $config -l ./pmlogger.log" >>$tmp.cmd
    echo '.' >>$tmp.cmd
    if $socks
    then
	if [ "X$s_port" != X ]
	then
	    echo 'g/^\\$SOCKS_PORT=/d' >>$tmp.cmd
	    echo '/^\\$version/a' >>$tmp.cmd
	    echo '$SOCKS_PORT'"=$s_port; export SOCKS_PORT" >>$tmp.cmd
	    echo '.' >>$tmp.cmd
	fi
	if [ "X$s_host" != X ]
	then
	    echo 'g/^\\$SOCKS_SERVER=/d' >>$tmp.cmd
	    echo '/^\\$version/a' >>$tmp.cmd
	    echo '$SOCKS_SERVER'"=$s_host; export SOCKS_SERVER" >>$tmp.cmd
	    echo '.' >>$tmp.cmd
	fi
    fi
else
    # disable
    echo "g/^$host[ 	]/d" >$tmp.cmd
fi

if grep webmeter5.cgi $CONTROL >/dev/null
then
    cat >>$tmp.cmd <<End-of-File
g/webmeter5.cgi/d
\$a
# reconfigured by webmeter5.cgi on `date`
.
w
q
End-of-File
else
    cat >>$tmp.cmd <<End-of-File
\$a

# reconfigured by webmeter5.cgi on `date`
.
w
q
End-of-File
fi

# update the control file
# ed failed if no pat match for g/pat/d ... sigh
#
ex - $CONTROL <$tmp.cmd

if $enable
then
    if [ "$pflg" = y ]
    then
	# this is the primary logger, make sure it will be started correctly
	# now, and at reboot
	$IS_ON pmlogger on
	ed - /etc/config/pmlogger.options <<End-of-File
v/^#/d
g/webmeter5.cgi/d
\$a
-P -c $config -l ./pmlogger.log

# reconfigured by webmeter5.cgi on `date`
.
w
q
End-of-File
    fi
    # start/restart pmlogger
    grep '^\$' $CONTROL >$tmp.ctl
    grep "^$host[ 	]" $CONTROL >>$tmp.ctl
    /usr/pcp/pmlogger/cron.pmcheck -c $tmp.ctl >$tmp.out 2>&1
    # check for success
    _current
    if [ "$enable" = false -o "$pid" = 0 ]
    then
	# failed to start
	_preamble "" "Failed to start <i>pmlogger</i> for host $host"
	echo '<hr><h3>Input Control</h3>'
	echo '<pre><tt><font -1>'
	cat $tmp.ctl
	echo '</font></tt></pre>'
	echo '<hr><h3><i>pmlogger</i>Configuration</h3>'
	echo '<pre><tt><font -1>'
	cat $configpath
	echo '</font></tt></pre>'
	echo '<hr><h3>Output from <i>cron.pmcheck</i></h3>'
	echo '<pre><tt><font -1>'
	cat $tmp.out
	echo '</font></tt></pre>'
	SCRIPT_NAME=/webmeter4.cgi
	echo "<hr>Return to the <a href=\"$SCRIPT_NAME\"><strong><i>pmlogger</i> Administration for Host `hostname`</strong></a> page."
	_postscript
	exit
    fi

    if $show
    then
	# return to the parent of this form, not here
	MYTITLE="<i>pmlogger</i> Administration for Host `hostname`"
	SCRIPT_NAME=/webmeter4.cgi
	from=`echo "$MYTITLE" | sed -e 's/ /+/g'`
	QUERY_STRING="file=$configpath&banner=true&title=<i>pmlogger</i>+Configuration+File&cgi=$SCRIPT_NAME&from=$from"
	export QUERY_STRING
	SCRIPT_NAME=/webmeterfile.cgi
	exec `pwd`/webmeterfile.cgi
    fi
fi

echo "Location: webmeter4.cgi"
echo

exit
