#!/bin/sh
#
# cron job admin script for WebMeter
#
# $Id: webmeter6.frm,v 1.5 1996/05/01 09:03:06 kenmcd Exp $

TRACE=false			# make true to enable tracing
MYTITLE="<i>pmlogger</i> crontab Administration for Host `hostname`"

# load common procedures
. ./webmetercommon.cgi

# get current settings
#
_current()
{
    if grep '^[^#].*cron.pmcheck' $CRONTAB >/dev/null 2>&1
    then
	:
    else
	check=false
	check_yes=
	check_no=checked
    fi
    if grep '^[^#].*cron.pmdaily' $CRONTAB >/dev/null 2>&1
    then
	xxx=`sed -n <$CRONTAB -e '/^[^#].*cron.pmdaily/{
s/.*-k *//
s/ .*//
p
}'`
	[ "X$xxx" != X ] && keep_in=$xxx
    else
	daily=false
	daily_yes=
	daily_no=checked
    fi
}

# restore sane defaults
#
_default()
{
    check=true
    check_yes=checked
    check_no=
    daily=true
    daily_yes=checked
    daily_no=
    keep_in=7
    keep=7
}

# do default page set up
#
_home()
{
    _preamble "$MYTITLE"

    cat <<End-of-File
<form method="post" action="webmeter6.cgi">
<p>The performance archives managed by the <i>pmlogger</i> utility may
benefit from some period management tasks, run as <strong>root</strong>
by <i>cron</i>.</p>
<p>The <strong>check</strong> task periodically interrogates all
configured <i>pmlogger</i> instances and restarts any that are not
currently running.</p>
<p>The <strong>archive management</strong> task is run once a day
to start a new archive for each configured <i>pmlogger</i> instance
and to cull old archives.</p>
<table valign=top border=0 cellspacing=0 cellpadding=1 width=450>
<tr valign=baseline align=left><th>Enable periodic checking?
<td><input type=radio name="check" value="true" $check_yes > Yes
<input type=radio name="check" value="false" $check_no > No
</tr>
<tr valign=baseline align=left><th>Enable daily archive management?
<td><input type=radio name="daily" value="true" $daily_yes > Yes
<input type=radio name="daily" value="false" $daily_no > No
</tr>
<tr valign=baseline align=left><th>Keep archives for ...
<td><input type="text" name="keep" value="$keep_in" size=5 maxlength=5> days
</tr>
</table>
<hr>
<center><table border=5 cellpadding=1>
<tr align=center><th width=100><input type=submit name="action" value="Ok">
<th width=100><input type=reset value="Reset">
<th width=100><input type=submit name="action" value="Defaults">
<th width=100><input type=submit name="action" value="Cancel">
<th width=100><input type=submit name="action" value="Help">
</tr>
</center></table>
<hr>
</form>
Display man pages:
<a href="webmeterman.cgi?entry=cron.pmcheck&from=$0"><i>cron.pmcheck</i></a>,
<a href="webmeterman.cgi?entry=cron.pmdaily&from=$0"><i>cron.pmdaily</i></a>.
End-of-File
    _postscript
}

# mainline
#
_form
_decode_params check daily keep action

if [ "$action" = "Cancel" ]
then
    echo "Location: webmeter0.cgi"
    echo
    exit
fi

if [ "$action" = Help ]
then
    echo "Location: http://$SERVER_NAME:$SERVER_PORT/pcpweb/custom.html#Sample-cron-scripts"
    echo
    exit
fi

[ "$action" = Defaults ] && _default

# Ok or defaults or \n in last input widget
echo 'g/cron.pmcheck/d' >$tmp.cmd
echo 'g/cron.pmdaily/d' >>$tmp.cmd
rm -f $tmp.tmp; touch $tmp.tmp
$check && echo "25,55	*	*	*	*	/usr/pcp/pmlogger/cron.pmcheck" >>$tmp.tmp
if $daily
then
    if [ "X$keep" = X ]
    then
	_yywarn "<strong>Keep</strong> must be non-blank to enable the daily <strong>archive management</strong> task." "$MYTITLE"
	exit
    fi
    if echo "$keep" | grep '[^0-9]' >/dev/null
    then
	_yywarn "<strong>Keep</strong> must be numeric and non-negative to enable the daily <strong>archive management</strong> task." "$MYTITLE"
	exit
    fi
    echo "10	0	*	*	*	/usr/pcp/pmlogger/cron.pmdaily -k $keep" >>$tmp.tmp
fi
if [ -s $tmp.tmp ]
then
    echo '$a' >>$tmp.cmd
    cat $tmp.tmp >>$tmp.cmd
    echo '.' >>$tmp.cmd
fi
echo w >>$tmp.cmd
echo q >>$tmp.cmd

ex - $CRONTAB <$tmp.cmd
killall -HUP cron

exec `pwd`/webmeter6.cgi
