#!/bin/sh
#
# Run a "man" command in a local winterm window ...
# only works because we _know_ the Web server is on the same host as the
# X server
#
# $Id: webmeterman.cgi,v 1.4 1996/05/01 09:03:14 kenmcd Exp $

TRACE=false			# make true to enable tracing

# load common procedures
. ./webmetercommon.cgi

DISPLAY=$REMOTE_ADDR:0.0; export DISPLAY
TERM=aris-ansi; export TERM

# mainline
#
if [ -z "$QUERY_STRING" ]
then
    # no bindings, first time here
    _yyerror "Missing man page specification"
    echo "args: $*"
else
    # response read from $QUERY_STRING, expected to be of the
    # form
    #	name=value&name=value&name=value&...
    #
    SFS="$IFS"
    IFS='&$IFS'
    set - $QUERY_STRING
    IFS="$SFS"
    for arg
    do
	_trace arg "$arg"
	case "$arg"
	in
	    # recognized variable assignments
	    #
	    entry=*|from=*)
		eval `echo "$arg" | sed -e 's/+/ /g'`
		;;
	    
	    # debug
	    #
	    debug=*)
		eval $arg
		set $debug
		;;

	    # bogus?
	    #
	    *)
		_yyerror "Unknown variable assignment: $arg"
		;;
	esac
    done
fi

# check for errors and setup
_yycheck

# Note.  close all fd's so the Web server does not hang around waiting for
#	the winterm to exit
# 
winterm -hold -title "UNIX Programmer's Manual Entry - $entry" -e man $entry >/dev/null 2>&1 </dev/null &

unset QUERY_STRING CONTENT_LENGTH
REQUEST_METHOD=GET; export REQUEST_METHOD
SCRIPT_NAME=/$from: export SCRIPT_NAME

exec $from

exit 0
