#!/usr/bin/perl5

# Tasks.connect-start.cgi
# Scott A. Hotes, 3 / 29 / 96
# Silicon Graphics

require "/usr/OnRamp/lib/OnRamp.pm";

$myname = "Tasks.connect-start.cgi";
$temp = "task.tmp";
$data = "task.dummy";

$it = "<td align=right>";
$ni = "</td>";
$bo = "<td><font size=5><i>";
$nb = "</i></font></td>";

@find_vals = ('provider','nameserver','domain');

read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@fields = split('&',$buffer);

foreach (@fields) {
  @line = split('=',$_);
  $line[1] =~ tr/+/ /; 
  $fld{$line[0]} = $line[1];
}

# clear temporary file for initial call
if (!$ARGV[0]) {
    open(OUT,"> $temp");
    close(OUT);

    open(IN,"/usr/bsd/hostname | ");
    $host = <IN>; chomp($host);
    if ($host) { ($host, $dum1, $dum2, $dum3, @dum4) 
					= gethostbyname($host); }
    $host =~ /^\w+\.([\w\.]+)$/;
    $vals{'domain'} = $1;
} elsif ($ARGV[0] eq 'loop') { %vals = %fld;  }
  else { &readValues; }

if ($fld{'right.x'}) {
   &errorCheck;
   &writeFile;

    $go = "tasks/connect-second.cgi?st";
    printf("Location: ../%s%c%c",$go,10,10); 
}

&generic;

sub readValues {
    open(IN,"< $temp");
    while(<IN>) {
	@items = split(/=/);
	foreach $arg (@find_vals) {
	    if ($arg eq $items[0]) { 
		if ($items[1] ne "\n") {
		    $vals{$arg} = $items[1];
		    chop $vals{$arg};
		}
	    }
	}
    }
    close(IN);
}

sub errorCheck {
    &error("The domain name is required.") if !$fld{'domain'};
    &error("The domain name is invalid.") if &check_hostname($fld{'domain'});
    &error("Provider IP address is required.") if !$fld{'provider'};
    &error("Nameserver IP address is required.") if !$fld{'nameserver'};
    &error("Provider IP address is invalid.") if &check_ipaddr($fld{'provider'});
    &error("Nameserver IP address is invalid.") if &check_ipaddr($fld{'nameserver'});       
}

sub error {
    $error = $_[0];
    &generic;
    exit 0;
}
    
sub writeFile {
    undef %terms;
    open(IN,"< $temp");
    while(<IN>) {
	@items = split(/=/);
	chop $items[1];
	$terms{$items[0]} = $items[1];
    }
    close(IN);
    foreach $arg (@find_vals) {
	$terms{$arg} = $fld{$arg};
    }
    open(OUT,"> $temp");
    foreach $arg (keys(%terms)) {
	print OUT "$arg=$terms{$arg}\n";
    }
    close(OUT);
}

sub generic {
    print "Content-type: text/html\n\n";
    print "<html><body bgcolor='c7ded4' background=/tasks/connect-task.bg.gif>";

    if ($error) {
	print "<font size=4 color=ff0000><b>Error: </b>$error<br></font>";
    }

    print "<i>$message</i>";

    print '<table width=100%>',
	  '<tr><th align=left><h1>Connect to the Internet</h1></th>',
	  '<th align=right>',
	  '<a href="/newsplash.shtml"><img border=0 src="/tasks/home.gif"></a>',
	  '&nbsp&nbsp<a href="/tasks/Tasks.shtml"><img border=0 src="/tasks/back.gif"></a>',
	  '</tr></table>';

    print qq|<form action="Tasks.connect-start.cgi?loop" method=post>|;
    
    print '<center>';

    print '<table width=620>';

    print "<tr><td colspan=2 align=left><font size=\"4\">",
	  "Welcome to Task Setup for your WebFORCE Internet Gateway. ",
	  "Before beginning this quick setup of your system, be sure you ",
	  "have received all of your network configuration information ",
	  "from your local Internet Service Provider.<br><br>",
	  "</font></td></tr>";

    print "<tr>$bo Domain name from your Internet service provider: $nb $it", 
	    &text("domain",$vals{'domain'},15), 
	    "$ni </tr>";

print "<tr><td colspan=2>
This is the current domain name for your organization. Your organization
will be known by this name on the Internet.
<br><br>
</td></tr><tr><td>&nbsp</td></tr>";

    print "<tr>$bo IP address of your Internet service provider: $nb $it", 
	    &text("provider",$vals{'provider'},15), 
	    "$ni </tr>";

print "<tr><td colspan=2>
Your Internet Gateway connects to a host at your ISP site; enter the IP
address of your ISP host in this field. Your ISP provides you with this
address. (Example: 199.26.43.8).
<br><br>
</td></tr><tr><td>&nbsp</td></tr>";

    print "<tr>$bo IP address of the remote name server: $nb $it", 
	    &text("nameserver",$vals{'nameserver'},15), 
	    "$ni </tr>";

print "<tr><td colspan=2>
Your Internet Gateway translates hostnames to IP addresses for your
local domain. For hostnames outside your domain, it forwards a request to a
remote nameserver. Your ISP provides you with this address. (Example:
199.26.43.8).
</td></tr><tr><td>&nbsp</td></tr>";

    print "</table>";

    print '</center>';

    print '<center>';

    print '</center><br>';

    print '<input name="right" type="image" border=0 
		src="/tasks/rightarrow.gif" align="right">';

    print "</form></body></html>";
}
