#!/usr/bin/perl5

# connect-ether-fddi.cgi
# Scott A. Hotes, 3 / 29 / 96
# Silicon Graphics

require "/usr/OnRamp/lib/OnRamp.pm";

if (!$ARGV[0]) { printf("Location: ../%s%c%c","tasks/Tasks.connect-start.cgi",10,10); } 

$myname = "connect-ether-fddi.cgi";
$temp = "task.tmp";

$it = "<td align=right><font size=4>";
$ni = "</font></td>";
$bo = "<td><font size=5><i>";
$nb = "</i></font></td>";

@find_vals = ('interface','address','netmask');

read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@fields = split('&',$buffer);

foreach (@fields) {
  @line = split('=',$_);
  $line[1] =~ tr/+/ /; 
  $fld{$line[0]} = $line[1];
}

&getList;

if ($ARGV[0] eq 'loop') { %vals = %fld; }
else { &readValues; }

if ($fld{'left.x'}) {
#    &errorCheck;
#    &writeFile;

    printf("Location: ../%s%c%c","tasks/connect-second.cgi?e",10,10);
}
 
if ($fld{'right.x'}) {
    &errorCheck;
   &writeFile;

    printf("Location: ../%s%c%c","tasks/connect-end.cgi?e",10,10); 
}


&generic;

sub get_iflabel {
    $_ = $_[0];
    if( (/^et]/) || (/^ec/) || (/^ee/) || (/^enp/) ) {
	$lb = "Ethernet $_";
    }
    elsif (/^egl/) {
	$lb = "EFast Eagle $_";
    }
    elsif (/^fxp/) {
	$lb = "EFast FXP $_";
    }
    elsif (/^ep/) {
	$lb = "EPlex Ether $_";
    }
    elsif (/^ipg/) {
	$lb = "FDDIXPress $_";
    }
    elsif (/^xpi/) {
	$lb = "FDDI $_";
    }
    elsif ( (/^fv/) || (/^mtr/) || (/^gtr/) ) {
	$lb = "TokenRing $_";
    }
    else {
	$lb = $_;
    }
    $lb;
}

sub readValues {
    open(IN,"< $temp");
    while(<IN>) {
	@items = split(/=/);
	foreach $arg (@find_vals) {
	    if ($arg eq $items[0]) { 
		if ($items[1] ne "\n") {
		    $vals{$arg} = $items[1];
		    chop $vals{$arg};
		}
	    }
	}
    }
    close(IN);
}

sub errorCheck {
    &error("Network interface IP address required.") if !$fld{'address'};
    &error("Invalid IP address.") if &check_ipaddr($fld{'address'});
    &error("Netmask required.") if !$fld{'netmask'};
    &error("Invalid netmask.") if &check_netmask($fld{'netmask'});
}

sub error {
    $error = $_[0];
    %vals = %fld;
    @items = split(/\s+/,$vals{'interface'});
    $vals{'interface'} = $items[1];
    &generic;
    exit 0;
}
    
sub writeFile {
    undef %terms;
    open(IN,"< $temp");
    while(<IN>) {
	@items = split(/=/);
	chop $items[1];
	$terms{$items[0]} = $items[1];
    }
    close(IN);
    foreach $arg (@find_vals) {
	$terms{$arg} = $fld{$arg};
    }
    open(OUT,"> $temp");
    foreach $arg (keys(%terms)) {
	print OUT "$arg=$terms{$arg}\n";
    }
    close(OUT);
}

sub getList {
    undef @IFlist;
    undef @IPlist;
    open(IN,"/usr/OnRamp/bin/htnetwork | ");
    $needMask = 1;
    while(<IN>) {
	@items = split(/:/);
	if ($items[0] ne '0') {
	    if ($needMask) { 
		$vals{'netmask'} = $items[4];
		$vals{'address'} = $items[3]; 
		$needMask = 0; } 
	    push(@IFlist,$items[1]); 
	    push(@IPlist,$items[2]); 
	}
    }
    close(IN);
}

sub generic {
    print "Content-type: text/html\n\n";
    print "<html><body bgcolor='ccc28f' background=/tasks/connect-task.bg.gif>";

    if ($error) {
	print "<font size=4 color=ff0000><b>Error: </b>$error<br></font>";
    }

    print '<table width=100%>',
	  '<tr><th align=left><h1>Ethernet-FDDI Configuration</h1></th>',
	  '<th align=right>',
	  '<a href="/newsplash.shtml"><img border=0 src="/tasks/home.gif"></a>',
	  '&nbsp&nbsp<a href="/tasks/Tasks.shtml"><img border=0 src="/tasks/back.gif"></a>',
	  '</tr></table>';

    print qq|<form action="connect-ether-fddi.cgi?loop" method=post>|;
    
    print '<center>'; 

    print '<table width=620>';

    undef @locList;
    for($i=0;$i<=$#IFlist;$i++) {
	$label = &get_iflabel($IFlist[$i]);
	push(@locList,"$label");
    }

    print "<tr>$bo Device name for the network interface: $nb $it", 
	    &select_list("interface",$vals{'interface'},*locList),
	    "$ni </tr>";

print "<tr><td colspan=2>
The IRIX operating system assigns a device name to each network interface 
that it detects on the Internet Gateway when the system is powered 
on. Select the device name of the interface that you plan to use for the
connection to your Internet service provider.
</td></tr><tr><td>&nbsp</td></tr>";

    print "<tr>$bo IP address of the network interface: $nb $it", 
	    &text("address",$vals{'address'},15),
	    "$ni </tr>";

print "<tr><td colspan=2>
Each network interface must be assigned an IP address that identifies it
to the network. An Internet address has four parts: each part, or octet, is
separated by dots and contains a decimal value in the range of 0 to 255. A
portion of the address (usually the first two or three octets) designates a
network, and the remaining octet designates a host on the network.
You ISP should have assigned you an address to use for this interface,
or a range of addresses from which you must assign one.
</td></tr><tr><td>&nbsp</td></tr>";

    print "<tr>$bo Netmask for your network: $nb $it",
	    &text("netmask",$vals{'netmask'},15), 
	    "$ni </tr>";

print "<tr><td colspan=2>
A network mask is applied to an Internet address to designate the portion
of the address that identifies the host. Enter your network mask in dot notation
(four dot-separated numbers) or as a hexadecimal number.  Your ISP should
have specified the network mask for this network.

</td></tr>";

    print "</table>";

    print '</center><br>';

    print '<input name="right" type="image" border=0 
		src="/tasks/rightarrow.gif" align="right">';
    print '<input name="left" type="image" border=0 
		src="/tasks/leftarrow.gif" align="right">';

    print "</form></body></html>";
}
