#!/usr/bin/perl5

# connect-isdn.cgi
# Scott A. Hotes, 3 / 29 / 96
# Silicon Graphics

require "/usr/OnRamp/lib/OnRamp.pm";

if (!$ARGV[0]) { printf("Location: ../%s%c%c","tasks/Tasks.connect-start.cgi",10,10); } 

$myname = "connect-isdn.cgi";
$temp = "task.tmp";

$it = "<td align=right><font size=4>";
$ni = "</font></td>";
$bo = "<td><font size=5><i>";
$nb = "</i></font></td>";

@find_vals = ('switch','phone','spid1','spid2');

read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@fields = split('&',$buffer);

foreach (@fields) {
  @line = split('=',$_);
  $line[1] =~ tr/+/ /; 
  $fld{$line[0]} = $line[1];
}

if ($ARGV[0] eq 'loop') { %vals = %fld; }
else { &readValues; }

if ($fld{'left.x'}) {
#    &errorCheck;
#    &writeFile;

    printf("Location: ../%s%c%c","tasks/connect-second.cgi?i",10,10);
}
 
if ($fld{'right.x'}) {
    &errorCheck;
    &writeFile;

    printf("Location: ../%s%c%c","tasks/connect-end.cgi?i",10,10); 
}


&generic;

sub readValues {
    open(IN,"< $temp");
    while(<IN>) {
	@items = split(/=/);
	foreach $arg (@find_vals) {
	    if ($arg eq $items[0]) { 
		if ($items[1] ne "\n") {
		    $vals{$arg} = $items[1];
		    chop $vals{$arg};
		}
	    }
	}
    }
    close(IN);
}

sub errorCheck {
    &error("Phone number required.") if !$fld{'phone'};
    &error("Invalid phone number.") if &check_phone($fld{'phone'});
    if ($fld{'switch'} eq 'DMS100' || $fld{'switch'} eq 'NI1') {
	&error("Two SPID numbers required for switch type $fld{'switch'}.")
	    if (!$fld{'spid1'} || !$fld{'spid2'});
	&error("Invalid SPID number: $fld{'spid1'}.") if $fld{'spid1'} =~ /[^0-9]/;
	&error("Invalid SPID number: $fld{'spid2'}.") if $fld{'spid2'} =~ /[^0-9]/;
    }
}

sub error {
    $error = $_[0];
    &generic;
    exit 0;
}
    
sub writeFile {
    $fld{'phone'} =~ s/\(//g;
    $fld{'phone'} =~ s/\)//g;
    $fld{'phone'} =~ s/\-//g;
    $fld{'phone'} =~ s/\,//g;
    $fld{'phone'} =~ s/ //g;

    undef %terms;
    open(IN,"< $temp");
    while(<IN>) {
	@items = split(/=/);
	chop $items[1];
	$terms{$items[0]} = $items[1];
    }
    close(IN);
    foreach $arg (@find_vals) {
	$terms{$arg} = $fld{$arg};
    }
    open(OUT,"> $temp");
    foreach $arg (keys(%terms)) {
	print OUT "$arg=$terms{$arg}\n";
    }
    close(OUT);
}

sub generic {
    print "Content-type: text/html\n\n";
    print "<html><body bgcolor='c7ded4' background=/tasks/connect-task.bg.gif>";

    if ($error) {
	print "<font size=4 color=ff0000><b>Error: </b>$error<br></font>";
    }

    print '<table width=100%>',
	  '<tr><th align=left><h1>ISDN Configuration</h1></th>',
	  '<th align=right>',
	  '<a href="/newsplash.shtml"><img border=0 src="/tasks/home.gif"></a>',
	  '&nbsp&nbsp<a href="/tasks/Tasks.shtml"><img border=0 src="/tasks/back.gif"></a>',
	  '</tr></table>';

    print qq|<form action="connect-isdn.cgi?loop" method=post>|;
    
    print '<table width=620>';

    print "<tr>$bo Phone number of your service provider: $nb $it",
	    &text("phone",$vals{'phone'},15), 
	    "$ni </tr>";

print "<tr><td colspan=2>
To connect to the Internet, the Gateway places a call over
the ISDN line to a host at the service provider's site. The phone number
is required to reach the host, just as a phone number is required for a
standard voice call. (Your ISP supplies this phone number.)
</td></tr><tr><td>&nbsp</td></tr>";

    print "<tr>$bo Switch used by your service provider: $nb $it", 
	    &select("switch",$vals{'switch'},
	    'DMS100',
	    'NI1',
	    '5ESS',
	    'NTT',
	    'NET3',
	    '1TR6',
	    'VN3',
	    'TPH'), 
	    "$ni </tr>";

print "<tr><td colspan=2>
Your ISDN configuration must be set to the type of switching equipment
that your ISDN provider uses. This options menu contains a list of commonly
used switch types from which to select. (Switch types, and the additional 
information that some switches require, is specified by your ISDN provider.)
</td></tr><tr><td>&nbsp</td></tr>";

    print "</table><table width=620>";

     print "<tr>$bo SPID numbers: $nb $it",
	    &text("spid1",$vals{'spid1'},15), "$ni $it",
	    &text("spid2",$vals{'spid2'},15), 
	    "$ni </tr>";

print "<tr><td colspan=3>
If your provider uses DMS100 or NI1 switches, SPID numbers are required.
These numbers identify the available services on your ISDN line. (Your 
ISDN provider supplies SPID numbers.)
</td></tr><tr><td>&nbsp</td></tr>";

    print "</table>";

    print '</center><br>';

#    print "<i>Note:  SPID numbers required only for DMS100 and NI1
#		switch types.</i><br>";

    print '<input name="right" type="image" border=0 
		src="/tasks/rightarrow.gif" align="right">';
    print '<input name="left" type="image" border=0 
		src="/tasks/leftarrow.gif" align="right">';

    print "</form></body></html>";
}

