### Generate Fig. 2; RN, May 2019

#required functions--------------
source("R-Functions_CFR.R")

# load workspaces if required-----------------
#load("general_definitions.RData")
#load("fields.RData")


# 51-year filtered data------------------
fields50<-lapply(fields,function(x) aperm(apply(x,c(1,2),function(y) tsfilt(ts(y),51,"bw")),c(2,3,1)))
#save(fields50,file="fields50.RData")
#load("fields50.RData")


# anomalies over the full 1-2000 period ---------------------------
fields.fa<-lapply(fields, function(x) aperm(apply(x,c(1,2), function(y) anomalies.period(ts(y,start=1),1,2000)),c(2,3,1)))
fields50.fa<-lapply(fields50, function(x) aperm(apply(x,c(1,2), function(y) anomalies.period(ts(y,start=1),1,2000)),c(2,3,1)))

# define tresholds for temperature ranges in plot ------------------
mi<-min(unlist(lapply(fields.fa,min,na.rm=T)))
ma<-max(unlist(lapply(fields.fa,max,na.rm=T)))
anom.treshs.raw<-c(mi,seq(-1,1,by=0.2),ma)

mi<-min(unlist(lapply(fields50.fa,min,na.rm=T)))
ma<-max(unlist(lapply(fields50.fa,max,na.rm=T)))
anom.treshs.50<-c(mi,seq(-0.5,0.5,by=0.1),ma)

# calculated area fractions for each temperature range ---------

#unfiltered
anom.treshs<-anom.treshs.raw
nanoms.raw<-list()
nanoms.cs.raw<-list()
for(exp in 1:nexp){  #loop over experiments
  nanoms.raw[[exp]]<-array(dim=c(2000,length(anom.treshs)-1))
  nanoms.cs.raw[[exp]]<-nanoms.raw[[exp]]
  for (y in 1:2000){ #loop over years
    fx<-fields.fa[[exp]][,,y]
    for(a in 1:(length(anom.treshs)-1)){
      fxs<-array(dim=c(72,36,1),data=0)
      fxs[which(fx>anom.treshs[a] & fx<anom.treshs[a+1] )]<-1
      nanoms.raw[[exp]][y,a]<-latweightmean.field(fxs,lats = lats)
    }
    nanoms.cs.raw[[exp]][y,1:((length(anom.treshs)-1)/2)]<-cumsum(nanoms.raw[[exp]][y,1:((length(anom.treshs)-1)/2)])
    nanoms.cs.raw[[exp]][y,((length(anom.treshs)-1)/2+1):(length(anom.treshs)-1)]<-cumsum(nanoms.raw[[exp]][y,(length(anom.treshs)-1):((length(anom.treshs)-1)/2+1)])
    print(c(exp,y))
  }
}


#50 year filtered
anom.treshs<-anom.treshs.50
nanoms.50<-list()
nanoms.cs.50<-list()
for(exp in 1:nexp){
  nanoms.50[[exp]]<-array(dim=c(2000,length(anom.treshs)-1))
  nanoms.cs.50[[exp]]<-nanoms.50[[exp]]
  for (y in 1:2000){
    fx<-fields50.fa[[exp]][,,y]
    for(a in 1:(length(anom.treshs)-1)){
      fxs<-array(dim=c(72,36,1),data=0)
      fxs[which(fx>anom.treshs[a] & fx<anom.treshs[a+1] )]<-1
      nanoms.50[[exp]][y,a]<-latweightmean.field(fxs,lats = lats)
    }
    nanoms.cs.50[[exp]][y,1:((length(anom.treshs)-1)/2)]<-cumsum(nanoms.50[[exp]][y,1:((length(anom.treshs)-1)/2)])
    nanoms.cs.50[[exp]][y,((length(anom.treshs)-1)/2+1):(length(anom.treshs)-1)]<-cumsum(nanoms.50[[exp]][y,(length(anom.treshs)-1):((length(anom.treshs)-1)/2+1)])
    print(c(exp,y))
  }
}


# average over experiments --------------------
nanoms.all.50<-array(dim=c(2000,length(anom.treshs.50)-1))
nanoms.all.raw<-array(dim=c(2000,length(anom.treshs.raw)-1))

for(a in 1:(length(anom.treshs)-1)){
  nanoms.all.50[,a]<-apply(cbind.list(lapply(nanoms.cs.50,function(x) x[,a])),1,mean,na.rm=T)
  nanoms.all.raw[,a]<-apply(cbind.list(lapply(nanoms.cs.raw,function(x) x[,a])),1,mean,na.rm=T)
}

# Make the figure PDF ---------------------
lxs<-2010
lxe<-2050
cext<-1

pdf("Fig_2.pdf",width=7.2,height=4.8)
	par(mfrow=c(2,1))
	par(mai=c(0.01,0.8,0.5,0.8))
	plot(NA,xlim=c(-10,2010),ylim=c(-1,1),ylab="",xlab="",axes=F,xaxs="i")
	axis(3,at=seq(0,2000,by=200),cex.axis=cext,mgp=c(3,0.6,0))
	axis(3,at=seq(0,2000,by=100),labels=F)
	axis(2,tick=seq(-1,1,by=0.1),labels=F)
	axis(2,at=seq(-1,1,by=0.5),labels=c(100,50,0,50,100),las=2,cex.axis=cext)
	tspolygon(lower = ts(rep(0,2000),1),upper = ts(nanoms.all.raw[,7],1),col=rgb(1,0,0,0.1))
	tspolygon(lower = ts(rep(0,2000),1),upper = ts(nanoms.all.raw[,8],1),col=rgb(1,0,0,0.1))
	tspolygon(lower = ts(rep(0,2000),1),upper = ts(nanoms.all.raw[,9],1),col=rgb(1,0,0,0.1))
	tspolygon(lower = ts(rep(0,2000),1),upper = ts(nanoms.all.raw[,10],1),col=rgb(1,0,0,0.1))
	tspolygon(lower = ts(rep(0,2000),1),upper = ts(nanoms.all.raw[,11],1),col=rgb(1,0,0,0.1))
	tspolygon(lower = ts(rep(0,2000),1),upper = ts(nanoms.all.raw[,12],1),col=rgb(1,0,0,0.1))
	tspolygon(lower = ts(rep(0,2000),1),upper = ts(nanoms.all.raw[,1],1)*-1,col=rgb(0,0,1,0.1))
	tspolygon(lower = ts(rep(0,2000),1),upper = ts(nanoms.all.raw[,2],1)*-1,col=rgb(0,0,1,0.1))
	tspolygon(lower = ts(rep(0,2000),1),upper = ts(nanoms.all.raw[,3],1)*-1,col=rgb(0,0,1,0.1))
	tspolygon(lower = ts(rep(0,2000),1),upper = ts(nanoms.all.raw[,4],1)*-1,col=rgb(0,0,1,0.1))
	tspolygon(lower = ts(rep(0,2000),1),upper = ts(nanoms.all.raw[,5],1)*-1,col=rgb(0,0,1,0.1))
	tspolygon(lower = ts(rep(0,2000),1),upper = ts(nanoms.all.raw[,6],1)*-1,col=rgb(0,0,1,0.1))
	rect(lxs,0,lxe,1,col=rgb(1,0,0,0.1),border=NA,xpd=T)  
	rect(lxs,0.166,lxe,1,col=rgb(1,0,0,0.1),border=NA,xpd=T)  
	rect(lxs,0.33,lxe,1,col=rgb(1,0,0,0.1),border=NA,xpd=T)  
	rect(lxs,0.5,lxe,1,col=rgb(1,0,0,0.1),border=NA,xpd=T)  
	rect(lxs,0.66,lxe,1,col=rgb(1,0,0,0.1),border=NA,xpd=T)  
	rect(lxs,0.833,lxe,1,col=rgb(1,0,0,0.1),border=NA,xpd=T)  
	rect(lxs,-0,lxe,-1,col=rgb(0,0,1,0.1),border=NA,xpd=T)  
	rect(lxs,-0.166,lxe,-1,col=rgb(0,0,1,0.1),border=NA,xpd=T)  
	rect(lxs,-0.33,lxe,-1,col=rgb(0,0,1,0.1),border=NA,xpd=T)  
	rect(lxs,-0.5,lxe,-1,col=rgb(0,0,1,0.1),border=NA,xpd=T)  
	rect(lxs,-0.66,lxe,-1,col=rgb(0,0,1,0.1),border=NA,xpd=T)  
	rect(lxs,-0.833,lxe,-1,col=rgb(0,0,1,0.1),border=NA,xpd=T)  
	axis(4,at=seq(-1+1/6,1-1/6,by=1/6),labels=F,las=2,cex.axis=cext,line=0.6)
	axis(4,at=seq(-1+1/6,1-1/6,by=1/6)[seq(2,10,2)],anom.treshs.raw[seq(3,11,2)],las=2,cex.axis=cext,mgp=c(3,0.6,0),line=0.6,tick=F)
	text(-160,1.2,"a",cex=cext,xpd=T,font=2)
	par(mai=c(0.6,0.8,0.2,0.8))
	plot(NA,xlim=c(-10,2010),ylim=c(-1,1),ylab="",xlab="",axes=F,xaxs="i")
	axis(1,at=seq(0,2000,by=200),cex.axis=cext,mgp=c(3,0.6,0))
	axis(1,at=seq(0,2000,by=100),labels=F)
	axis(2,tick=seq(-1,1,by=0.1),labels=F)
	axis(2,at=seq(-1,1,by=0.5),labels=c(100,50,0,50,100),las=2,cex.axis=cext)
	tspolygon(lower = ts(rep(0,1950),26),upper = ts(nanoms.all.50[26:1975,7],26),col=rgb(1,0,0,0.1))
	tspolygon(lower = ts(rep(0,1950),26),upper = ts(nanoms.all.50[26:1975,8],1),col=rgb(1,0,0,0.1))
	tspolygon(lower = ts(rep(0,1950),26),upper = ts(nanoms.all.50[26:1975,9],1),col=rgb(1,0,0,0.1))
	tspolygon(lower = ts(rep(0,1950),26),upper = ts(nanoms.all.50[26:1975,10],1),col=rgb(1,0,0,0.1))
	tspolygon(lower = ts(rep(0,1950),26),upper = ts(nanoms.all.50[26:1975,11],1),col=rgb(1,0,0,0.1))
	tspolygon(lower = ts(rep(0,1950),26),upper = ts(nanoms.all.50[26:1975,12],1),col=rgb(1,0,0,0.1))
	tspolygon(lower = ts(rep(0,1950),26),upper = ts(nanoms.all.50[26:1975,1],1)*-1,col=rgb(0,0,1,0.1))
	tspolygon(lower = ts(rep(0,1950),26),upper = ts(nanoms.all.50[26:1975,2],1)*-1,col=rgb(0,0,1,0.1))
	tspolygon(lower = ts(rep(0,1950),26),upper = ts(nanoms.all.50[26:1975,3],1)*-1,col=rgb(0,0,1,0.1))
	tspolygon(lower = ts(rep(0,1950),26),upper = ts(nanoms.all.50[26:1975,4],1)*-1,col=rgb(0,0,1,0.1))
	tspolygon(lower = ts(rep(0,1950),26),upper = ts(nanoms.all.50[26:1975,5],1)*-1,col=rgb(0,0,1,0.1))
	tspolygon(lower = ts(rep(0,1950),26),upper = ts(nanoms.all.50[26:1975,6],1)*-1,col=rgb(0,0,1,0.1))
	rect(lxs,0,lxe,1,col=rgb(1,0,0,0.1),border=NA,xpd=T)  
	rect(lxs,0.166,lxe,1,col=rgb(1,0,0,0.1),border=NA,xpd=T)  
	rect(lxs,0.33,lxe,1,col=rgb(1,0,0,0.1),border=NA,xpd=T)  
	rect(lxs,0.5,lxe,1,col=rgb(1,0,0,0.1),border=NA,xpd=T)  
	rect(lxs,0.66,lxe,1,col=rgb(1,0,0,0.1),border=NA,xpd=T)  
	rect(lxs,0.833,lxe,1,col=rgb(1,0,0,0.1),border=NA,xpd=T)  
	rect(lxs,-0,lxe,-1,col=rgb(0,0,1,0.1),border=NA,xpd=T)  
	rect(lxs,-0.166,lxe,-1,col=rgb(0,0,1,0.1),border=NA,xpd=T)  
	rect(lxs,-0.33,lxe,-1,col=rgb(0,0,1,0.1),border=NA,xpd=T)  
	rect(lxs,-0.5,lxe,-1,col=rgb(0,0,1,0.1),border=NA,xpd=T)  
	rect(lxs,-0.66,lxe,-1,col=rgb(0,0,1,0.1),border=NA,xpd=T)  
	rect(lxs,-0.833,lxe,-1,col=rgb(0,0,1,0.1),border=NA,xpd=T)  
	axis(4,at=seq(-1+1/6,1-1/6,by=1/6),labels=F,las=2,cex.axis=cext,line=0.6)
	axis(4,at=seq(-1+1/6,1-1/6,by=1/6)[seq(2,10,2)],labels=anom.treshs.50[seq(3,11,2)],las=2,cex.axis=cext,mgp=c(3,0.6,0),line=0.6,tick=F)
	mtext(side=4,"Temperature anomaly [°C wrt 1-2000]",padj=4.7,adj=-0.2,cex=cext)
	mtext(side=2,"Percentage of global surface area",padj=-4.5,adj=-0.5,cex=cext)
	mtext(side=1,"Year CE",padj=3,cex=cext)
	text(-160,1.2,"b",cex=cext,xpd=T,font=2)
dev.off()
