### Generate Figs. 3-4; RN, mMy 2019

#required functions--------------
source("R-Functions_CFR.R")


#required packages---------------
require(RNetCDF)
library(foreach)
library(parallel)
library(doParallel)
library(RColorBrewer)
library(zoo)
library(fields)

# load workspaces if required -----------------
#load("general_definitions.RData")
#load("fields.RData")

# definitions ---------
period.length<-51

nens.do<-100
 
period.names<-c("LIA","MCA","DACP","RWP","CWP")
period.names.long<-c("Little Ice Age",
                     "Medieval Climate Anomaly",
                     "Dark Ages Cold Period",
                     "Roman Warm Period",
                     "Current Warm Period")
periods<-c("lia","mca","dacp","rwp","all")


range.lia<-c(1001,2000)
range.mca<-c(751,1350)
range.dacp<-c(1,1000)
range.rwp<-c(1,750)
range.all<-c(1,2000)

#number of cores for parallel computations
ncores<-20

 
 # colours for the plots --------------------------
 colorbystep<-100
 mrange.lia<-seq(floor(range.lia[1]/100)*100,ceiling(range.lia[2]/100)*100+1,by=colorbystep)
 
 xc<-brewer.pal(length(mrange.lia)-1,"Purples")
 xc.warm<-brewer.pal(length(mrange.lia)-1,"Oranges")
 
 cols.lia<-(designer.colors(n=length(mrange.lia)-1,col=xc))
 
 mrange.mca<-seq(floor(range.mca[1]/100)*100,ceiling(range.mca[2]/100)*100+1,by=colorbystep)
 cols.mca<-(designer.colors(n=length(mrange.mca)-1,col=xc.warm))
 mrange.dacp<-seq(floor(range.dacp[1]/100)*100,ceiling(range.dacp[2]/100)*100+1,by=colorbystep)
 cols.dacp<-(designer.colors(n=length(mrange.dacp)-1,col=xc))
 mrange.rwp<-seq(floor(range.rwp[1]/100)*100,ceiling(range.rwp[2]/100)*100+1,by=colorbystep)
 cols.rwp<-(designer.colors(n=length(mrange.rwp)-1,col=xc.warm))
 mrange.all<-seq(floor(range.all[1]/100)*100,ceiling(range.all[2]/100)*100+1,by=colorbystep)
 cols.all<-(designer.colors(n=length(mrange.all)-1,col=xc.warm))


## timing analyses over ensembles.------------


midyear.lia<-list()
midyear.mca<-list()
midyear.dacp<-list()
midyear.rwp<-list()
midyear.all<-list()

sy<-ceiling(period.length/2)

range.yrs<-(1+sy-1):(2000-sy+1)
s.lia<-which(range.yrs==range.lia[1]+sy-1)
e.lia<-which(range.yrs==range.lia[2]-sy+1)
s.mca<-which(range.yrs==range.mca[1]+sy-1)
e.mca<-which(range.yrs==range.mca[2]-sy+1)
s.dacp<-which(range.yrs==range.dacp[1]+sy-1)
e.dacp<-which(range.yrs==range.dacp[2]-sy+1)
s.rwp<-which(range.yrs==range.rwp[1]+sy-1)
e.rwp<-which(range.yrs==range.rwp[2]-sy+1)
s.all<-which(range.yrs==range.all[1]+sy-1)
e.all<-which(range.yrs==range.all[2]-sy+1)


gc()

cl <- makeCluster(ncores)
registerDoParallel(cl)



clusterExport(cl, c("rollmean","period.length"), envir = .GlobalEnv)

ptm<-proc.time()

for(exp in seq_along(methods)){
  #get filenames
  fname<-paste0(recon.folder,methods[exp],".nc")
  nc<-open.nc(fname)
  
  midyear.lia[[exp]]<-array(dim=c(nlon,nlat,nens.do),data=NA)
  midyear.mca[[exp]]<-array(dim=c(nlon,nlat,nens.do),data=NA)
  midyear.dacp[[exp]]<-array(dim=c(nlon,nlat,nens.do),data=NA)
  midyear.rwp[[exp]]<-array(dim=c(nlon,nlat,nens.do),data=NA)
  midyear.all[[exp]]<-array(dim=c(nlon,nlat,nens.do),data=NA)

  for (xe in 1:2){
    
    fullens<-var.get.nc(nc,nc.vars.methods,c(1,1,(xe-1)*50+1,1),c(72,36,50,2000))
    
    print(c("full ensemble read in ",exp))
    
    trx<-parApply(cl,fullens,c(1,2,3),function(x) rollmean(x,period.length))
    midyear.lia[[exp]][,,((xe-1)*50+1):(xe*50)]<-apply(trx[s.lia:e.lia,,,],c(2,3,4),function(x) which.min(x))+range.lia[1]+sy-2
    midyear.mca[[exp]][,,((xe-1)*50+1):(xe*50)]<-apply(trx[s.mca:e.mca,,,],c(2,3,4),function(x) which.max(x))+range.mca[1]+sy-2
    midyear.dacp[[exp]][,,((xe-1)*50+1):(xe*50)]<-apply(trx[s.dacp:e.dacp,,,],c(2,3,4),function(x) which.min(x))+range.dacp[1]+sy-2
    midyear.rwp[[exp]][,,((xe-1)*50+1):(xe*50)]<-apply(trx[s.rwp:e.rwp,,,],c(2,3,4),function(x) which.max(x))+range.rwp[1]+sy-2
    midyear.all[[exp]][,,((xe-1)*50+1):(xe*50)]<-apply(trx[s.all:e.all,,,],c(2,3,4),function(x) which.max(x))+range.all[1]+sy-2

    rm(fullens)
    rm(trx)
    gc()
  }
  close.nc(nc)
  
  print(c(exp))
  print((proc.time()-ptm)[3])
}


#save(midyear.lia,midyear.mca,midyear.dacp,midyear.rwp,midyear.all,file=paste0("Midyears_LIA_MCA_DACP_RWP_",period.length,"_years.RData"))
#load(paste0("Midyears_LIA_MCA_DACP_RWP_",period.length,"_years.RData"))


## combine methods --------------------
lia.max.mean.all<-array(dim=c(nlon,nlat,nens.do*length(methods)),data=0)
mca.max.mean.all<-array(dim=c(nlon,nlat,nens.do*length(methods)),data=0)
dacp.max.mean.all<-array(dim=c(nlon,nlat,nens.do*length(methods)),data=0)
rwp.max.mean.all<-array(dim=c(nlon,nlat,nens.do*length(methods)),data=0)
all.max.mean.all<-array(dim=c(nlon,nlat,nens.do*length(methods)),data=0)


n<-0
for(exp in seq_along(methods)){
    lia.max.mean.all[,,((exp-1)*nens.do+1):(exp*nens.do)]<-midyear.lia[[exp]]
    mca.max.mean.all[,,((exp-1)*nens.do+1):(exp*nens.do)]<-midyear.mca[[exp]]
    dacp.max.mean.all[,,((exp-1)*nens.do+1):(exp*nens.do)]<-midyear.dacp[[exp]]
    rwp.max.mean.all[,,((exp-1)*nens.do+1):(exp*nens.do)]<-midyear.rwp[[exp]]
    all.max.mean.all[,,((exp-1)*nens.do+1):(exp*nens.do)]<-midyear.all[[exp]]
    print(exp)
}

#century with most ensemble members ----------------------

#results are very similar to using the ensemble mode and then binning by century
lia.max.mean.all.maxc<-apply(lia.max.mean.all,c(1,2),function(x)  as.numeric(names(table(x<-floor(x/100)*100))[which.max(table(x<-floor(x/100)*100))])+1)
mca.max.mean.all.maxc<-apply(mca.max.mean.all,c(1,2),function(x)  as.numeric(names(table(x<-floor(x/100)*100))[which.max(table(x<-floor(x/100)*100))])+1)
dacp.max.mean.all.maxc<-apply(dacp.max.mean.all,c(1,2),function(x)  as.numeric(names(table(x<-floor(x/100)*100))[which.max(table(x<-floor(x/100)*100))])+1)
rwp.max.mean.all.maxc<-apply(rwp.max.mean.all,c(1,2),function(x)  as.numeric(names(table(x<-floor(x/100)*100))[which.max(table(x<-floor(x/100)*100))])+1)
all.max.mean.all.maxc<-apply(all.max.mean.all,c(1,2),function(x)  as.numeric(names(table(x<-floor(x/100)*100))[which.max(table(x<-floor(x/100)*100))])+1)

# Make Fig. 3 --------------------
layoutmatrix<-(cbind(c(0,0.35,0.655,1/6,1/2),
                     c(0.35,0.655,1,1/2,5/6),
                     c(0.5,0.5,0.5,0.02,0.02),
                     c(1,1,1,0.5,0.5)))


withincommands<-c("axis(3,at=lon.ax.fields[c(2,4,6,8)],labels=lonsmapgrid.signs[c(2,4,6,8)],cex.axis=cexs)",
                  "lines(field.proj$wm,lwd=4,col=1)",
                  "lines(field.proj$gridlines,col=linescol)")
lx<-3
cexs<-1.8
cext<-2
linescol<-"grey"

pdf(paste0("Fig_3.pdf"),width=19*1.05, height=12*1.05)
	split.screen(layoutmatrix)
	screen(1)
	par(mai=c(0.4,0.8,1.2,0.1))
	titlex<-"title(main=paste0(period.names.long[4],\" [\",range.rwp[1],\"-\",range.rwp[2],\"]\"),cex.main=cext,line=lx)"
	ax2<-"axis(2,at=field.proj$lataxat,labels=field.proj$latsmapgrid,las=2,cex.axis=cexs)"
	tx<-"text(-17866303,9.995155e+06,\"a\",font=2,xpd=T,cex=cexs)"
	image.plot3(field.proj$lons,field.proj$lats,rwp.max.mean.all.maxc[field.proj$xo,],col.lab="white",
				col.axis="white",tck=0,col = cols.rwp,breaks = mrange.rwp,legend.lab = "Year CE",
				legend.line = 3,legend.mar = 5,horizontal = T,legend.cex = cexs,axis.args=list(cex.axis=cexs),
				withincommands=c(withincommands,titlex,ax2,tx))
	screen(2)
	par(mai=c(0.4,0.01,1.2,0.1))
	titlex<-"title(main=paste0(period.names.long[2],\" [\",range.mca[1],\"-\",range.mca[2],\"]\"),cex.main=cext,line=lx)"
	ax2<-""
	tx<-"text(-17866303,9.995155e+06,\"b\",font=2,xpd=T,cex=cexs)"
	image.plot3(field.proj$lons,field.proj$lats,mca.max.mean.all.maxc[field.proj$xo,],col.lab="white",
				col.axis="white",tck=0,col = cols.mca,breaks = mrange.mca,legend.lab = "Year CE",
				legend.line = 3,legend.mar = 5,horizontal = T,legend.cex = cexs,axis.args=list(cex.axis=cexs),
				withincommands=c(withincommands,titlex,ax2,tx))
	screen(3)
	par(mai=c(0.4,0.01,1.2,0.8))
	titlex<-"title(main=paste0(period.names.long[5],\" [\",range.all[1],\"-\",range.all[2],\"]\"),cex.main=cext,line=lx)"
	ax2<-"axis(4,at=field.proj$lataxat,labels=field.proj$latsmapgrid,las=2,cex.axis=cexs)"
	tx<-"text(-17866303,9.995155e+06,\"c\",font=2,xpd=T,cex=cexs)"
	image.plot3(field.proj$lons,field.proj$lats,all.max.mean.all.maxc[field.proj$xo,],col.lab="white",
				col.axis="white",tck=0,col = cols.all,breaks = mrange.all,legend.lab = "Year CE",
				legend.line = 3,legend.mar = 5,horizontal = T,legend.cex = cexs,axis.args=list(cex.axis=cexs),
				withincommands=c(withincommands,titlex,ax2,tx))
	screen(4)
	par(mai=c(0.4,0.6,1.2,0.1))
	titlex<-"title(main=paste0(period.names.long[3],\" [\",range.dacp[1],\"-\",range.dacp[2],\"]\"),cex.main=cext,line=lx)"
	ax2<-"axis(2,at=field.proj$lataxat,labels=field.proj$latsmapgrid,las=2,cex.axis=cexs)"
	tx<-"text(-17866303,10.105155e+06,\"d\",font=2,xpd=T,cex=cexs)"
	image.plot3(field.proj$lons,field.proj$lats,dacp.max.mean.all.maxc[field.proj$xo,],col.lab="white",
				col.axis="white",tck=0,col = cols.dacp,breaks = mrange.dacp,legend.lab = "Year CE",
				legend.line = 3,legend.mar = 5.7,horizontal = T,legend.cex = cexs,axis.args=list(cex.axis=cexs),
				withincommands=c(withincommands,titlex,ax2,tx))
	screen(5)
	par(mai=c(0.4,0.01,1.2,0.6))
	titlex<-"title(main=paste0(period.names.long[1],\" [\",range.lia[1],\"-\",range.lia[2],\"]\"),cex.main=cext,line=lx)"
	ax2<-"axis(4,at=field.proj$lataxat,labels=field.proj$latsmapgrid,las=2,cex.axis=cexs)"
	tx<-"text(-17866303,9.995155e+06,\"e\",font=2,xpd=T,cex=cexs)"
	image.plot3(field.proj$lons,field.proj$lats,lia.max.mean.all.maxc[field.proj$xo,],col.lab="white",
				col.axis="white",tck=0,col = cols.lia,breaks = mrange.lia,legend.lab = "Year CE",
				legend.line = 3,legend.mar = 5.7,horizontal = T,legend.cex = cexs,axis.args=list(cex.axis=cexs),
				withincommands=c(withincommands,titlex,ax2,tx))
	close.screen( all=TRUE)
dev.off()



## Timing analyses over noise fields ----------------------------
nens.noise<-100

midyear.lia.noise.r<-array(dim=c(nlon,nlat,nens.noise*length(methods)))
midyear.mca.noise.r<-array(dim=c(nlon,nlat,nens.noise*length(methods)))
midyear.dacp.noise.r<-array(dim=c(nlon,nlat,nens.noise*length(methods)))
midyear.rwp.noise.r<-array(dim=c(nlon,nlat,nens.noise*length(methods)))
midyear.all.noise.r<-array(dim=c(nlon,nlat,nens.noise*length(methods)))

for(exp in 1:length(methods)){
  
  #for(n in 1:nens.noise){
  midyears.r<-foreach(n = 1:nens.noise,.packages = c("mgcv","zoo")) %dopar% {
    noisy<-ts(generate.rmvn.ar(t(array(fields[[exp]][,,1:2000],dim=c(nlon*nlat,2000))),n=2000))

    trx<-apply(noisy,2,function(x) rollmean(x,period.length))
    midyear.lia.noise.ix<-array(apply(trx[s.lia:e.lia,],2,function(x) which.min(x))+range.lia[1]+sy-2,dim=c(nlon,nlat))
    midyear.mca.noise.ix<-array(apply(trx[s.mca:e.mca,],2,function(x) which.max(x))+range.mca[1]+sy-2,dim=c(nlon,nlat))
    midyear.dacp.noise.ix<-array(apply(trx[s.dacp:e.dacp,],2,function(x) which.min(x))+range.dacp[1]+sy-2,dim=c(nlon,nlat))
    midyear.rwp.noise.ix<-array(apply(trx[s.rwp:e.rwp,],2,function(x) which.max(x))+range.rwp[1]+sy-2,dim=c(nlon,nlat))
    midyear.all.noise.ix<-array(apply(trx[s.all:e.all,],2,function(x) which.max(x))+range.all[1]+sy-2,dim=c(nlon,nlat))
    
    list(lia=midyear.lia.noise.ix,
         mca=midyear.mca.noise.ix,
         dacp=midyear.dacp.noise.ix,
         rwp=midyear.rwp.noise.ix,
         all=midyear.all.noise.ix)
  }
  
  for(n in 1:nens.noise){
    midyear.lia.noise.r[,,(exp-1)*nens.noise+n]<-midyears.r[[n]]$lia
    midyear.mca.noise.r[,,(exp-1)*nens.noise+n]<-midyears.r[[n]]$mca
    midyear.dacp.noise.r[,,(exp-1)*nens.noise+n]<-midyears.r[[n]]$dacp
    midyear.rwp.noise.r[,,(exp-1)*nens.noise+n]<-midyears.r[[n]]$rwp
    midyear.all.noise.r[,,(exp-1)*nens.noise+n]<-midyears.r[[n]]$all
  }
  
  print(exp)
}

# save(midyear.lia.noise.r,midyear.mca.noise.r,midyear.dacp.noise.r,midyear.rwp.noise.r,midyear.all.noise.r,
#       file=paste0("Midyears_LIA_MCA_DACP_RWP_",period.length,"_noise_rmvn-recons.RData"))

#load(paste0("Midyears_LIA_MCA_DACP_RWP_",period.length,"_noise_rmvn-recons.RData"))



##analysis for fig. 4 ------------
latweights<-cos(lats*pi/180)
latweights.2d<-array(rep(latweights,each=nlon),dim=c(nlon,nlat))
latweights.sum<-sum(latweights.2d)
latweights<-as.vector(latweights.2d)
period.length.cases<-50
sl2<-floor(period.length.cases/2)


writestring<-c()

for(p in 1:length(period.names)){
  range<-get(paste0("range.",periods[p]))
  midyear<-get(paste0("midyear.",periods[p]))
  maxcases<-c()
  ncases.inperiod<-array(dim=c(length(range[1]:range[2])-period.length.cases,nens.do*length(methods)))
  
  midyear.noise.r<-get(paste0("midyear.",periods[p],".noise.r"))
  maxcases.noise.r<-c()
  ncases.inperiod.noise.r<-array(dim=c(length(range[1]:range[2])-period.length.cases+1,nens.do*length(methods)))
  
  n.exp<-1
  for(exp in 1:length(methods)){
    n<-1
    for(y in (range[1]+sl2):(range[2]-sl2)){
      selx<-apply(midyear[[exp]][,,1:nens.do],3,function(x) which(x %in% ((y-sl2):(y+sl2))))
      if(length(selx)==0) selx<-rep(0,nens.do)
      ncases.inperiod[n,((n.exp-1)*nens.do+1):(n.exp*nens.do)]<-unlist(lapply(selx,function(x) sum(latweights[x])/latweights.sum))
      if(n.exp==1){
          selx<-apply(midyear.noise.r,3,function(x) which(x %in% ((y-sl2):(y+sl2))))
        if(length(selx)==0) selx<-rep(0,dim(midyear.noise.r)[3])
        ncases.inperiod.noise.r[n,]<-unlist(lapply(selx,function(x) sum(latweights[x])/latweights.sum))
      }
      n<-n+1                    
    }
    n.exp<-n.exp+1
    print(c(p,n.exp))
  }
  
  maxcases<-apply(ncases.inperiod,2,which.max)
  maxcases.frac<-apply(ncases.inperiod,2,function(x) x[which.max(x)])  
  assign(paste0("maxcases.",periods[p]),maxcases)
  assign(paste0("maxcases.frac.",periods[p]),maxcases.frac)
  assign(paste0("ncases.inperiod.",periods[p]),ncases.inperiod)

  maxcases.noise.r<-apply(ncases.inperiod.noise.r,2,which.max)
  maxcases.frac.noise.r<-apply(ncases.inperiod.noise.r,2,function(x) x[which.max(x)])  
  assign(paste0("maxcases.",periods[p],".noise.r"),maxcases.noise.r)
  assign(paste0("maxcases.frac.",periods[p],".noise.r"),maxcases.frac.noise.r)
  assign(paste0("ncases.inperiod.",periods[p],".noise.r"),ncases.inperiod.noise.r)
 
  writestring<-c(writestring,paste0("maxcases.",periods[p]),paste0("maxcases.frac.",periods[p]),paste0("ncases.inperiod.",periods[p]),
                 paste0("maxcases.",periods[p],".noise.r"),paste0("maxcases.frac.",periods[p],".noise.r"),paste0("ncases.inperiod.",periods[p],".noise.r"))
  print(p)
}

#save(list=writestring,file=paste0("Maxcases_periods_",period.length,"yrs.RData"))
#load(paste0("Maxcases_periods_",period.length,"yrs.RData"))


##define shading for fig. 4--------------------
shad.int<-seq(0,1,by=0.1)

maxcases.noise.r.dens<-c()
for(p in 1:length(period.names)){
  maxcases.frac.noise.r<-get(paste0("maxcases.frac.",periods[p],".noise.r"))
  x<-as.vector(table(cut(maxcases.frac.noise.r,shad.int,include.lowest = TRUE)))
  x<-x/max(x)*0.5
  maxcases.noise.r.dens<-rbind(maxcases.noise.r.dens,x)
}
#Lia and dacp are of the same lenght so can be combined to be more robust
maxcases.frac.noise.r<-c(maxcases.frac.lia.noise.r,maxcases.frac.dacp.noise.r)
x<-as.vector(table(cut(maxcases.frac.noise.r,shad.int,include.lowest = TRUE)))
x<-x/max(x)*0.5
maxcases.noise.r.dens[1,]<-x
maxcases.noise.r.dens[3,]<-x

##test differenc of distributions -------------------
wilctests.maxcases.frac.noise.r<-c()

for(p in 1:length(period.names)){
  maxcases.frac<-get(paste0("maxcases.frac.",periods[p]))
  maxcases.frac.noise.r<-get(paste0("maxcases.frac.",periods[p],".noise.r"))
  wilctests.maxcases.frac.noise.r[p]<-wilcox.test(maxcases.frac,maxcases.frac.noise.r,alternative = "g")$p.value
}


# Prepare boxplots for fig. 4 ----------
bx.warm<-list(maxcases.frac.rwp,
              maxcases.frac.mca,
              maxcases.frac.all)

bx.cold<-list(maxcases.frac.dacp*-1,maxcases.frac.lia*-1)
bxp.warm<-bxp.q(bx.warm,min=0.05,max=0.95)
bxp.cold<-bxp.q(bx.cold,min=0.05,max=0.95)

#Make Fig. 4 ----------------------

exp.cols.selexp.members<-rep(exp.cols,each=nens.do)
start.all.plot<-range.mca[2]+1 #start of MWP for shading

cext<-0.7

pdf(paste0("Fig_4.pdf"),width=7.2,height=3.86)
	par(mai=c(0.6,0.6,0.3,0.06))
	plot(1,t="n",xlim=c(0,2380),ylim=c(-1,1),axes=F,xlab="",ylab="",cex.laby=cext,xaxs="i")
	box()
	axis(1,at=seq(0,2000,by=200),labels=seq(0,2000,by=200),cex.axis=cext,tick=F,padj = -1)
	axis(1,at=seq(0,2000,by=100),labels=NA,cex.axis=cext)
	axis(2,las=2,at=0,labels=0,cex.axis=cext)
	axis(2,las=2,at=seq(0.2,1,by=0.2),labels=seq(0.2,1,by=0.2),col.axis = 2,col.ticks = 2,cex.axis=cext)
	axis(2,las=2,at=seq(-0.2,-1,by=-0.2),labels=seq(0.2,1,by=0.2),col.ticks=4,col.axis=4,cex.axis=cext)
	abline(h=0)
	lines(rep(range.lia[1],2),c(0,-1));lines(rep(range.lia[2],2),c(-1,1))
	lines(rep(range.mca[1],2),c(0,1));lines(rep(range.mca[2],2),c(0,1))
	#lines(c(1,1),c(-1,1))
	for(i in 1:(length(shad.int)-1)){
	  rect(range.lia[1],shad.int[i]*-1,range.lia[2],shad.int[i+1]*-1,col=rgb(0,0,0,maxcases.noise.r.dens[1,i]),border = NA)
	}
	points(maxcases.lia+range.lia[1]+floor(period.length/2)-1,maxcases.frac.lia*-1,col=exp.cols.selexp.members,bg=exp.cols.selexp.members,pch=21,cex=cext)
	text((range.lia[2]-range.lia[1])/2+range.lia[1],-1,paste0(period.names.long[1]),font=ifelse(wilctests.maxcases.frac.noise.r[1]<0.05,2,1),cex=cext)
	for(i in 1:(length(shad.int)-1)){
	  rect(range.mca[1],shad.int[i],range.mca[2],shad.int[i+1],col=rgb(0,0,0,maxcases.noise.r.dens[2,i]),border = NA)
	}
	points(maxcases.mca+range.mca[1]+floor(period.length/2)-1,maxcases.frac.mca,col=exp.cols.selexp.members,bg=exp.cols.selexp.members,pch=21,cex=cext)
	text((range.mca[2]-range.mca[1])/2+range.mca[1],1,paste0(period.names.long[2]),font=ifelse(wilctests.maxcases.frac.noise.r[2]<0.05,2,1),cex=cext)

	for(i in 1:(length(shad.int)-1)){
	  rect(range.dacp[1],shad.int[i]*-1,range.dacp[2],shad.int[i+1]*-1,col=rgb(0,0,0,maxcases.noise.r.dens[3,i]),border = NA)
	}
	points(maxcases.dacp+range.dacp[1]+floor(period.length/2)-1,maxcases.frac.dacp*-1,col=exp.cols.selexp.members,bg=exp.cols.selexp.members,pch=21,cex=cext)
	text((range.dacp[2]-range.dacp[1])/2+range.dacp[1],-1,paste0(period.names.long[3]),font=ifelse(wilctests.maxcases.frac.noise.r[3]<0.05,2,1),cex=cext)

	for(i in 1:(length(shad.int)-1)){
	  rect(range.rwp[1],shad.int[i],range.rwp[2],shad.int[i+1],col=rgb(0,0,0,maxcases.noise.r.dens[4,i]),border = NA)
	}
	points(maxcases.rwp+range.rwp[1]+floor(period.length/2)-1,maxcases.frac.rwp,col=exp.cols.selexp.members,bg=exp.cols.selexp.members,pch=21,cex=cext)
	text((range.rwp[2]-range.rwp[1])/2+range.rwp[1],1,paste0(period.names.long[4]),font=ifelse(wilctests.maxcases.frac.noise.r[4]<0.05,2,1),cex=cext)

	for(i in 1:(length(shad.int)-1)){
	  rect(start.all.plot,shad.int[i],range.all[2],shad.int[i+1],col=rgb(0,0,0,maxcases.noise.r.dens[5,i]),border = NA)
	}
	points(maxcases.all+range.all[1]+floor(period.length/2)-1,maxcases.frac.all,col=exp.cols.selexp.members,bg=exp.cols.selexp.members,pch=21,cex=cext)
	text((range.all[2]-start.all.plot)/2+start.all.plot,1,paste0(period.names.long[5]),font=ifelse(wilctests.maxcases.frac.noise.r[5]<0.05,2,1),cex=cext)
	leg<-c(methods,"Density from AR1 noise fields")
	tw<-twf(leg)
	legend(150,1.3,leg,col=c(exp.cols,NA),
		   pt.bg =c(exp.cols,"gray"),pch=c(rep(21,6),22),pt.cex = c(rep(1,6),2),
		   horiz=T,xpd=T,bty="n",text.width = tw,cex=cext)
	#add boxplots
	bxp(bxp.cold,outline = F,add = T,at = c(2070,2190),axes=F)
	text(2070,-1,period.names[3],font=ifelse(wilctests.maxcases.frac.noise.r[3]<0.05,2,1),cex=cext)
	text(2190,-1,period.names[1],font=ifelse(wilctests.maxcases.frac.noise.r[1]<0.05,2,1),cex=cext)
	bxp(bxp.warm,outline = F,add = T,at = c(2070,2190,2310),axes=F)
	text(2070,1,period.names[4],font=ifelse(wilctests.maxcases.frac.noise.r[4]<0.05,2,1),cex=cext)
	text(2190,1,period.names[2],font=ifelse(wilctests.maxcases.frac.noise.r[2]<0.05,2,1),cex=cext)
	text(2310,1,period.names[5],font=ifelse(wilctests.maxcases.frac.noise.r[5]<0.05,2,1),cex=cext)
	for(i in 1:(length(shad.int)-1)){
	  rect(2060,shad.int[i]*-1,2080,shad.int[i+1]*-1,col=rgb(0,0,0,maxcases.noise.r.dens[3,i]),border = NA)
	}
	for(i in 1:(length(shad.int)-1)){
	  rect(2180,shad.int[i]*-1,2200,shad.int[i+1]*-1,col=rgb(0,0,0,maxcases.noise.r.dens[1,i]),border = NA)
	}
	for(i in 1:(length(shad.int)-1)){
	  rect(2060,shad.int[i],2080,shad.int[i+1],col=rgb(0,0,0,maxcases.noise.r.dens[4,i]),border = NA)
	}
	for(i in 1:(length(shad.int)-1)){
	  rect(2180,shad.int[i],2200,shad.int[i+1],col=rgb(0,0,0,maxcases.noise.r.dens[2,i]),border = NA)
	}
	for(i in 1:(length(shad.int)-1)){
	  rect(2300,shad.int[i],2320,shad.int[i+1],col=rgb(0,0,0,maxcases.noise.r.dens[5,i]),border = NA)
	}
	mtext(side=2,"Area fraction showing peak warming/cooling",padj=-5.3,adj=,cex=cext)
	mtext(side=1,"Year CE",padj=4.4,cex=cext)
dev.off()




###
stopCluster(cl)