c23456789012345678901234567890123456789012345678901234567890123456789012


      REAL*8 FUNCTION EExxxxx(ni,i,j,c2)

c     ******************************************************************
c     This function returns an element of matrix E of Ex + n = y 
c
c     Called by:        coepoly
c                       df_dxxx
c                       mod_int
c                       mod_sta
c                       writing
c                       x_to_sv 
c     Calls    :        none   
c
c     Written by       : OM  
c     Last modification: 7/2015
c     ******************************************************************

c     ------------
c     Declarations
c     ------------

c     '''''''''''''''''''''
      implicit none
      include 'commonvar.f'      
c     '''''''''''''''''''''

c---- Argument variables

      integer   ni,i,j

      character c2*2


c---- Internal variables

      integer   icc(ncoedim)
 
      real*8    lon0,
     >          lat0




c     --------------
c     Matrix element
c     -------------- 

c---- Test integer

      icc     = 0
      icc(ni) = 1


c---- Longitude & latitude of T-, u-, or v-carrier pt

           if (c2.eq.'ta') then
        lon0 = lon(i)
        lat0 = lat(j)
      else if (c2.eq.'ti') then
        lon0 = lon(i)
        lat0 = lat(j)
      else if (c2.eq.'hh') then
        lon0 = lon(i)
        lat0 = lat(j)
      else if (c2.eq.'uk') then
        lon0 = lon(i) + dlon/2.
        lat0 = lat(j)
      else if (c2.eq.'vk') then
        lon0 = lon(i)
        lat0 = lat(j) + dlat/2.
      endif


c---- Center longitude & latitude

      lon0 = lon0 - (lon_E+lon_W)/2.
      lat0 = lat0 - (lat_S+lat_N)/2.


c---- Element  

      EExxxxx = 1.                * icc( 1)

     >        + lat0              * icc( 2)
     >        +          lon0     * icc( 3)

     >        + lat0**2           * icc( 4)
     >        +          lon0**2  * icc( 5)
     >        + lat0    *lon0     * icc( 6)

     >        + lat0**3           * icc( 7)
     >        +           lon0**3 * icc( 8)
     >        + lat0**2 * lon0    * icc( 9)
     >        + lat0    * lon0**2 * icc(10)

c     >        + lat0**4           * icc(11)
c     >        +           lon0**4 * icc(12)
c     >        + lat0**3 * lon0    * icc(13)
c     >        + lat0    * lon0**3 * icc(14)
c     >        + lat0**2 * lon0**2 * icc(15)




c     -------------------
c     End of the function 
c     -------------------

      return

      end

c     ******************************************************************
 
