c23456789012345678901234567890123456789012345678901234567890123456789012


      SUBROUTINE P_filxx(nN) 

c     ******************************************************************
c     This routine constructs the error covariance matrix P(0,+) 
c
c     Called by:      	fil_lkf 
c     Calls    :        none	
c
c     Written by       : OM  
c     Last modification: 7/2015
c     ******************************************************************

c     ------------
c     Declarations
c     ------------

c     '''''''''''''''''''''
      implicit none
      include 'commonvar.f'      
c     '''''''''''''''''''''

c---- Argument variables

      integer   nN


c---- Local variables

      integer   i,j,kc,n,n1,n2,n3,ni,nf




c     -----------------------------------
c     Mean & STD of modern ML temperature
c     -----------------------------------

c---- Mean 

      kc     = 0
      ave_tt = 0. 

      do i=0,idim+1
      do j=0,jdim+1
         if (ipt(i,j).ge.0) then
             kc     = kc     + 1
             ave_tt = ave_tt + sst_WOA_g(i,j) 
         endif
      enddo
      enddo

      ave_tt = ave_tt / float(kc)


c---- Variance

      kc     = 0
      var_tt = 0.

      do i=0,idim+1
      do j=0,jdim+1
         if (ipt(i,j).ge.0) then
             kc     = kc     + 1
             var_tt = var_tt + (sst_WOA_g(i,j)-ave_tt)**2
         endif
      enddo
      enddo

      var_tt = var_tt / float(kc-1)




c     ------------------------------
c     Error covariance matrix P(0,+)
c     ------------------------------

c---- Initialize

      n2    = 0
      P_fil = 0.


c---- ML temperatures

c     Interior pts

      do i=1    ,idim
      do j=jS(i),jN(i)

         n2           = n2     + 1
         P_fil(n2,n2) = var_tt * fac_p0_tt 

      enddo
      enddo

c     Southern bry (excluding corners)

      do i=1,idim

         j = jS(i)-1

         do n=1,n_cor
            if (i.eq.i_cor(n) .and. j.eq.j_cor(n)) goto 101
         enddo

         n2           = n2     + 1
         P_fil(n2,n2) = var_tt * fac_p0_tt
101      continue

      enddo
 
c     Northern bry (excluding corners)

      do i=1,idim

         j = jN(i)+1

         do n=1,n_cor
            if (i.eq.i_cor(n) .and. j.eq.j_cor(n)) goto 102
         enddo

         n2           = n2     + 1
         P_fil(n2,n2) = var_tt * fac_p0_tt
102      continue

      enddo

c     Western bry (excluding corners)

      do j=1,jdim

         i = iW(j)-1

         do n=1,n_cor
            if (i.eq.i_cor(n) .and. j.eq.j_cor(n)) goto 103
         enddo

         n2           = n2     + 1
         P_fil(n2,n2) = var_tt * fac_p0_tt
103      continue

      enddo

c     Eastern bry (excluding corners)

      do j=1,jdim

         i = iE(j)+1

         do n=1,n_cor
            if (i.eq.i_cor(n) .and. j.eq.j_cor(n)) goto 104
         enddo

         n2           = n2     + 1
         P_fil(n2,n2) = var_tt * fac_p0_tt
104      continue

      enddo

c     Corners

      do n=1,n_cor

         i            = i_cor(n)
         j            = j_cor(n)
         n2           = n2     + 1
         P_fil(n2,n2) = var_tt * fac_p0_tt

      enddo


c---- Apparent temperature

      ni = n2 + 1
      nf = ni + ncoe - 1

      P_fil(ni:nf,ni:nf) = P_coe_ta(1:ncoe,1:ncoe) * fac_p0_ta


c---- Interior temperature

      ni = nf + 1
      nf = ni + ncoe - 1

      P_fil(ni:nf,ni:nf) = P_coe_ti(1:ncoe,1:ncoe) * fac_p0_ti


c---- Mixed layer depth

      ni = nf + 1
      nf = ni + ncoe - 1

      P_fil(ni:nf,ni:nf) = P_coe_hh(1:ncoe,1:ncoe) * fac_p0_hh


c---- Zonal velocity (Ekman + haline) 

      ni = nf + 1
      nf = ni + ncoe - 1

      P_fil(ni:nf,ni:nf) = P_coe_uk(1:ncoe,1:ncoe) * fac_p0_uk


c---- Meridional velocity (Ekman + haline)

      ni = nf + 1
      nf = ni + ncoe - 1

      P_fil(ni:nf,ni:nf) = P_coe_vk(1:ncoe,1:ncoe) * fac_p0_vk




c     ----
c     Test 
c     ----

      if (nf.ne.nN) then
        write(*,*)
        write(*,*) 'STOP in P_filxx.f: nf.ne.nN'
        write(*,*)
        stop
      endif




c     ---------------------
c     End of the subroutine
c     ---------------------

      return

      end

c     ******************************************************************
