c23456789012345678901234567890123456789012345678901234567890123456789012


      SUBROUTINE QQxxxxx(nN)

c     ******************************************************************
c     This routine constructs the covariance matrix for equation errors 
c
c     Called by:      	fil_lkf 
c     Calls    :        none	
c
c     Written by       : OM  
c     Last modification: 7/2015
c     ******************************************************************

c     ------------
c     Declarations
c     ------------

c     '''''''''''''''''''''
      implicit none
      include 'commonvar.f'      
c     '''''''''''''''''''''

c---- Argument variable
 
      integer   nN


c---- Internal variables 

      integer   n1,n

      real*8    qq_tt,qq_ta(ncoedim),
     >                qq_ti(ncoedim),
     >                qq_hh(ncoedim),
     >                qq_uk(ncoedim),
     >                qq_vk(ncoedim)




c     -----------------
c     Diagonal elements 
c     -----------------

c---- Variance of model errors

         qq_tt    = (fac_q_tt*ave_tt   )**2 
      do n=1,ncoe
         qq_ta(n) = (fac_q_ta*coe_ta(n))**2 
         qq_ti(n) = (fac_q_ti*coe_ti(n))**2  
         qq_hh(n) = (fac_q_hh*coe_hh(n))**2 
         qq_uk(n) = (fac_q_uk*coe_uk(n))**2  
         qq_vk(n) = (fac_q_vk*coe_vk(n))**2 
      enddo


c---- Print

      write(*,*)
      write(*,621) qq_tt
      write(*,*)
      do n=1,ncoe
         write(*,622) qq_ta(n),
     >                qq_ti(n),
     >                qq_hh(n),
     >                qq_uk(n),
     >                qq_vk(n)
      enddo
      write(*,*)

621   format('qq_tt=',e10.3)
622   format('qq_ta=',e10.3,' - qq_ti=',e10.3,' - ',
     >       'qq_hh=',e10.3,' - qq_uk=',e10.3,' - ',
     >       'qq_vk=',e10.3)


c---- Initialize order of covariance matrix

      n1 = 0


c---- Diagonal elements

c     ML temperature  

      do n=1,n_tt
         n1     = n1 + 1
         QQ(n1) = qq_tt
      enddo

c     Apparent temperature

      do n=1,ncoe
         n1     = n1 + 1
         QQ(n1) = qq_ta(n)
      enddo

c     Interior temperature

      do n=1,ncoe
         n1     = n1 + 1
         QQ(n1) = qq_ti(n)
      enddo

c     Mixed layer depth

      do n=1,ncoe
         n1     = n1 + 1
         QQ(n1) = qq_hh(n)
      enddo

c     Zonal velocity (Ekman + haline)

      do n=1,ncoe
         n1     = n1 + 1
         QQ(n1) = qq_uk(n)
      enddo

c     Meridional velocity (Ekman + haline)

      do n=1,ncoe
         n1     = n1 + 1
         QQ(n1) = qq_vk(n)
      enddo


c---- Test 

      if (n1.ne.nN) then
        write(*,*)
        write(*,*) 'STOP in QQxxxxx.f: n1.ne.nN'
        write(*,*)
        stop
      endif




c     ---------------------
c     End of the subroutine
c     ---------------------

      return

      end

c     ******************************************************************
