c23456789012345678901234567890123456789012345678901234567890123456789012


      SUBROUTINE coepoly(c6)

c     ******************************************************************
c     This routine returns weighted least square estimates of 
c     the polynomial coefficients (ci) of 
c
c              f(x,y) = c0 + c1*x   + c2*y
c                     +      c3*x^2 + c4*y^2 + c5*xy
c                     +      ...
c
c     Called by:        mod_sta
c                       zzRRHob
c     Calls    :        ludcmp
c                       lubksb	
c
c     Written by       : OM 
c     Last modification: 7/2015
c     ******************************************************************

c     ------------
c     Declarations
c     ------------

c     '''''''''''''''''''''
      implicit none
      include 'commonvar.f'      
c     '''''''''''''''''''''

c---- Argument variables

      character c6*6 


c---- Internal variables

      integer    m0,mm
      parameter (m0=(idim+2)*(jdim+2))

      integer    nn,ni,n,m

      integer   i,j,kc

      real*8    yy     (m0             ),
     >          Rn     (m0             ),
     >          EE     (m0     ,ncoedim),
     >          E_T    (ncoedim,m0     ),
     >          E_TR_1 (ncoedim,m0     ),
     >          E_TR_1E(ncoedim,ncoedim),
     >          E_TR_1y(        ncoedim),dd

      integer   indx(ncoedim)


c---- FUNCTION statement

      real*8    EExxxxx




c     --------------------------------
c     Construct vector y of Ex + n = y
c               matrix E of Ex + n = y
c     --------------------------------

c---- Initialize

      yy = 0.
      Rn = 0.
      EE = 0.


c---- Apparent temperature

c++
      if (c6.eq.'coe_ta') then

         kc = 0

         do i=0,idim+1
         do j=0,jdim+1

            if (ipt(i,j).ge.0) then
                  kc  = kc + 1
               yy(kc) = ta(i,j)
               Rn(kc) = sst_WOA_g_se(i,j)**2
               do ni  = 1,ncoe
c                 --------------------------------
                  EE(kc,ni) = EExxxxx(ni,i,j,'ta')
c                 --------------------------------
               enddo
            endif

         enddo
         enddo

      endif
c++


c---- Interior temperature

c++
      if (c6.eq.'coe_ti') then

         kc = 0

         do i=0,idim+1
         do j=0,jdim+1

            if (ipt(i,j).ge.0) then
                  kc  = kc + 1
               yy(kc) = ti(i,j)
               Rn(kc) = sst_WOA_g_se(i,j)**2
               do ni  = 1,ncoe
c                 --------------------------------
                  EE(kc,ni) = EExxxxx(ni,i,j,'ti')
c                 --------------------------------
               enddo
            endif

         enddo
         enddo

      endif
c++


c---- Mixed layer depth

c++
      if (c6.eq.'coe_hh') then

         kc = 0

         do i=0,idim+1
         do j=0,jdim+1
            if (ipt(i,j).ge.0) then
                  kc  = kc + 1
               yy(kc) = hh(i,j)
               Rn(kc) = 10.**2   ! Squared error in modern h [m2] 
               do ni  = 1,ncoe
c                 --------------------------------
                  EE(kc,ni) = EExxxxx(ni,i,j,'hh')
c                 --------------------------------
               enddo
            endif
         enddo
         enddo

      endif
c++


c---- Zonal velocity (Ekman + saline) 

c++
      if (c6.eq.'coe_uk') then

         kc = 0

         do i=0,idim
         do j=0,jdim+1
            if (ipt(i,j).eq.1 .or. ipt(i+1,j).eq.1) then
                  kc  = kc + 1
               yy(kc) = uk(i,j)
               Rn(kc) = 0.001**2   ! Squared error in modern u [m2/s2] 
               do ni  = 1,ncoe
c                 --------------------------------
                  EE(kc,ni) = EExxxxx(ni,i,j,'uk')
c                 --------------------------------
               enddo
            endif
         enddo
         enddo

      endif
c++


c---- Meridional velocity (Ekman + saline) 

c++
      if (c6.eq.'coe_vk') then

         kc = 0

         do i=0,idim+1
         do j=0,jdim
            if (ipt(i,j).eq.1 .or. ipt(i,j+1).eq.1) then
                  kc  = kc + 1
               yy(kc) = vk(i,j)
               Rn(kc) = 0.001**2   ! Squared error in modern v [m2/s2] 
               do ni  = 1,ncoe
c                 --------------------------------
                  EE(kc,ni) = EExxxxx(ni,i,j,'vk')
c                 --------------------------------
               enddo
            endif
         enddo
         enddo

      endif
c++




c     ---------------------------------------------------
c     Solve Ex + n = y for x using weighted least squares
c     ---------------------------------------------------

c---- Number of equations & number of unknowns

      mm = kc
      nn = ncoe


c---- Matrix E'

      E_T(1:nn,1:mm) = transpose(EE(1:mm,1:nn)) 


c---- Matrix E' R^-1

      do n=1,nn
      do m=1,mm
         E_TR_1(n,m) = E_T(n,m)/Rn(m)
      enddo
      enddo 


c---- Matrix E' R^-1 E

      E_TR_1E(1:nn,1:nn) = matmul(E_TR_1(1:nn,1:mm),EE(1:mm,1:nn))


c---- Matrix P = (E' R^-1 E)^-1
     
      NN1(1:nn,1:nn) = E_TR_1E(1:nn,1:nn) 
      NN2            = 0.
      do n= 1,nn
         NN2(n,n) = 1.
      enddo
c     ----------------------------------------------
      call ludcmp(NN1,nn,ndim,indx,dd,'E^T R^-1 E ')
c     ----------------------------------------------
      do n=1,nn
c        --------------------------------------
         call lubksb(NN1,nn,ndim,indx,NN2(1,n))
c        --------------------------------------
      enddo


c---- Vector E' R^-1 y

      E_TR_1y(1:nn) = matmul(E_TR_1(1:nn,1:mm),yy(1:mm))


c---- Vector x = (E' R^-1 E)^-1 E' R^-1 y 

      if (c6.eq.'coe_ta') coe_ta(1:nn) = matmul(NN2    (1:nn,1:nn),
     >                                          E_TR_1y(1:nn     )) 
      if (c6.eq.'coe_ti') coe_ti(1:nn) = matmul(NN2    (1:nn,1:nn),
     >                                          E_TR_1y(1:nn     ))
      if (c6.eq.'coe_hh') coe_hh(1:nn) = matmul(NN2    (1:nn,1:nn),
     >                                          E_TR_1y(1:nn     ))
      if (c6.eq.'coe_uk') coe_uk(1:nn) = matmul(NN2    (1:nn,1:nn),
     >                                          E_TR_1y(1:nn     ))
      if (c6.eq.'coe_vk') coe_vk(1:nn) = matmul(NN2    (1:nn,1:nn),
     >                                          E_TR_1y(1:nn     ))


c---- Matrix P = (E' R^-1 E)^-1

      if (c6.eq.'coe_ta') P_coe_ta(1:nn,1:nn) = NN2(1:nn,1:nn)
      if (c6.eq.'coe_ti') P_coe_ti(1:nn,1:nn) = NN2(1:nn,1:nn)
      if (c6.eq.'coe_hh') P_coe_hh(1:nn,1:nn) = NN2(1:nn,1:nn)
      if (c6.eq.'coe_uk') P_coe_uk(1:nn,1:nn) = NN2(1:nn,1:nn)
      if (c6.eq.'coe_vk') P_coe_vk(1:nn,1:nn) = NN2(1:nn,1:nn)




c     ---------------------
c     End of the subroutine
c     ---------------------

      return

      end

c     ******************************************************************
