c23456789012345678901234567890123456789012345678901234567890123456789012

c     ******************************************************************
c     This file declares the variables that are common to:
c
c 	               - the main program main.f
c     	               - the routines *.f
c
c     Written by       : OM
c     Last modification: 8/2015
c     ******************************************************************


c     ---------
c     Constants 
c     ---------

c---- Integer
c
c     idim      Maximum number of grid points in longitudinal direction
c     jdim      Maximum number of grid points in latitudinal  direction
c
c     nvar      Number of variables approximated by polynomial functions
c     ncoedim   Number of terms retained in polynomial functions
c     ndim      Number of state variables
c     n_rec     Number of sediment SST records
c     pdim      Maximum number of measurements at a given time
c     n_cor     Number of corner points of the model grid

      integer    idim
      parameter (idim=17)                 

      integer    jdim
      parameter (jdim=12)               

      integer    nvar
      parameter (nvar=5)                   

      integer    ncoedim
      parameter (ncoedim=10)         ! 10 or 15       

      integer    ndim
      parameter (ndim=256            ! tt 
     >               +nvar*ncoedim)  ! ta,ti,hh,uu,vv 

      integer    n_rec
      parameter (n_rec=3)       

      integer    pdim
      parameter (pdim=ndim+n_rec)              

      integer    n_cor
      parameter (n_cor=6)      


c---- Integer: data bases
c
c     i_scow    Number of longitudinal values in SCOW files 
c     j_scow    Number of latitudinal  values in SCOW files 
c
c     nfdim     Maximum number of sediment SST records
c     nfdim0    Maximum number of values in a sediment SST record
c
c     k_WOA     Number of horizontal values in WOA (2013) files
c     k_WOA_z   Number of vertical   values in WOA (2013) files
c     k_mld     Number of horizontal values in WOA (1997) file      

      integer    i_scow     ,j_scow
      parameter (i_scow=1440,j_scow=560)
c--
      integer    nfdim    ,nfdim0
      parameter (nfdim=100,nfdim0=20000)
c--
      integer    k_WOA        ,k_WOA_z
      parameter (k_WOA=360*180,k_WOA_z=102)
c--

      integer    k_mld
      parameter (k_mld=180*360)


c---- Real
c
c     yr         Number of seconds in one year [s/yr]
c     pi         Ratio of circumference to diameter of a circle [m]
c     rad        One radian [rad or 1]
c     i_dt       Number of time steps in one year
c     dt         Time step [s]
c     r_0        Earth radius [m]
c     omega      Earth angular velocity [rad/s or 1/s]
c
c     lon_W      Westernmost  longitude of model grid [rad]
c     lon_E      Easternmost  longitude of model grid [rad]
c     lat_S      Southernmost latitude  of model grid [rad]           
c     lat_N      Northernmost latitude  of model grid [rad]
c
c     rho        Reference density of seawater [kg/m3]
c     w_a        Parameter for surface heat exchange [m/s]
c     time_start Time of the beginning of the inversion [yr BP]
c     tt_c       Freezing point of seawater [deg C]
c
c     alpha      Thermal expansion coefficient of seawater [1/degC]
c     beta       Haline  contraction coefficient of seawater [1]
c
c     gg         Acceleration due to gravity [m/s2]
c     d_ti       Difference between ML & interior temperatures [deg C]

      real*8	 yr
      parameter (yr=86400.d0*365.d0)

      real*8     pi
      parameter (pi=3.141592654) 

      real*8     rad
      parameter (rad=pi/180.d0)

      integer    i_dt          
      parameter (i_dt=10)               ! 10 for LKF, 20 fr EKF    

      real*8     dt
      parameter (dt=yr/float(i_dt))   

      real*8     r_0
      parameter (r_0=6371.d3)

      real*8     omega
      parameter (omega=7.3d-5)

      real*8     lon_W,lon_E
      parameter (lon_W=-46.*rad,        
     >           lon_E=-12.*rad)        

      real*8     lat_S,lat_N
      parameter (lat_S=37.*rad,
     >           lat_N=61.*rad)         

      real*8     rho
      parameter (rho=1025.d0)

      real*8     w_a 
      parameter (w_a=9.d-6)             ! (6,9,12) x 1.d-6

      real*8     time_start
      parameter (time_start=14500.) 

      real*8     tt_c
      parameter (tt_c=-1.9)

      real*8     alpha
      parameter (alpha=2.d-4)

      real*8     beta
      parameter (beta=0.8/rho)

      real*8     gg
      parameter (gg=9.81)

      real*8     d_ti
      parameter (d_ti=0.5)


c---- Real: data bases
c
c     amiss_scow        Indicator for 'No Data' occurrence in SCOW 
c     amiss_sstx        Indicator for 'No Data' occurrence in WOA (2013)
c     amiss_sssx        Indicator for 'No Data' occurrence in WOA (2013)
c     amiss_mld         Indicator for 'No Data' occurrence in WOA (1997) 

      real*8     amiss_scow
      parameter (amiss_scow=-9999.)

      real*8     amiss_sstx
      parameter (amiss_sstx=-99.999)

      real*8     amiss_sssx
      parameter (amiss_sssx=-99.999)

      real*8     amiss_mldx
      parameter (amiss_mldx=-99.999)

      real*8     amiss_uvht
      parameter (amiss_uvht=-99.)




c     --------------
c     Integer arrays
c     --------------

c---- 0:idim+1 x 0:jdim+1 
c
c     ipt       Grid point index
    
      integer    ipt(0:idim+1,0:jdim+1)
      common/ipt/ipt


c---- idim
c
c     jS        Latitude index of southermost  interior grid point
c     jN        Latitude index of northernmost interior grid point 

      integer   jS(idim),
     >          jN(idim)
      common/jS/jS,
     >          jN


c---- jdim
c
c     iW        Longitude index of westernmost interior grid point
c     iE        Longitude index of easternmost interior grid point

      integer   iW(jdim),
     >          iE(jdim)
      common/iW/iW,
     >          iE


c---- n_cor
c
c     i_cor     Longitude index of corner points
c     j_cor     Latitude  index of corner points

      integer      i_cor(n_cor),
     >             j_cor(n_cor)
      common/i_cor/i_cor,
     >             j_cor


c---- nfdim
c
c     itot_c    Number of values in sediment SST record 
c     itot_dat  Number of values in sediment SST record
c
c     i_lon_dat Longitude index of  sediment SST record
c     i_lat_dat Latitude  index of  sediment SST record 

      integer       itot_c  (nfdim),
     >              itot_dat(nfdim)
      common/itot_c/itot_c  ,
     >              itot_dat

      integer          i_lon_dat(nfdim),
     >                 i_lat_dat(nfdim)
      common/i_lon_dat/i_lon_dat,
     >                 i_lat_dat


c---- 0:idim+1 x 0:jdim+1 x ndim 
c
c     ia        Binary factor for partial derivatives in df/dx [1]

      integer   ia(0:idim+1,0:jdim+1,ndim)
      common/ia/ia




c     -----------
c     Real arrays    
c     -----------

c---- 0:idim+1 x 0:jdim+1
c
c     uu        Zonal velocity [m/s]
c     uk        Zonal velocity (Ekman + haline) [m/s]
c     vv        Meridional velocity [m/s]
c     vk        Meridional velocity (Ekman + haline) [m/s]
c     tt        ML temperature [deg C]
c     ta        apparent atmospheric temperature [deg C]
c     ti        interior temperature [deg C]
c     s0        ML salinity [1]
c     hh        ML depth [m]   

      real*8    uu(0:idim+1,0:jdim+1),
     >          uk(0:idim+1,0:jdim+1),
     >          vv(0:idim+1,0:jdim+1),
     >          vk(0:idim+1,0:jdim+1), 
     >          tt(0:idim+1,0:jdim+1),
     >          ta(0:idim+1,0:jdim+1),
     >          ti(0:idim+1,0:jdim+1),
     >          s0(0:idim+1,0:jdim+1),
     >          hh(0:idim+1,0:jdim+1)
      common/uu/uu,
     >          uk,
     >		vv,
     >          vk,
     >          tt,
     >          ta,
     >          ti,
     >          s0,
     >          hh

c--
c
c     ta_r      Residual for apparent atmospheric temperature [deg C]
c     ti_r      Residual for interior temperature [deg C]
c     hh_r      Residual for ML depth [m]
c     uk_r      Residual for zonal velocity (Ekman + haline) [m/s]
c     vk_k      Residual for meridional velocity (Ekman + haline) [m/s]

      real*8      ta_r(0:idim+1,0:jdim+1),
     >            ti_r(0:idim+1,0:jdim+1),
     >            hh_r(0:idim+1,0:jdim+1),
     >            uk_r(0:idim+1,0:jdim+1),
     >            vk_r(0:idim+1,0:jdim+1)
      common/ta_r/ta_r,
     >            ti_r,
     >            hh_r,
     >            uk_r,
     >            vk_r

c--
c
c     w_i       Vertical interior velocity [m/s]
c     er_tt     Error in ML temperature [deg C]       

      real*8     w_i  (0:idim+1,0:jdim+1),
     >           er_tt(0:idim+1,0:jdim+1)
      common/w_i/w_i  ,
     >           er_tt

c--
c
c     tau_x     Zonal      wind stress [N/m2]
c     tau_y     Meridional wind stress [N/m2]

      real*8       tau_x(0:idim+1,0:jdim+1),
     >             tau_y(0:idim+1,0:jdim+1)
      common/tau_x/tau_x,
     >             tau_y

c--
c
c     sst_WOA_g                      WOA SST      at model grid points [deg C]
c     sst_WOA_g_se standard error of WOA SST      at model grid points [deg C]
c     sss_WOA_g                      WOA SSS      at model grid points [1]
c     mld_WOA_g                      WOA ML depth at model grid points [m]

      real*8           sst_WOA_g   (0:idim+1,0:jdim+1),
     >                 sst_WOA_g_se(0:idim+1,0:jdim+1),
     >                 sss_WOA_g   (0:idim+1,0:jdim+1),
     >                 mld_WOA_g   (0:idim+1,0:jdim+1)
      common/sst_WOA_g/sst_WOA_g   ,
     >                 sst_WOA_g_se,
     >                 sss_WOA_g   ,
     >                 mld_WOA_g


c----  0:idim+1 x -1:jdim+1
c     -1:idim+1 x  0:jdim+1
c
c     tau_x_scow_g      SCOW zonal wind stress at model grid point [N/m2]
c     tau_y_scow_g      SCOW meridional wind stress at model grid point [N/m2]

      real*8              tau_x_scow_g(0:idim+1,-1:jdim+1)
      common/tau_x_scow_g/tau_x_scow_g 

      real*8              tau_y_scow_g(-1:idim+1,0:jdim+1)
      common/tau_y_scow_g/tau_y_scow_g


c---- 0:idim+1
c
c     lon       Longitudes of model grid points [rad]

      real*8	 lon(0:idim+1)
      common/lon/lon


c---- 0:jdim+1
c     0:jdim
c
c     lat       Latitudes  of model grid points [rad]
c     dx        Zonal spacing of model grid [m] 
c
c     ggu       Factor of partial derivatives in df/dx [deg C/s3] 
c     ddv       Factor of partial derivatives in df/dx [deg C/s3] 

      real*8	 lat(0:jdim+1),
     >           dx (0:jdim+1)
      common/lat/lat,
     >           dx

      real*8     ggu(0:jdim),
     >           ddv(0:jdim)
      common/ggu/ggu,
     >           ddv 


c---- ndim
c
c     xm        Prior filtered state 
c     x_fil     Posterior filtered state 
c     x_ref     Reference state 
c
c     QQ        Covariance matrix (vector) for model errors

      real*8	xm   (ndim),
     >		x_fil(ndim),
     >          x_ref(ndim),
     >          x_smo(ndim),
     >          QQ   (ndim)
      common/xm/xm   ,
     >		x_fil,
     >          x_ref,
     >          x_smo,
     >          QQ


c---- ndim x ndim 
c
c     Pm        Error covariance matrix for prior filtered state
c     P_fil     Error covariance matrix for posterior filtered state   
c     P_smo     Error covariance matrix for smoothed state
c
c     df_dx     Matrix of partial derivatives
c
c     NN1       Dummy matrix
c     NN2       Dummy matrix
c     NN3       Dummy matrix

      real*8	Pm   (ndim,ndim),
     >		P_fil(ndim,ndim),
     >          P_smo(ndim,ndim),
     >          df_dx(ndim,ndim)
      common/Pm/Pm   ,
     >		P_fil,
     >          P_smo,
     >          df_dx

      real*8	 NN1(ndim,ndim),
     >		 NN2(ndim,ndim),
     >           NN3(ndim,ndim)
      common/NN1/NN1,
     >		 NN2,
     >           NN3


c---- pdim
c
c     zz        Vector of measurements
c     zz_Hx     Vector difference z-Hx

      real*8	zz   (pdim),
     >          zz_Hx(pdim)

      common/zz/zz   ,
     >          zz_Hx


c---- pdim x ndim
c
c     Hob       Measurement matrix
c     HP        H(i) x P(i,-)
c     RK_T      R(i) x K(i)' 

      real*8     Hob (pdim,ndim),
     >           HP  (pdim,ndim),
     >           RK_T(pdim,ndim)
      common/Hob/Hob ,
     >           HP  ,
     >           RK_T 


c---- ndim x pdim
c
c     KK        Kalman gain
c     PH_T      P(i) x H(i)'
c     KR        K(i) x R(i)

      real*8	KK  (ndim,pdim),
     >          PH_T(ndim,pdim),
     >          KR  (ndim,pdim)
      common/KK/KK  ,
     >          PH_T,
     >          KR


c---- pdim x pdim
c
c     RR         R(i)
c     HPH_T      H(i) x P(i,-) x H(i)'
c     HPH_T_p_R  H(i) x P(i,-) x H(i)' + R(i)
c     HPH_T_p_R [H(i) x P(i,-) x H(i)' + R(i) ]^(-1)
c
c     PP1        Dummy matrix

      real*8    RR(pdim,pdim)
      common/RR/RR

      real*8       HPH_T      (pdim,pdim),
     >             HPH_T_p_R  (pdim,pdim),
     >             HPH_T_p_R_1(pdim,pdim)
      common/HPH_T/HPH_T      ,
     >             HPH_T_p_R  ,
     >             HPH_T_p_R_1

      real*8     PP1(pdim,pdim)
      common/PP1/PP1
     

c---- i_scow & j_scow & i_scow x j_scow
c
c     lon_scow   Longitudes             of SCOW climagologic grid [deg] 
c     lat_scow   Latitudes              of SCOW climatologic grid [deg]
c
c     tau_x_scow Zonal wind stress      of SCOW climatology [N/m2]
c     tau_y_scow Meridional wind stress of SCOW climatology [N/m2]         

      real*8          lon_scow(i_scow)
      common/lon_scow/lon_scow

      real*8          lat_scow(j_scow)
      common/lat_scow/lat_scow

      real*8            tau_x_scow(i_scow,j_scow),
     >                  tau_y_scow(i_scow,j_scow)
      common/tau_x_scow/tau_x_scow,
     >                  tau_y_scow


c---- nfdim
c     nfdim x nfdim0
c     nfdim x nfdim0 x 2
c
c     c_lat      Latitude  of sediment core [deg]
c     c_lon      Longitude of sediment core [deg]
c
c     tim        Calendar age of reconstructed SST [yr BP]
c     tim_dat    Calendar age of reconstructed SST [yr BP]
c
c     tem_dat    Reconstructed SST [deg C]
c     tem_dat_er Error of reconstructed SST [deg C] 
c     tem        Sediment SST [deg C]
c     tem_er     Error in reconstructed SST [deg C]

      real*8       c_lat(nfdim),
     >             c_lon(nfdim)
      common/c_lat/c_lat,
     >             c_lon

      real*8     tim       (nfdim,nfdim0),
     >           tim_dat   (nfdim,nfdim0),
     >           tem_dat   (nfdim,nfdim0),
     >           tem_dat_er(nfdim,nfdim0)
      common/tim/tim       ,
     >           tim_dat   ,
     >           tem_dat   ,
     >           tem_dat_er
   
      real*8     tem   (nfdim,nfdim0,2),
     >           tem_er(nfdim,nfdim0,2)
      common/tem/tem   ,
     >           tem_er
 

c---- k_WOA 
c     k_WOA_z 
c     k_WOA x k_WOA_z
c
c     lon_WOA      Longitude of WOA grid [deg]
c     lat_WOA      Latitude  of WOA grid [deg]
c     sst_WOA      SST of WOA [deg C]
c     mld_WOA      ML depth of WOA [m]
c     z_WOA        Depth of WOA grid [m]
c     tem_WOA_z    Temperature of WOA [deg C]
c     tem_WOA_z_se Standard error of temperature of WOA [deg C] 
c     lat_WOA_sss  Latitude  of WOA SSS grid [deg]
c     lon_WOA_sss  Longitude of WOA SSS grid [deg]
c     sss_WOA      SSS of WOA [1]

      real*8         lon_WOA(k_WOA),
     >               lat_WOA(k_WOA),
     >               sst_WOA(k_WOA),
     >               mld_WOA(k_WOA)
      common/lon_WOA/lon_WOA,
     >               lat_WOA,
     >               sst_WOA,
     >               mld_WOA

      real*8       z_WOA(k_WOA_z)
      common/z_WOA/z_WOA

      real*8           tem_WOA_z   (k_WOA,k_WOA_z),
     >                 tem_WOA_z_se(k_WOA,k_WOA_z)
      common/tem_WOA_z/tem_WOA_z  ,
     >                 tem_WOA_z_se

      real*8             lat_WOA_sss(k_WOA),
     >                   lon_WOA_sss(k_WOA),
     >                   sss_WOA    (k_WOA)
      common/lat_WOA_sss/lat_WOA_sss,
     >                   lon_WOA_sss,
     >                   sss_WOA


c---- k_mld & k_mld x 0:12
c
c     lon_mld   Longitude of WOA ML depth [deg]
c     lat_mld   Latitude  of WOA ML depth [deg]
c     mld                    WOA ML depth [m] 

      real*8         lon_mld(k_mld),
     >               lat_mld(k_mld)
      common/lon_mld/lon_mld,
     >               lat_mld

      real*8     mld(k_mld,0:12)
      common/mld/mld


c---- ncoedim
c
c     coe_ta    coefficient for apparent temperature
c     coe_ti    coefficient for interior temperature
c     coe_hh    coefficient for ML depth 
c     coe_uk    coefficient for zonal      velocity (Ekman + haline)
c     coe_vk    coefficient for meridional velocity (Ekman + haline)
c
c     er_coe_ta Error of coe_ta 
c     er_coe_ti Error of coe_ti
c     er_coe_hh Error of coe_hh
c     er_coe_uk Error of coe_uk
c     er_coe_vk Error of coe_vk

      real*8        coe_ta(ncoedim),
     >              coe_ti(ncoedim),
     >              coe_hh(ncoedim),
     >              coe_uk(ncoedim),
     >              coe_vk(ncoedim)
      common/coe_ta/coe_ta,
     >              coe_ti,
     >              coe_hh,
     >              coe_uk,
     >              coe_vk

      real*8           er_coe_ta(ncoedim),
     >                 er_coe_ti(ncoedim),
     >                 er_coe_hh(ncoedim),
     >                 er_coe_uk(ncoedim),
     >                 er_coe_vk(ncoedim)
      common/er_coe_ta/er_coe_ta,
     >                 er_coe_ti,
     >                 er_coe_hh,
     >                 er_coe_uk,
     >                 er_coe_vk


c---- ncoedim x ncoedim
c
c     P_coe_ta  Covariance matrix for coe_ta
c     P_coe_ti  Covariance matrix for coe_ti
c     P_coe_hh  Covariance matrix for coe_hh
c     P_coe_uk  Covariance matrix for coe_uk
c     P_coe_vk  Covariance matrix for coe_vk
c
c     pp_coe_uk Covariance matrix for uk
c     pp_coe_vk Covariance matrix for vk


      real*8          P_coe_ta(ncoedim,ncoedim),
     >                P_coe_ti(ncoedim,ncoedim),
     >                P_coe_hh(ncoedim,ncoedim),
     >                P_coe_uk(ncoedim,ncoedim),
     >                P_coe_vk(ncoedim,ncoedim)
      common/P_coe_ta/P_coe_ta,
     >                P_coe_ti,
     >                P_coe_hh,
     >                P_coe_uk,
     >                P_coe_vk

      real*8           pp_coe_uk(ncoedim,ncoedim),
     >                 pp_coe_vk(ncoedim,ncoedim)
      common/pp_coe_uk/pp_coe_uk,
     >                 pp_coe_vk




c     ----------------
c     Character arrays
c     ----------------

c---- ndim
c
c     strx      Character string for state variable

      character*8 strx(ndim)
      common/strx/strx


c---- nfdim
c
c     cfile     Name of file of sediment SST record

      character*50 cfile(nfdim)
      common/cfile/cfile 


c---- pdim
c
c     cobs      Name of file of sediment SST record

      character*50 c_obs(pdim)
      common/c_obs/c_obs




c     -------
c     Scalars
c     -------

c---- Integer
c
c     n_tt      Number of interior & boundary grid points
c     ncoe      Number of polynomial coefficients
c     itot_fs   Integer for the length of filtering & smoother experiments
c     i_Store   Integer for the writing of filtering results 

      integer	n_tt   ,
     >          ncoe   ,
     >          itot_fs,
     >          i_Store

      common/i_dat/n_tt  ,
     >             ncoe   ,
     >             itot_fs,
     >             i_Store


c---- Real
c
c     dlon      Longitude increment of the model grid [rad]
c     dlat      Latitude  increment of the model grid [rad]
c     dy        Meridional spacing  of the model grid [m]
c
c     ave_tt    Spatial mean of WOA SSTs in model domain [ deg C   ]
c     var_tt    Variance     of WOA SSTs in model domain [(deg C)^2]
c
c     fac_p0_tt Factor for variance error of initial tt     [1]
c     fac_p0_ta Factor for variance error of initial coe_ta [1]
c     fac_p0_ti Factor for variance error of initial coe_ti [1]
c     fac_p0_hh Factor for variance error of initial coe_hh [1]
c     fac_p0_uk Factor for variance error of initial coe_uk [1]
c     fac_p0_vk Factor for variance error of initial coe_vk [1] 
c
c     fac_q_tt  Factor for variance error of     tt equation [1]
c     fac_q_ta  Factor for variance error of coe_ta equation [1]  
c     fac_q_ti  Factor for variance error of coe_ti equation [1] 
c     fac_q_hh  Factor for variance error of coe_hh equation [1]
c     fac_q_uk  Factor for variance error of coe_uk equation [1]
c     fac_q_vk  Factor for variance error of coe_vk equation [1]

      real*8      dlon,
     >            dlat,
     >            dy   
      common/dlon/dlon,
     >            dlat,
     >            dy

      real*8        ave_tt,
     >              var_tt
      common/ave_tt/ave_tt,
     >              var_tt


      real*8           fac_p0_tt,
     >                 fac_p0_ta,
     >                 fac_p0_ti,
     >                 fac_p0_hh,
     >                 fac_p0_uk,
     >                 fac_p0_vk
      common/fac_p0_tt/fac_p0_tt,
     >                 fac_p0_ta,
     >                 fac_p0_ti,
     >                 fac_p0_hh,
     >                 fac_p0_uk,
     >                 fac_p0_vk

      real*8          fac_q_tt,
     >                fac_q_ta,
     >                fac_q_ti,
     >                fac_q_hh,
     >                fac_q_uk,
     >                fac_q_vk
      common/fac_q_tt/fac_q_tt,
     >                fac_q_ta,
     >                fac_q_ti,
     >                fac_q_hh,
     >                fac_q_uk,
     >                fac_q_vk


c---- Character
c
c     tag       Extension of start file & output files
c     c3_KF     Character string for selection of LKF or EKF

      character*50 tag
      common/tag  /tag

      character*3  c3_KF
      common/c3_KF/c3_KF




c     ---------------
c     End of the file
c     ---------------
