c23456789012345678901234567890123456789012345678901234567890123456789012


      SUBROUTINE df_dxxx(nN)

c     ******************************************************************
c     This routine returns the matrix df/dx of partial derivatives
c
c     Called by:        fil_lkf	
c                       fil_ekf
c     Calls    :        none	
c
c     Written by       : OM  
c     Last modification: 7/2015
c     ******************************************************************

c     ------------
c     Declarations
c     ------------

c     '''''''''''''''''''''
      implicit none
      include 'commonvar.f'      
c     '''''''''''''''''''''

c---- Argument variables

      integer   nN


c---- Internal variables

      integer   i ,j ,
     >          n1,n2,n,n_c,iskip 

      real*8    df_dx_im1jm1,
     >          df_dx_im1j  ,
     >          df_dx_im1jp1,
     >          df_dx_ijp1  ,
     >          df_dx_ip1jp1,
     >          df_dx_ip1j  ,
     >          df_dx_ip1jm1,
     >          df_dx_ijm1  ,
     >          df_dx_ij

      real*8    uuim1j,uuij,ukij,ukim1j,utij,utim1j,
     >          vvijm1,vvij,vkij,vkijm1,vtij,vtijm1

      real*8    t1,t2,t3a,t3b,t3,t4,t5,t6

      real*8    rds,cm,cp

      real*8    huij,huim1j,
     >          hvij,hvijm1


c---- FUNCTIONS 

      real*8      EExxxxx

      character*8 stringx




c     -------------
c     Preliminaries
c     -------------

c---- Initialize - number of equations 
c                - matrix df_dx 

      n1    = 0
      df_dx = 0.




c     ------------------------------------------
c     Equations for ML temperature: Interior pts
c     ------------------------------------------

c---- Start loop 

c++
      do i=1    ,idim
      do j=jS(i),jN(i)
c++


c---- Equation counter

      n1 = n1 + 1


c---- Geometric factors 

      rds = r_0 * (sin(lat(j)+dlat/2.)-
     >             sin(lat(j)-dlat/2.))

      cm  = cos(lat(j)-dlat/2.)
      cp  = cos(lat(j)+dlat/2.)


c---- MLDs

      huim1j = 0.5 * (hh(i-1,j)+hh(i  ,j))
      huij   = 0.5 * (hh(i  ,j)+hh(i+1,j))

      hvijm1 = 0.5 * (hh(i,j-1)+hh(i,j  ))
      hvij   = 0.5 * (hh(i,j  )+hh(i,j+1))


c---- Zonal velocity at (i-1,j) & (i,j)

c     Ekman + thermal + haline

      uuim1j = uu(i-1,j)
      uuij   = uu(i  ,j)

c     Ekman + haline

      ukim1j = uk(i-1,j)
      ukij   = uk(i  ,j)

c     Thermal

      utim1j = uuim1j - ukim1j
      utij   = uuij   - ukij 


c---- Meridional velocity at (i,j-1) & (i,j)

c     Ekman + thermal + haline

      vvijm1 = vv(i,j-1)
      vvij   = vv(i,j  ) 

c     Ekman + haline

      vkijm1 = vk(i,j-1)
      vkij   = vk(i,j  )


c---- df_dx: x = ML temperature

c--
      do n2=1,n_tt
c--

c     x = tt(i-1,j-1)

      t1 = dt/hh(i,j) * (ti(i,j)-tt(i,j)) * huim1j / dx(j)
      t1 =
     >t1 * ggu(j) * (hh(i-1,j)+hh(i,j))

      t2 = dt/hh(i,j) * (ti(i,j)-tt(i,j)) * hvijm1 * cm / rds 
      t2 =
     >t2 * ddv(j-1) * (hh(i,j-1)+hh(i,j))

      df_dx_im1jm1 = t1 
     >             + t2


c     x = tt(i-1,j)

      t1 = dt/dx(j) * 0.5 * (ukim1j+abs(ukim1j))

      t2 = -dt/hh(i,j) * (ti(i,j)-tt(i,j)) * hvij * cp / rds
      t2 = 
     >t2 * ddv(j) * (hh(i,j)+hh(i,j+1))

      t3 = dt/hh(i,j) * (ti(i,j)-tt(i,j)) * hvijm1 * cm / rds 
      t3 = 
     >t3 * ddv(j-1) * (hh(i,j-1)+hh(i,j))

      df_dx_im1j = t1 
     >           + t2 
     >           + t3  


c     x = tt(i-1,j+1)

      t1 = -dt/hh(i,j) * (ti(i,j)-tt(i,j)) * huim1j / dx(j)
      t1 = 
     >t1 * ggu(j) * (hh(i-1,j)+hh(i,j))

      t2 = -dt/hh(i,j) * (ti(i,j)-tt(i,j)) * hvij * cp / rds
      t2 =
     >t2 * ddv(j) * (hh(i,j)+hh(i,j+1))

      df_dx_im1jp1 = t1 
     >             + t2


c     x = tt(i,j+1)

      t1 = -dt/dy * 0.5 * (vkij-abs(vkij))

      t2 = dt/hh(i,j) * (ti(i,j)-tt(i,j)) * huij / dx(j)
      t2 =
     >t2 * ggu(j) * (hh(i,j)+hh(i+1,j))

      t3 = -dt/hh(i,j) * (ti(i,j)-tt(i,j)) * huim1j / dx(j)
      t3 =
     >t3 * ggu(j) * (hh(i-1,j)+hh(i,j))

      df_dx_ijp1 = t1 
     >           + t2 
     >           + t3


c     x = tt(i+1,j+1)

      t1 = dt/hh(i,j) * (ti(i,j)-tt(i,j)) * huij / dx(j)
      t1 = 
     >t1 * ggu(j) * (hh(i,j)+hh(i+1,j))

      t2 = dt/hh(i,j) * (ti(i,j)-tt(i,j)) * hvij * cp / rds 
      t2 =
     >t2 * ddv(j) * (hh(i,j)+hh(i,j+1))
 
      df_dx_ip1jp1 = t1 
     >             + t2 


c     x = tt(i+1,j)

      t1 = -dt/dx(j) * 0.5 * (ukij-abs(ukij))

      t2 = dt/hh(i,j) * (ti(i,j)-tt(i,j)) * hvij * cp / rds
      t2 = 
     >t2 * ddv(j) * (hh(i,j)+hh(i,j+1))

      t3 = -dt/hh(i,j) * (ti(i,j)-tt(i,j)) * hvijm1 * cm / rds
      t3 =
     >t3 * ddv(j-1) * (hh(i,j-1)+hh(i,j))

      df_dx_ip1j = t1 
     >           + t2 
     >           + t3 


c     x = tt(i+1,j-1)

      t1 = -dt/hh(i,j) * (ti(i,j)-tt(i,j)) * huij / dx(j)
      t1 = 
     >t1 * ggu(j) * (hh(i,j)+hh(i+1,j))

      t2 = -dt/hh(i,j) * (ti(i,j)-tt(i,j)) * hvijm1 * cm / rds
      t2 = 
     >t2 * ddv(j-1) * (hh(i,j-1)+hh(i,j))

      df_dx_ip1jm1 = t1 
     >             + t2  


c     x = tt(i,j-1)

      t1 = dt/dy * 0.5 * (vkijm1+abs(vkijm1))

      t2 = -dt/hh(i,j) * (ti(i,j)-tt(i,j)) * huij / dx(j)
      t2 =
     >t2 * ggu(j) * (hh(i,j)+hh(i+1,j))

      t3 = dt/hh(i,j) * (ti(i,j)-tt(i,j)) * huim1j / dx(j)
      t3 =
     >t3 * ggu(j) * (hh(i-1,j)+hh(i,j))

      df_dx_ijm1 = t1 
     >           + t2 
     >           + t3  


c     xx = tt(i,j)

      t1 = 1.
   
      t2 = -dt/dx(j) * (  0.5*(ukij  +abs(ukij  ))      
     >                   -0.5*(ukim1j-abs(ukim1j)) )     

      t3 = -dt/dy * (  0.5*(vkij  +abs(vkij  ))         
     >                -0.5*(vkijm1-abs(vkijm1)) )       

      t4 = dt/dx(j) * (ukij-ukim1j)                     
     >   + dt/dy    * (vkij-vkijm1)                     

      t5 = -dt/hh(i,j) * w_a

      t6 = -dt/hh(i,j) * w_i(i,j) 

      df_dx_ij = t1 + t2 + t3 + t4 + t5 + t6


c     Collect

      df_dx(n1,n2) = df_dx_im1jm1 * ia(i-1,j-1,n2) 
     >             + df_dx_im1j   * ia(i-1,j  ,n2)
     >             + df_dx_im1jp1 * ia(i-1,j+1,n2)
     >             + df_dx_ijp1   * ia(i  ,j+1,n2)
     >             + df_dx_ip1jp1 * ia(i+1,j+1,n2)
     >             + df_dx_ip1j   * ia(i+1,j  ,n2)
     >             + df_dx_ip1jm1 * ia(i+1,j-1,n2)  
     >             + df_dx_ijm1   * ia(i  ,j-1,n2)
     >             + df_dx_ij     * ia(i  ,j  ,n2)

c--
      enddo
c--


c---- df/dx: x = coefficients for apparent temperature

      n2 = n_tt
c--
      do n=1,ncoe
         n2           = n2 + 1
         df_dx(n1,n2) = dt * w_a/hh(i,j) * EExxxxx(n,i,j,'ta') 
      enddo
c--


c---- df/dx: x = coefficients for interior temperature

c--
      do n=1,ncoe
         n2           = n2 + 1
         df_dx(n1,n2) = dt * w_i(i,j)/hh(i,j) * EExxxxx(n,i,j,'ti')
      enddo
c--


c---- df/dx: x = coefficients for mixed layer depth

c--
      do n=1,ncoe
c--


c     Contribution 1 to df/dx

      t1 = -dt * w_a * (ta(i,j)-tt(i,j)) 
      t1 = 
     >t1 / hh(i,j)**2 * EExxxxx(n,i,j,'hh')


c     Contribution 2 to df/dx

      t2 = -dt * w_i(i,j) * (ti(i,j)-tt(i,j))
      t2 = 
     >t2 / hh(i,j)**2 * EExxxxx(n,i,j,'hh')
 

c     Contribution 3 to df/dx

      t3a = (uuij+utij) * (EExxxxx(n,i  ,j,'hh')+
     >                     EExxxxx(n,i+1,j,'hh')) 
      t3a =
     >t3a - (uuim1j+utim1j) * (EExxxxx(n,i-1,j,'hh')+
     >                         EExxxxx(n,i  ,j,'hh')) 
      t3a =
     >t3a / (2*dx(j))
      
      t3a = 
     >t3a * dt * (ti(i,j)-tt(i,j)) / hh(i,j)


      t3b = cp * (vvij+vtij) * (EExxxxx(n,i,j  ,'hh')+
     >                          EExxxxx(n,i,j+1,'hh')) 
      t3b =
     >t3b - cm * (vvijm1+vtijm1) * (EExxxxx(n,i,j-1,'hh')+
     >                              EExxxxx(n,i,j  ,'hh'))
      t3b =
     >t3b / (2*rds)

      t3b =
     >t3b * dt * (ti(i,j)-tt(i,j)) / hh(i,j)


      t3 = t3a + t3b


c     Counter for state variables

      n2 = n2 + 1


c     df/dx

      df_dx(n1,n2) = t1 + t2 + t3



c--
      enddo
c--


c---- df/dx: x = coefficients for zonal velocity

c--
      do n=1,ncoe
c--

c     Contribution 1 to df/dx

      t1 = tt(i  ,j)/2. * (1.+sign(1.,ukij  )) * EExxxxx(n,i  ,j,'uk')
     >   + tt(i+1,j)/2. * (1.-sign(1.,ukij  )) * EExxxxx(n,i  ,j,'uk')
     >   - tt(i-1,j)/2. * (1.+sign(1.,ukim1j)) * EExxxxx(n,i-1,j,'uk')  
     >   - tt(i  ,j)/2. * (1.-sign(1.,ukim1j)) * EExxxxx(n,i-1,j,'uk')
      t1 =
     >t1 * (-1)*dt/dx(j)

c     Contribution 2 to df/dx

      t2 = dt * tt(i,j)/dx(j) * ( EExxxxx(n,i  ,j,'uk')-
     >                            EExxxxx(n,i-1,j,'uk') )

c     Contribution 3 to df/dx

      t3 = dt/hh(i,j) * (ti(i,j)-tt(i,j)) / dx(j)
      t3 =
     >t3 * (huij  *EExxxxx(n,i  ,j,'uk')-
     >      huim1j*EExxxxx(n,i-1,j,'uk'))


c     Counter for state variables

      n2 = n2 + 1


c     df/dx

      df_dx(n1,n2) = t1 + t2 + t3


c--
      enddo
c--


c---- df/dx: x = coefficients for meridional velocity

c--
      do n=1,ncoe
c--

c     Contribution 1 to df/dx

      t1 = tt(i,j  )/2. * (1.+sign(1.,vkij  )) * EExxxxx(n,i,j  ,'vk')
     >   + tt(i,j+1)/2. * (1.-sign(1.,vkij  )) * EExxxxx(n,i,j  ,'vk')
     >   - tt(i,j-1)/2. * (1.+sign(1.,vkijm1)) * EExxxxx(n,i,j-1,'vk')  
     >   - tt(i,j  )/2. * (1.-sign(1.,vkijm1)) * EExxxxx(n,i,j-1,'vk')
      t1 =
     >t1 * (-1)*dt/dy

c     Contribution 2 to df/dx

      t2 = dt * tt(i,j)/dy * ( EExxxxx(n,i,j  ,'vk')-
     >                         EExxxxx(n,i,j-1,'vk') )

c     Contribution 3 to df/dx

      t3 = dt/hh(i,j) * (ti(i,j)-tt(i,j)) / rds
      t3 =
     >t3 * (hvij  *cp*EExxxxx(n,i,j  ,'vk')-
     >      hvijm1*cm*EExxxxx(n,i,j-1,'vk'))
      

c     Counter for state variables

      n2 = n2 + 1


c     df/dx

      df_dx(n1,n2) = t1 + t2 + t3

c--
      enddo
c--


c---- Test

      if (n2.ne.nN) then
         write(*,*)
         write(*,*) 'STOP 1 in df_dxxx.f: n2.ne.nN'
         write(*,*)
         stop
      endif


c---- End of loop 

c++
      enddo
      enddo
c++




c     ----------------------------------------------
c     Equations for ML temperature: Southern bry pts
c     ----------------------------------------------

c---- Start loop 

c++
      do i=1,idim
c++


c---- Test

      j = jS(i)-1

      do n=1,n_cor
         if (i.eq.i_cor(n) .and. j.eq.j_cor(n)) goto 111
      enddo


c---- Equation counter

      n1 = n1 + 1


c---- df/dx: x = ML temperature 

      do n2=1,n_tt

         if (strx(n2).eq.stringx('tt',i,j)) then
           df_dx(n1,n2) = 1. - dt*w_a/hh(i,j)
         endif 

      enddo


c---- df/dx: x = coefficients for apparent temperature

      n2 = n_tt

      do n=1,ncoe
         n2           = n2 + 1
         df_dx(n1,n2) = dt * w_a/hh(i,j) * EExxxxx(n,i,j,'ta') 
      enddo


c---- df/dx: x = coefficients for ML depth

      do n  = 1,ncoe    ! Skip interior temperature
         n2 = n2 + 1
      enddo

      do n=1,ncoe
                  n2  = n2 + 1
         df_dx(n1,n2) = dt * w_a * (ta(i,j)-tt(i,j))
         df_dx(n1,n2) =
     >   df_dx(n1,n2) * (-1./hh(i,j)**2) * EExxxxx(n,i,j,'hh') 
      enddo

      do iskip= 1,2     ! Skip horizontal velocities
      do n    = 1,ncoe
         n2   = n2 + 1
      enddo
      enddo


c---- Test

      if (n2.ne.nN) then
         write(*,*)
         write(*,*) 'STOP 2 in df_dxxx.f: n2.ne.nN'
         write(*,*)
         stop
      endif


c---- End loop 

c++
111   continue
      enddo
c++




c     ----------------------------------------------
c     Equations for ML temperature: Northern bry pts
c     ----------------------------------------------
 
c---- Start loop

c++
      do i=1,idim
c++


c---- Test

      j = jN(i)+1

      do n=1,n_cor
         if (i.eq.i_cor(n) .and. j.eq.j_cor(n)) goto 112
      enddo


c---- Equation counter

      n1 = n1 + 1


c---- df/dx: x = ML temperature 

      do n2=1,n_tt

         if (strx(n2).eq.stringx('tt',i,j)) then
           df_dx(n1,n2) = 1. - dt*w_a/hh(i,j)
         endif 

      enddo


c---- df/dx: x = coefficients for apparent temperature

      n2 = n_tt

      do n=1,ncoe
         n2           = n2 + 1
         df_dx(n1,n2) = dt * w_a/hh(i,j) * EExxxxx(n,i,j,'ta') 
      enddo


c---- df/dx: x = coefficients for ML depth

      do n  = 1,ncoe    ! Skip interior temperature
         n2 = n2 + 1
      enddo

      do n=1,ncoe
                  n2  = n2 + 1
         df_dx(n1,n2) = dt * w_a * (ta(i,j)-tt(i,j))
         df_dx(n1,n2) =
     >   df_dx(n1,n2) * (-1./hh(i,j)**2) * EExxxxx(n,i,j,'hh')  
      enddo

      do iskip= 1,2     ! Skip horizontal velocities
      do n    = 1,ncoe
         n2   = n2 + 1
      enddo
      enddo


c---- Test

      if (n2.ne.nN) then
         write(*,*)
         write(*,*) 'STOP 3 in df_dxxx.f: n2.ne.nN'
         write(*,*)
         stop
      endif


c---- End loop

c++
112   continue
      enddo
c++




c     ---------------------------------------------
c     Equations for ML temperature: Western bry pts
c     ---------------------------------------------

c---- Start loop 

c++
      do j=1,jdim
c++


c---- Test

      i = iW(j)-1 

      do n=1,n_cor
         if (i.eq.i_cor(n) .and. j.eq.j_cor(n)) goto 113
      enddo


c---- Equation counter

      n1 = n1 + 1


c---- df/dx: x = ML temperature 

      do n2=1,n_tt

         if (strx(n2).eq.stringx('tt',i,j)) then
           df_dx(n1,n2) = 1. - dt*w_a/hh(i,j)
         endif 

      enddo


c---- df/dx: x = coefficients for apparent temperature

      n2 = n_tt

      do n=1,ncoe
         n2           = n2 + 1
         df_dx(n1,n2) = dt * w_a/hh(i,j) * EExxxxx(n,i,j,'ta') 
      enddo


c---- df/dx: x = coefficients for ML depth

      do n  = 1,ncoe    ! Skip interior temperature
         n2 = n2 + 1
      enddo

      do n=1,ncoe
                  n2  = n2 + 1
         df_dx(n1,n2) = dt * w_a *(ta(i,j)-tt(i,j))
         df_dx(n1,n2) =
     >   df_dx(n1,n2) * (-1./hh(i,j)**2) * EExxxxx(n,i,j,'hh') 
      enddo

      do iskip= 1,2     ! Skip horizontal velocities
      do n    = 1,ncoe
         n2   = n2 + 1
      enddo
      enddo


c---- Test

      if (n2.ne.nN) then
         write(*,*)
         write(*,*) 'STOP 4 in df_dxxx.f: n2.ne.nN'
         write(*,*)
         stop
      endif


c---- End of loop

c++
113   continue
      enddo
c++




c     ---------------------------------------------
c     Equations for ML temperature: Eastern bry pts 
c     ---------------------------------------------

c---- Start loop

c++
      do j=1,jdim
c++


c---- Test

      i = iE(j)+1 

      do n=1,n_cor
         if (i.eq.i_cor(n) .and. j.eq.j_cor(n)) goto 114
      enddo


c---- Equation counter

      n1 = n1 + 1


c---- df/dx: x = ML temperature 

      do n2=1,n_tt

         if (strx(n2).eq.stringx('tt',i,j)) then
           df_dx(n1,n2) = 1. - dt*w_a/hh(i,j)
         endif 

      enddo


c---- df/dx: x = coefficients for apparent temperature

      n2 = n_tt

      do n=1,ncoe
         n2           = n2 + 1
         df_dx(n1,n2) = dt * w_a/hh(i,j) * EExxxxx(n,i,j,'ta') 
      enddo


c---- df/dx: x = coefficients for ML depth

      do n  = 1,ncoe    ! Skip interior temperature
         n2 = n2 + 1
      enddo

      do n=1,ncoe
                  n2  = n2 + 1
         df_dx(n1,n2) = dt * w_a *(ta(i,j)-tt(i,j))
         df_dx(n1,n2) =
     >   df_dx(n1,n2) * (-1./hh(i,j)**2) * EExxxxx(n,i,j,'hh') 
      enddo

      do iskip= 1,2     ! Skip horizontal velocities
      do n    = 1,ncoe
         n2   = n2 + 1
      enddo
      enddo


c---- Test

      if (n2.ne.nN) then
         write(*,*)
         write(*,*) 'STOP 5 in df_dxxx.f: n2.ne.nN'
         write(*,*)
         stop
      endif


c---- End loop

c++
114   continue
      enddo
c++




c     ----------------------------------------
c     Equations for ML temperature: Corner pts
c     ----------------------------------------

c---- Start loop 

c++
      do n_c=1,n_cor 
c++


c---- Indices

      i = i_cor(n_c)
      j = j_cor(n_c)


c---- Equation counter

      n1 = n1 + 1


c---- df/dx: x = ML temperature 

      do n2=1,n_tt

         if (strx(n2).eq.stringx('tt',i,j)) then
           df_dx(n1,n2) = 1. - dt*w_a/hh(i,j)
         endif 

      enddo


c---- df/dx: x = coefficients for apparent temperature

      n2 = n_tt

      do n=1,ncoe
         n2           = n2 + 1
         df_dx(n1,n2) = dt * w_a/hh(i,j) * EExxxxx(n,i,j,'ta') 
      enddo


c---- df/dx: x = coefficients for ML depth

      do n  = 1,ncoe    ! Skip interior temperature
         n2 = n2 + 1
      enddo

      do n=1,ncoe
                  n2  = n2 + 1
         df_dx(n1,n2) = dt * w_a *(ta(i,j)-tt(i,j))
         df_dx(n1,n2) =
     >   df_dx(n1,n2) * (-1./hh(i,j)**2) * EExxxxx(n,i,j,'hh') 
      enddo

      do iskip= 1,2     ! Skip horizontal velocities
      do n    = 1,ncoe
         n2   = n2 + 1
      enddo
      enddo


c---- Test

      if (n2.ne.nN) then
         write(*,*)
         write(*,*) 'STOP 6 in df_dxxx.f: n2.ne.nN'
         write(*,*)
         stop
      endif


c---- End of loop

c++
      enddo
c++




c     --------------------------
c     Equations for coefficients
c     --------------------------

c---- Apparent temperature

      do n=1,ncoe
         n1           = n1   + 1
         n2           = n_tt + n
         df_dx(n1,n2) = 1.
      enddo


c---- Interior temperature

      do n=1,ncoe
         n1           = n1   + 1
         n2           = n_tt + ncoe*1 + n
         df_dx(n1,n2) = 1.
      enddo


c---- Mixed layer depth

      do n=1,ncoe
         n1           = n1   + 1
         n2           = n_tt + ncoe*2 + n
         df_dx(n1,n2) = 1.
      enddo


c---- Zonal velocity (Ekman + saline) 

      do n=1,ncoe
         n1           = n1   + 1
         n2           = n_tt + ncoe*3 + n
         df_dx(n1,n2) = 1.
      enddo


c---- Meridional velocity (Ekman + saline) 

      do n=1,ncoe
         n1           = n1   + 1
         n2           = n_tt + ncoe*4 + n
         df_dx(n1,n2) = 1.
      enddo


c---- Test

      if (n2.ne.nN) then
        write(*,*)
        write(*,*) 'STOP 7 in df_dxxx.f: n2.ne.nN'
        write(*,*)
        stop
      endif




c     ----
c     Test
c     ----     

      if (n1.ne.nN) then
        write(*,*)
        write(*,*) 'STOP in df_dxxx.f: n1.ne.nN'
        write(*,*)
        stop
      endif




c     ---------------------
c     End of the subroutine
c     ---------------------

      return

      end

c     ******************************************************************
