c23456789012345678901234567890123456789012345678901234567890123456789012


      SUBROUTINE fil_ekf

c     ******************************************************************
c     This routine applies an Extended Kalman Filter
c
c     Called by:      	main 
c     Calls    :     	sv_to_x
c                       P_filxx
c                       QQxxxxx
c                       x_to_sv
c                       w_ixxxx
c                       writing
c                       df_dxxx
c                       choldc
c                       mod_int
c                       freezin
c                       sv_to_x
c                       zzRRHob
c                       choldc
c                       cholsl
c
c     Written by       : OM 
c     Last modification: 7/2015
c     ******************************************************************

c     ------------
c     Declarations
c     ------------

c     '''''''''''''''''''''
      implicit none
      include 'commonvar.f'      
c     '''''''''''''''''''''

c---- Internal variables

      integer   n1,n2,n,i,j

      integer   ip1,ip2,ip

      integer   it,i_cou,j_cou

      real*8    um,vm,cou

      real*8    pp(pdim),ppN(ndim),
     >          bb(pdim)

      real*8    approx,time

      character c50*50,c12*12

      integer   nN

      integer   nP
      common/nP/nP




c     ------------------------------
c     Initial state: x(0,+) & P(0,+) 
c     ------------------------------

c---- Dimension of state vector

      nN = n_tt + nvar*ncoe


c---- x(0,+) 

c     ----------------------
      call sv_to_x(x_fil,nN)
c     ----------------------


c---- P(0,+) 

c     Construct

c     ----------------
      call P_filxx(nN) 
c     ----------------

c     Print

      open (99,file='x_fil.r')
      do n=1,nN
         write(99,'(a8,a1,2f10.4)') strx(n),' ',     x_fil(n  ),
     >                                          sqrt(P_fil(n,n))
      enddo
      close (99)

 
c---- Q 

c     ----------------
      call QQxxxxx(nN)
c     ----------------

c     Print

      open (99,file='Q.r')
      do n1=1,nN
         write(99,*) n1,QQ(n1)
      enddo
      close (99)




c     ----------------------
c     Extended Kalman Filter 
c     ----------------------

c---- Write

c     Get tt()
c         ta()     ,coe_ta()
c         ti()     ,coe_ti()
c         hh()     ,coe_hh()
c         uu(),uk(),coe_uk()
c         vv(),vk(),coe_vk()

c     ----------------------------
      call x_to_sv(x_fil,P_fil,nN)
c     ----------------------------

c     Get w_i()

c     ------------
      call w_ixxxx
c     ------------

c     Write horizontal fields

c     -------------------------------
      call writing('tt_fil_xy',40,0)
      call writing('ta_fil_xy',41,0)
      call writing('uu_fil_xy',43,0)
      call writing('vv_fil_xy',44,0)
      call writing('hh_fil_xy',45,0)
      call writing('er_fil_xy',46,0)
c     -------------------------------

c     Write time series

c     ----------------------------------
      call writing('tt_fil_na8722',70,0)
      call writing('tt_fil_ch69k9',71,0)
      call writing('tt_fil_su8118',72,0)

      call writing('sf_fil_00'    ,81,0)
      call writing('sf_fil_09'    ,82,0)
      call writing('sf_fil_17'    ,83,0)
c     ----------------------------------


c---- Time loop

c     ***************
      do it=1,itot_fs
c     ***************


c---- Time in kyr B.P. (<0) 

      time = it*dt/yr - time_start


c---- Print time & Courant #

      cou  = 0.
      do i = 1    ,idim
      do j = jS(i),jN(i)

         um  = 0.5*(uu(i-1,j)+uu(i,j))*dt/dx(j)
         vm  = 0.5*(vv(i,j-1)+vv(i,j))*dt/dy

         if (abs(um).gt.cou) then
            i_cou = i
            j_cou = j
            cou   = abs(um)
         endif

         if (abs(vm).gt.cou) then
            i_cou = i
            j_cou = j
            cou   = abs(vm)
         endif

      enddo
      enddo


c---- Print time & Courant # 

      write(*,98) time,cou,i_cou,j_cou
98    format('t =',f10.2,' yr - cou =',f8.3,
     >                   ' i = ',i3,
     >                   ' j = ',i3)


c---- P(i,-): Compute (df/dx)_x(i-1,+)

c     ----------------
      call df_dxxx(nN) 
c     ---------------- 


c---- P(i,-): Compute (df/dx)_x(i-1,+) P(i-1,+) [(df/dx)_x(i-1,+)]'

c     -------------------------------------------------------------
      NN1(1:nN,1:nN) = matmul   (df_dx(1:nN,1:nN),P_fil(1:nN,1:nN))
      NN2(1:nN,1:nN) = transpose(NN1  (1:nN,1:nN)                 )
      Pm (1:nN,1:nN) = matmul   (df_dx(1:nN,1:nN),NN2  (1:nN,1:nN))
c     -------------------------------------------------------------


c---- P(i,-) = (df/dx)_x(i-1,+) P(i-1,+) (df/dx)_x(i-1,+)' + Q(i-1)

      do n1=1,nN
         Pm(n1,n1) = Pm(n1,n1) + QQ(n1)
      enddo

c     Symmetrize
c
c     Note
c     ----
c     See Brown & Hwang (1997, p. 261) 

      do n1=1+1,nN
      do n2=1  ,n1-1
         Pm(n1,n2) = Pm(n2,n1)
      enddo
      enddo


c---- x(i,-) = f[x(i-1,+)]

c     Integrate & Test for sub-freezing T 

c     ------------
      call mod_int
      call freezin
c     ------------

c     Construct x(i,-) 

c     -------------------
      call sv_to_x(xm,nN)
c     -------------------


c---- z(i) & R(i) & H(i) & test & print 

c     z(i) & R(i) & H(i)

c     ---------------------
      call zzRRHob(time,nP)
c     ---------------------

c     Test

      if (nP.eq.0) then
         x_fil = xm
         P_fil = Pm
         goto 111
      endif

c     Print

      write(*,*)
      do ip=1,nP
         write(*,889) ip,' ',c_obs(ip),zz(ip),sqrt(RR(ip,ip))
      enddo
      write(*,*)
889   format(i4,a1,a4,2f11.4)


c---- K(i): H(i)P(i,-)H(i)' + R(i)

c     ----------------------------------------------------------------
      HP       (1:nP,1:nN) = matmul   (Hob(1:nP,1:nN),Pm(1:nN,1:nN  ))
      PH_T     (1:nN,1:nP) = transpose(HP (1:nP,1:nN)                )
      HPH_T_p_R(1:nP,1:nP) = matmul   (Hob(1:nP,1:nN),PH_T(1:nN,1:nP))
c     ----------------------------------------------------------------

      HPH_T_p_R(1:nP,1:nP) = 
     >HPH_T_p_R(1:nP,1:nP) + RR(1:nP,1:nP)


c---- K(i): [H(i)P(i,-)H(i)'+R(i)]^(-1) 

      PP1(1:nP,1:nP) = HPH_T_p_R(1:nP,1:nP)
c     --------------------------------------
      call choldc(PP1,nP,pdim,pp,'HPH_T+R ')
c     --------------------------------------

      do ip2=1,nP
         bb      = 0.
         bb(ip2) = 1.
c        -------------------------------------------------
         call cholsl(PP1,nP,pdim,pp,bb,HPH_T_p_R_1(1,ip2))
c        -------------------------------------------------
      enddo


c---- K(i) = P(i,-)H(i)' [H(i)P(i,-)H(i)'+R(i)]^(-1)

      KK(1:nN,1:nP) = matmul(PH_T(1:nN,1:nP),HPH_T_p_R_1(1:nP,1:nP))


c---- x(i,+): z(i) - H(i)x(i,-) 

      zz_Hx(1:nP) = zz(1:nP) - matmul(Hob(1:nP,1:nN),xm(1:nN)) 


c---- x(i,+) = x(i,-) + K(i) (z(i)-H(i)x(i,-))

      x_fil(1:nN) = xm(1:nN) + matmul(KK(1:nN,1:nP),zz_Hx(1:nP))


c---- P(i,+): I - K(i)H(i)

      NN1(1:nN,1:nN) = - matmul(KK(1:nN,1:nP),Hob(1:nP,1:nN))

      do n1=1,nN
         NN1(n1,n1) = 1. + NN1(n1,n1)
      enddo


c---- P(i,+): [I - K(i)H(i)] P(i,-) [I - K(i)H(i)]'

      NN2  (1:nN,1:nN) = matmul   (NN1(1:nN,1:nN),Pm (1:nN,1:nN))
      NN3  (1:nN,1:nN) = transpose(NN2(1:nN,1:nN)               )
      P_fil(1:nN,1:nN) = matmul   (NN1(1:nN,1:nN),NN3(1:nN,1:nN))


c---- P(i,+): K(i) R(i) K(i)'

      KR  (1:nN,1:nP) = matmul   (KK(1:nN,1:nP),RR  (1:nP,1:nP))
      RK_T(1:nP,1:nN) = transpose(KR(1:nN,1:nP)                )
      NN1 (1:nN,1:nN) = matmul   (KK(1:nN,1:nP),RK_T(1:nP,1:nN))


c---- P(i,+): [I - K(i)H(i)] P(i,-) [I - K(i)H(i)] + K(i) R(i) K(i)'

      P_fil(1:nN,1:nN) = P_fil(1:nN,1:nN) + NN1(1:nN,1:nN)

c     Symmetrize
c
c     Note
c     ----
c     See Brown & Hwang (1997, p. 261) 

      do n1=1+1,nN 
      do n2=1  ,n1-1
         P_fil(n1,n2) = P_fil(n2,n1)
      enddo
      enddo


c---- Get tt()
c         ta()     ,coe_ta()
c         ti()     ,coe_ti()
c         hh()     ,coe_hh()
c         uu(),uk(),coe_uk()
c         vv(),vk(),coe_vk()

c     ----------------------------
111   call x_to_sv(x_fil,P_fil,nN)
c     ----------------------------

c     Test for sub-freezing T

c     ------------
      call freezin
c     ------------

c     Get w_i()

c     ------------
      call w_ixxxx
c     ------------


c---- Write: Every yr 

      if (mod(it,i_dt).eq.0) then       

c        -----------------------------------
         call writing('tt_fil_na8722',70,it)    
         call writing('tt_fil_ch69k9',71,it)        
         call writing('tt_fil_su8118',72,it)   
c        -----------------------------------

      endif


c---- Write: Every yr for which data is available

      if (nP.gt.0) then

c        -------------------------------
         call writing('res_fil'  ,79,it)         

         call writing('tt_fil_xy',40,it)
         call writing('ta_fil_xy',41,it)
         call writing('uu_fil_xy',43,it)
         call writing('vv_fil_xy',44,it)
         call writing('hh_fil_xy',45,it)
         call writing('er_fil_xy',46,it)

         call writing('sf_fil_00',81,it)         
         call writing('sf_fil_09',82,it)       
         call writing('sf_fil_17',83,it)       
c        -------------------------------

      endif


c---- End of time loop

c     *****
      enddo
c     *****




c     ---------------------
c     End of the subroutine
c     ---------------------

      return

      end

c     ******************************************************************
