c23456789012345678901234567890123456789012345678901234567890123456789012


      SUBROUTINE iaxxxxx 

c     ******************************************************************
c     This routine returns - a character string for each state variable
c                          - binary coefficients for ML temperature eq. 
c
c     Called by:      	MAIN 
c     Calls    :     	none	
c
c     Written by       : OM  
c     Last modification: 7/2015
c     ******************************************************************

c     ------------
c     Declarations
c     ------------

c     '''''''''''''''''''''
      implicit none
      include 'commonvar.f'      
c     '''''''''''''''''''''

c---- Internal variables

      integer   i,j,n,n2,n_c,nN


c---- FUNCTION statement

      character*8 stringx




c     ------------------------------------
c     Character string for state variables
c     ------------------------------------

c---- Initialize

      n2 = 0


c---- ML temperatures

c     Interior pts

      do i=1    ,idim
      do j=jS(i),jN(i)

         n2       = n2 + 1
c        ----------------------------
         strx(n2) = stringx('tt',i,j)
c        ----------------------------
      enddo
      enddo


c     Southern bry (excluding corners)

      do i=1,idim

         do n=1,n_cor
            if (i      .eq.i_cor(n) .and.
     >          jS(i)-1.eq.j_cor(n)) goto 101 
         enddo 

         n2       = n2 + 1
c        ----------------------------------
         strx(n2) = stringx('tt',i,jS(i)-1)
c        ----------------------------------
101      continue

      enddo


c     Northern bry (excluding corners)

      do i=1,idim

         do n=1,n_cor
            if (i      .eq.i_cor(n) .and.
     >          jN(i)+1.eq.j_cor(n)) goto 102
         enddo

         n2       = n2 + 1
c        ----------------------------------
         strx(n2) = stringx('tt',i,jN(i)+1)
c        ----------------------------------
102      continue

      enddo


c     Western bry (excluding corners)

      do j=1,jdim

         do n=1,n_cor
            if (iW(j)-1.eq.i_cor(n) .and.
     >          j      .eq.j_cor(n)) goto 103
         enddo

         n2       = n2 + 1
c        ----------------------------------
         strx(n2) = stringx('tt',iW(j)-1,j)
c        ----------------------------------
103      continue

      enddo


c     Eastern bry (excluding corners)

      do j=1,jdim

         do n=1,n_cor
            if (iE(j)+1.eq.i_cor(n) .and.
     >          j      .eq.j_cor(n)) goto 104
         enddo

         n2       = n2 + 1
c        ----------------------------------
         strx(n2) = stringx('tt',iE(j)+1,j)
c        ----------------------------------
104      continue

      enddo


c     Corners

      do n_c=1,n_cor
         n2       = n2 + 1
c        ----------------------------------------------
         strx(n2) = stringx('tt',i_cor(n_c),j_cor(n_c))
c        ----------------------------------------------
      enddo


c     Number of interior & bry ML temperatures

      n_tt = n2     
   

c---- Polynomial coefficients 

c     Apparent temperature

      do n=1,ncoe
         n2       = n2 + 1
c        ----------------------------
         strx(n2) = stringx('ta',n,0)
c        ----------------------------
      enddo

c     Interior temperature

      do n=1,ncoe
         n2       = n2 + 1
c        ----------------------------
         strx(n2) = stringx('ti',n,0)
c        ----------------------------
      enddo


c     Mixed layer depth

      do n=1,ncoe
         n2       = n2 + 1
c        ----------------------------
         strx(n2) = stringx('hh',n,0)
c        ----------------------------
      enddo


c     Zonal velocity (Ekman + haline) 

      do n=1,ncoe
         n2       = n2 + 1
c        ----------------------------
         strx(n2) = stringx('uk',n,0)
c        ----------------------------
      enddo


c     Meridional velocity (Ekman + haline) 

      do n=1,ncoe
         n2       = n2 + 1
c        ----------------------------
         strx(n2) = stringx('vk',n,0)
c        ----------------------------
      enddo


c---- Test & write

      nN = n_tt + nvar*ncoe

      if (n2.ne.nN) then
        write(*,*)
        write(*,*) 'STOP in iaxxxxx.f: n2.ne.nN'
        write(*,*)
        stop
      endif
c--
      open (99,file='strx.r')
      do n2=1,nN
         write(99,*) n2,strx(n2)
      enddo
      close (99)




c     -------------------------------------------------
c     Binary coefficients: Equations for ML temperature
c     -------------------------------------------------

c---- Initialize

      ia = 0


c---- Assign 

c++
      do i=1    ,idim
      do j=jS(i),jN(i)

         do n2=1,n_tt
            if (strx(n2).eq.stringx('tt',i-1,j-1)) ia(i-1,j-1,n2) = 1
            if (strx(n2).eq.stringx('tt',i-1,j  )) ia(i-1,j  ,n2) = 1 
            if (strx(n2).eq.stringx('tt',i-1,j+1)) ia(i-1,j+1,n2) = 1
            if (strx(n2).eq.stringx('tt',i  ,j+1)) ia(i  ,j+1,n2) = 1
            if (strx(n2).eq.stringx('tt',i+1,j+1)) ia(i+1,j+1,n2) = 1 
            if (strx(n2).eq.stringx('tt',i+1,j  )) ia(i+1,j  ,n2) = 1
            if (strx(n2).eq.stringx('tt',i+1,j-1)) ia(i+1,j-1,n2) = 1 
            if (strx(n2).eq.stringx('tt',i  ,j-1)) ia(i  ,j-1,n2) = 1 
            if (strx(n2).eq.stringx('tt',i  ,j  )) ia(i  ,j  ,n2) = 1 
        enddo

      enddo
      enddo
c++




c     ---------------------
c     End of the subroutine
c     ---------------------

      return

      end

c     ******************************************************************
