c23456789012345678901234567890123456789012345678901234567890123456789012


      INTEGER FUNCTION indexxx(lon0,lat0,c3)

c     ******************************************************************
c     This routine returns the longitude or latitude index of a sediment
c     record
c     
c     Called by:        selxxxx 
c     Calls    :        none   
c
c     Written by       : OM  
c     Last modification: 7/2015
c     ******************************************************************

c     ------------
c     Declarations
c     ------------

c     '''''''''''''''''''''
      implicit none
      include 'commonvar.f'
c     '''''''''''''''''''''

c---- Argument variables

      real*8    lon0,lat0

      character c3*3


c---- Internal variables

      integer   i,i_sel,
     >          j,j_sel

      real*8    geo_dis,dum




c     ---------------------------
c     Longitude or latitude index
c     ---------------------------

c---- Test based on geodesic distance

      dum = 2*pi*r_0

      do i=0,idim+1
      do j=0,jdim+1

           geo_dis = sin(lat0)*sin(lat(j))
     >             + cos(lat0)*cos(lat(j))*cos(lon0-lon(i))

           geo_dis = r_0 * acos(geo_dis)

           if (geo_dis.lt.dum) then
              dum   = geo_dis
              i_sel = i
              j_sel = j
           endif

      enddo
      enddo


c---- Assign function

      if (c3.eq.'lon') indexxx = i_sel
      if (c3.eq.'lat') indexxx = j_sel




c     -------------------
c     End of the function 
c     -------------------

      return

      end

c     ******************************************************************
