c23456789012345678901234567890123456789012345678901234567890123456789012


      PROGRAM main 

c     ******************************************************************
c     This program applies Kalman filters & a smoother to combine:
c
c               - North Atlantic sediment SST records with 
c               - an advective model of the ocean mixed layer 
c
c     Written by       : Olivier Marchal (OM)	
c     Last modification: 8/2015
c     ******************************************************************


c     ------------
c     Declarations
c     ------------

c     '''''''''''''''''''''
      implicit none
      include 'commonvar.f'
c     ''''````````'''''''''

c---- Integer 

      integer   n




c     ---------------
c     Read parameters 
c     ---------------

c---- Print & read output file extension 

      write(*,*)
      write(*,*) '-------------------------------------'
      write(*,*) 'Enter the extension of the START file'
      write(*,*) '-------------------------------------'
      write(*,*)

      read (*,*)  tag

      write(*,*)
      write(*,*) 'Name of START file: ',tag
      write(*,*)


c---- Read - c3_KF:   version of Kalman Filter 
c          - i_Store: writing option for x(i,) & P(i,+)
c          - ncoe:    number of polynomial coefficients
c          - fac_p0*: factor for variance of initial state error  
c          - fac_q*:  factor for variance of equation error 

      open (8,file='start.'//tag,status='old')

      read (8,*) c3_KF
      read (8,*) i_Store
      read (8,*) ncoe 

      read (8,*) fac_p0_tt 
      read (8,*) fac_p0_ta
      read (8,*) fac_p0_ti
      read (8,*) fac_p0_hh
      read (8,*) fac_p0_uk
      read (8,*) fac_p0_vk 

      read (8,*) fac_q_tt
      read (8,*) fac_q_ta
      read (8,*) fac_q_ti
      read (8,*) fac_q_hh
      read (8,*) fac_q_uk 
      read (8,*) fac_q_vk

      close(8)


c---- Test that ncoe.le.ncoedim

      if (ncoe.gt.ncoedim) then
         write(*,*)
         write(*,*) 'STOP in main.f: ncoe.gt.ncoedim'
         write(*,*)
         stop
      endif




c     -------------
c     Preliminaries
c     -------------

c---- Open output files

c     ------------
      call opening
c     ------------


c---- Set-up - latitudes & longitudes 
c            - point indices
c            - parameters for df/dx 

c     ------------
      call setting
c     ------------


c---- Character string for state variables
c     Binary coefficients

c     ------------
      call iaxxxxx
c     ------------


c---- Read & select sediment SST records

c     --------------------
      call reading('reco')
c     --------------------

      do n=1,n_rec
c        ---------------
         call selxxxx(n)
c        ---------------
      enddo




c     -----------------------------------------------
c     Estimate modern state of surface North Atlantic 
c     -----------------------------------------------

c---- Print 

      write(*,*)
      write(*,*)
      write(*,*) '---------------------------------------'
      write(*,*) 'Estimate modern state of surface NA ...'
      write(*,*) '---------------------------------------'
      write(*,*)


c---- Estimate

c     ------------
      call mod_sta
c     ------------

 


c     --------------------
c     Filtering experiment 
c     --------------------

c---- Print 

      write(*,*)
      write(*,*)
      write(*,*) '------------------------'
      write(*,*) 'Filtering experiment ...'
      write(*,*) '------------------------'
      write(*,*)


c---- Length of filtering & smoothing experiments
c
c     Note
c     ----
c     The 1st factor of itot_fs is in [yr]
c     The 2nd factor of itot_fs is # time steps per yr

      itot_fs = 14500 * i_dt 


c---- x(i,+) & P(i,+)

c     --------------------------------
      if (c3_KF.eq.'LKF') call fil_lkf
      if (c3_KF.eq.'EKF') call fil_ekf
c     --------------------------------




c     --------------------
c     Smoothing experiment 
c     --------------------

c---- Print 

      write(*,*)
      write(*,*)
      write(*,*) '------------------------'
      write(*,*) 'Smoothing experiment ...'
      write(*,*) '------------------------'
      write(*,*)


c---- x(i,N) & P(i,N)

      if (c3_KF.eq.'LKF' .and. i_Store.eq.1) then
c        ------------
         call smoothe 
c        ------------
      endif




c     --------------
c     End of program
c     --------------

c---- Advertise

      write(*,*)
      write(*,*)
      write(*,*) '----------------------------'
      write(*,*) 'Normal exit: file extension: ',tag
      write(*,*) '----------------------------'
      write(*,*)


c---- End statement

      end

c     ******************************************************************
