C23456789012345678901234567890123456789012345678901234567890123456789012


      SUBROUTINE mod_int

c     ******************************************************************
c     This routine solves the temperature equation with explicit scheme 
c
c     Called by:        main	
c     Calls    :        w_ixxxx	
c
c     Written by       : OM  
c     Last modification: 8/2015
c     ******************************************************************

c     ------------
c     Declarations
c     ------------

c     '''''''''''''''''''''
      implicit none
      include 'commonvar.f'      
c     '''''''''''''''''''''

c---- Internal variables

      integer	i,j,n,n1,n2

      real*8    uuim1j,
     >          uuij  ,
     >          vvij  ,
     >          vvijm1

      real*8    a_im1j,
     >          a_ijp1,
     >          a_ip1j,
     >          a_ijm1,
     >          a_ij 

      real*8    d_tt(0:idim+1,0:jdim+1)




c     ------------------------------------------
c     Changes of ML temperature: Interior points
c     ------------------------------------------

c---- Vertical interior velocities

c     ------------
      call w_ixxxx
c     ------------


c---- Initialize

      d_tt = 0.


c---- Interior pts

c++
      do i=1    ,idim
      do j=jS(i),jN(i)
c++

c     u's

      uuim1j = uk(i-1,j)
      uuij   = uk(i  ,j)

c     v's 

      vvij   = vk(i,j  ) 
      vvijm1 = vk(i,j-1)

c     Factors

      a_im1j =  dt * 0.5*(uuim1j+abs(uuim1j)) / dx(j)
      a_ijp1 = -dt * 0.5*(vvij  -abs(vvij  )) / dy
      a_ip1j = -dt * 0.5*(uuij  -abs(uuij  )) / dx(j)
      a_ijm1 =  dt * 0.5*(vvijm1+abs(vvijm1)) / dy
      a_ij   = -dt * 0.5*(uuij  +abs(uuij  )) / dx(j)
     >       +  dt * 0.5*(uuim1j-abs(uuim1j)) / dx(j)
     >       -  dt * 0.5*(vvij  +abs(vvij  )) / dy
     >       +  dt * 0.5*(vvijm1-abs(vvijm1)) / dy

c     Change 

      d_tt(i,j) = a_im1j * tt(i-1,j  )
     >          + a_ijp1 * tt(i  ,j+1)
     >          + a_ip1j * tt(i+1,j  )
     >          + a_ijm1 * tt(i  ,j-1)
     >          + a_ij   * tt(i  ,j  )  

      d_tt(i,j) =
     >d_tt(i,j) + dt * ( (uuij-uuim1j)/dx(j)
     >                  +(vvij-vvijm1)/dy   ) * tt(i,j)

      d_tt(i,j) =
     >d_tt(i,j) + dt * w_a     /hh(i,j) * (ta(i,j)-tt(i,j))
     >          + dt * w_i(i,j)/hh(i,j) * (ti(i,j)-tt(i,j))


c++
      enddo
      enddo
c++




c     ------------------------------------------
c     Changes of ML temperature: Boundary points
c     ------------------------------------------

c---- Southern bry pts

c++
      do i=1,idim
c++

c     Test

      j = jS(i)-1

      do n=1,n_cor
         if (i.eq.i_cor(n) .and. j.eq.j_cor(n)) goto 111
      enddo

c     Change 

      d_tt(i,j) = dt * w_a/hh(i,j) * (ta(i,j)-tt(i,j))

c++
111   continue
      enddo
c++


c---- Northern bry pts

c++
      do i=1,idim
c++

c     Test

      j = jN(i)+1

      do n=1,n_cor
         if (i.eq.i_cor(n) .and. j.eq.j_cor(n)) goto 112
      enddo

c     Change

      d_tt(i,j) = dt * w_a/hh(i,j) * (ta(i,j)-tt(i,j))

c++
112   continue
      enddo
c++


c---- Western boundary pts

c++
      do j=1,jdim
c++

c     Test

      i = iW(j)-1 

      do n=1,n_cor
         if (i.eq.i_cor(n) .and. j.eq.j_cor(n)) goto 113
      enddo

c     Change

      d_tt(i,j) = dt * w_a/hh(i,j) * (ta(i,j)-tt(i,j))

c++
113   continue
      enddo
c++


c---- Eastern bry pts

c++
      do j=1,jdim
c++

c     Test

      i = iE(j)+1 

      do n=1,n_cor
         if (i.eq.i_cor(n) .and. j.eq.j_cor(n)) goto 114
      enddo

c     Change

      d_tt(i,j) = dt * w_a/hh(i,j) * (ta(i,j)-tt(i,j))

c++
114   continue
      enddo
c++


c---- Corner pts

      do n=1,n_cor 

         i = i_cor(n)
         j = j_cor(n)

         d_tt(i,j) = dt * w_a/hh(i,j) * (ta(i,j)-tt(i,j))

      enddo
 



c     ---------------------
c     Update ML temperature
c     ---------------------

      do i=0,idim+1
      do j=0,jdim+1

         tt(i,j) = tt(i,j) + d_tt(i,j)

      enddo
      enddo




c     ---------------------
c     End of the subroutine
c     ---------------------

      return

      end

c     ******************************************************************
