C23456789012345678901234567890123456789012345678901234567890123456789012


      SUBROUTINE mod_sta

c     ******************************************************************
c     This routine returns a modern state of surface North Atlantic
c                       - based only on observations
c                       - based      on observations & model solution
c
c     Called by:        main
c     Calls    :        reading
c                       coepoly
c                       writing
c                       freezin
c                       mod_int
c
c     Written by       : OM  
c     Last modification: 7/2015
c     ******************************************************************

c     ------------
c     Declarations
c     ------------

c     '''''''''''''''''''''
      implicit none
      include 'commonvar.f'      
c     '''''''''''''''''''''

c---- Internal variables

      integer	it,i,j,n,n1,n2,kc

      integer   itot,if,i_cou,j_cou

      real*8    um    ,
     >          vm    ,
     >          time  ,cou,
     >          approx


c---- FUNCTION statements

      real*8    EExxxxx,
     >          uuxxxxx,
     >          vvxxxxx




c     ------------------
c     Initial conditions
c     ------------------

c---- ML temperature

c     --------------------
      call reading('sstx')
c     --------------------

      tt = amiss_uvht

      do i=0,idim+1
      do j=0,jdim+1
         if (ipt(i,j).ge.0) tt(i,j) = sst_WOA_g(i,j) 
      enddo
      enddo


c---- ML salinity

c     --------------------
      call reading('sssx')
c     --------------------

      s0 = amiss_uvht

      do i=0,idim+1
      do j=0,jdim+1
         if (ipt(i,j).ge.0) s0(i,j) = sss_WOA_g(i,j)
      enddo
      enddo


c---- Apparent temperature

c     Original values

      ta = amiss_uvht

      do i=0,idim+1
      do j=0,jdim+1
         if (ipt(i,j).ge.0) ta(i,j) = sst_WOA_g(i,j)
      enddo
      enddo

c     Polynomial coefficients

c     ----------------------
      call coepoly('coe_ta')
c     ----------------------

c     Residuals 

      do i=0,idim+1
      do j=0,jdim+1

         if (ipt(i,j).ge.0) then
            approx = 0.
            do n=1,ncoe
               approx = approx + coe_ta(n)*EExxxxx(n,i,j,'ta')
            enddo
         endif
         ta_r(i,j) = ta(i,j) - approx

      enddo
      enddo


c---- Interior temperature

c     Original values

      ti = amiss_uvht

      do i=0,idim+1
      do j=0,jdim+1
         if (ipt(i,j).ge.0) ti(i,j) = sst_WOA_g(i,j) - d_ti
      enddo
      enddo

c     Polynomial coefficients

c     ----------------------
      call coepoly('coe_ti')
c     ----------------------

c     Residuals

      do i=0,idim+1
      do j=0,jdim+1

         if (ipt(i,j).ge.0) then
            approx = 0.
            do n=1,ncoe
               approx = approx + coe_ti(n)*EExxxxx(n,i,j,'ti')
            enddo
         endif
         ti_r(i,j) = ti(i,j) - approx

      enddo
      enddo


c---- ML depth

c     --------------------
      call reading('mldx')
c     --------------------

c     Original values

      hh = amiss_uvht

      do i=0,idim+1
      do j=0,jdim+1
         if (ipt(i,j).ge.0) hh(i,j) = mld_WOA_g(i,j)    
      enddo
      enddo

c     Polynomial coefficients

c     ----------------------
      call coepoly('coe_hh')
c     ----------------------

c     Residuals 

      do i=0,idim+1
      do j=0,jdim+1

         if (ipt(i,j).ge.0) then
            approx = 0.
            do n=1,ncoe
               approx = approx + coe_hh(n)*EExxxxx(n,i,j,'hh')
            enddo
         endif
         hh_r(i,j) = hh(i,j) - approx

      enddo
      enddo


c---- Zonal velocity (Ekman + haline)

c     Original values

c     --------------------
      call reading('wind')
c     --------------------

      uk = amiss_uvht

      do i=0,idim
      do j=0,jdim+1
         if (ipt(i  ,j).eq.1 .or. 
     >       ipt(i+1,j).eq.1) uk(i,j) = uuxxxxx(i,j,1,0,1) 
      enddo
      enddo

c     Polynomial coefficients 

c     ----------------------
      call coepoly('coe_uk') 
c     ----------------------

c     Residuals 

      do i=0,idim
      do j=0,jdim+1

         if (ipt(i,j).eq.1 .or. ipt(i+1,j).eq.1) then
            approx = 0.
            do n=1,ncoe
               approx = approx + coe_uk(n)*EExxxxx(n,i,j,'uk')
            enddo
         endif
         uk_r(i,j) = uk(i,j) - approx

      enddo
      enddo


c---- Meridional velocity (Ekman + haline) 

c     Original values

      vk = amiss_uvht

      do i=0,idim+1
      do j=0,jdim
         if (ipt(i,j  ).eq.1 .or. 
     >       ipt(i,j+1).eq.1) vk(i,j) = vvxxxxx(i,j,1,0,1)
      enddo
      enddo

c     Polynomial coefficients 

c     ----------------------
      call coepoly('coe_vk') 
c     ----------------------

c     Residuals 

      do i=0,idim+1
      do j=0,jdim

         if (ipt(i,j).eq.1 .or. ipt(i,j+1).eq.1) then
            approx = 0.
            do n=1,ncoe
               approx = approx + coe_vk(n)*EExxxxx(n,i,j,'vk')
            enddo
         endif
         vk_r(i,j) = vk(i,j) - approx

      enddo
      enddo




c     -----
c     Write
c     ----- 

c---- Zonal & meridional velocities (Ekman + thermal + haline) 

      do i=0,idim
      do j=0,jdim+1
         if (ipt(i  ,j).eq.1 .or.
     >       ipt(i+1,j).eq.1) uu(i,j) = 
     >                        uk(i,j) + uuxxxxx(i,j,0,1,0) 
      enddo
      enddo
c--
      do i=0,idim+1
      do j=0,jdim
         if (ipt(i,j  ).eq.1 .or.
     >       ipt(i,j+1).eq.1) vv(i,j) = 
     >                        vk(i,j) + vvxxxxx(i,j,0,1,0) 
      enddo
      enddo


c---- Write

c     ------------------------------
      call writing('tt_sim_xy',20,0)
      call writing('ta_sim_xy',21,0)
      call writing('uu_sim_xy',23,0)
      call writing('vv_sim_xy',24,0)
      call writing('hh_sim_xy',25,0)
c--
      call writing('s0_sim_xy',36,0)
c     ------------------------------ 


c---- Test for sub-freezing ML & interior temperatures 

c     ------------
      call freezin
c     ------------


c---- RETURN statement
c
c     Note
c     ----
c     RETURN statement below should be activated
c     for modern state based only on observations
     
      return 




c     ---------
c     Time loop 
c     ---------

c---- Number of iterations

      itot = 100 * i_dt


c---- Time loop

c     ************
      do it=1,itot
c     ************


c---- Time [yr]

      time = it*dt / yr


c---- Zonal & meridional velocities (Ekman + thermal + haline) 

      do i=0,idim
      do j=0,jdim+1
         if (ipt(i  ,j).eq.1 .or.
     >       ipt(i+1,j).eq.1) uu(i,j) = 
     >                        uk(i,j) + uuxxxxx(i,j,0,1,0)
      enddo
      enddo
c--
      do i=0,idim+1
      do j=0,jdim
         if (ipt(i,j  ).eq.1 .or.
     >       ipt(i,j+1).eq.1) vv(i,j) = 
     >                        vk(i,j) + vvxxxxx(i,j,0,1,0)
      enddo
      enddo


c---- Courant #

      cou  = 0.
      do i = 1    ,idim
      do j = jS(i),jN(i)

         um  = 0.5*(uu(i-1,j)+uu(i,j))*dt/dx(j)
         vm  = 0.5*(vv(i,j-1)+vv(i,j))*dt/dy

         if (abs(um).gt.cou) then
            i_cou = i
            j_cou = j
            cou   = abs(um)
         endif

         if (abs(vm).gt.cou) then
            i_cou = i
            j_cou = j
            cou   = abs(vm)
         endif

      enddo
      enddo


c---- Print time & Courant # 

      if (itot.ge.100) then
         if (mod(it,itot/10).eq.0) write(*,98) time,cou,i_cou,j_cou
      else
                                   write(*,98) time,cou,i_cou,j_cou
      endif
98    format('t =',f10.2,' yr - cou =',f8.3,
     >                   ' i = ',i3,
     >                   ' j = ',i3)


c---- Integrate & test for sub-freezing T

c     ------------
      call mod_int
      call freezin
c     ------------


c---- Write horizontal fields

      if (mod(it,itot/10).eq.0) then  
c        -------------------------------
         call writing('tt_sim_xy',20,it)
         call writing('uu_sim_xy',23,it)
         call writing('vv_sim_xy',24,it)
c        -------------------------------
      endif


c---- End of time loop

c     **********
      enddo
      write(*,*)
      write(*,*)
c     **********




c     ---------------------
c     End of the subroutine
c     ---------------------

      return

      end

c     ******************************************************************
