c23456789012345678901234567890123456789012345678901234567890123456789012


      SUBROUTINE reading(c4) 

c     ******************************************************************
c     This routine reads - annual mean SCOW wind stresses 
c                        - sediment SST records 
c                        - WOA13 annual mean SSTs & std errors
c                        - WOA13 annual mean SSSs
c                        - WOA94 monthly mean MLD
c
c     Called by:      	main,mod_sta 
c     Calls    :        none	
c
c     Written by       : OM  
c     Last modification: 7/2015
c     ******************************************************************

c     ------------
c     Declarations
c     ------------

c     '''''''''''''''''''''
      implicit none
      include 'commonvar.f'      
c     '''''''''''''''''''''

c---- Argument variable

      character	c4*4


c---- Internal variables

      integer	i,j,i1,j1,kc,it


c---- Sediment core variables

      integer    if,ic,i_jum,i_age,i_tem

      real*8    dum 

      character*50 c_core,
     >             c_cita,
     >             c_lati,
     >             c_long,
     >             c_dept,
     >             c_comm,
     >             c_code

      character    filename*100,filn*100


c---- SCOW variables

      real*8    lat_v,lon_v,
     >          lat_u,lon_u,
     >          lat_c,lon_c


c---- SST variables

      integer   k,kz

      character c3*3




c     -----------------------------------
c     Read annual mean SCOW wind stresses  
c     -----------------------------------

c---- Test

c     **********************
      if (c4.eq.'wind') then
c     **********************


c---- Read longitudes

      open (10,file='longitudes.txt')
      do i=1,i_scow
         read(10,*) lon_scow(i)
      enddo
      close(10)

      lon_scow = lon_scow - 360.


c---- Read latitudes

      open (10,file='latitudes.txt')
      do j=1,j_scow
         read(10,*) lat_scow(j)
      enddo
      close(10)


c---- Read wind stresses 

      open (10,file='tau_x_ann.txt')
      open (11,file='tau_y_ann.txt')

      do i=1,i_scow
         read(10,*) (tau_x_scow(i,j),j=1,j_scow)
         read(11,*) (tau_y_scow(i,j),j=1,j_scow)
      enddo

      close(10)
      close(11)


c---- Zonal wind stress at v-carrier pts (including exterior pts)

c++
      do i= 0,idim+1
      do j=-1,jdim+1
c++

         lat_v = lat_S - dlat    + (j+1)*dlat
         lon_v = lon_W - dlon/2. +  i   *dlon

         kc                = 0
         tau_x_scow_g(i,j) = 0.

         do i1=1,i_scow
         do j1=1,j_scow

            if (lat_scow  (   j1)*rad  .ge.lat_v-dlat/2. .and.
     >          lat_scow  (   j1)*rad  .le.lat_v+dlat/2. .and.
     >          lon_scow  (i1   )*rad  .ge.lon_v-dlon/2. .and.
     >          lon_scow  (i1   )*rad  .le.lon_v+dlon/2. .and.
     >          nint(tau_x_scow(i1,j1)).ne.nint(amiss_scow)   ) then

                kc                = kc + 1
                tau_x_scow_g(i,j) =
     >          tau_x_scow_g(i,j) + tau_x_scow(i1,j1)

            endif

         enddo
         enddo

         if (kc.ne.0) then
            tau_x_scow_g(i,j) = tau_x_scow_g(i,j) / float(kc)
         else
            tau_x_scow_g(i,j) = amiss_scow
         endif

c++
      enddo
      enddo
c++


c---- Meridional wind stress at u-carrier pts (including exterior pts)

c++
      do i=-1,idim+1
      do j= 0,jdim+1
c++

         lat_u = lat_S - dlat/2. + j*dlat
         lon_u = lon_W - dlon    + (i+1)*dlon

         kc                = 0
         tau_y_scow_g(i,j) = 0.

         do i1=1,i_scow
         do j1=1,j_scow

            if (lat_scow  (   j1)*rad  .ge.lat_u-dlat/2. .and.
     >          lat_scow  (   j1)*rad  .le.lat_u+dlat/2. .and.
     >          lon_scow  (i1   )*rad  .ge.lon_u-dlon/2. .and.
     >          lon_scow  (i1   )*rad  .le.lon_u+dlon/2. .and.
     >          nint(tau_y_scow(i1,j1)).ne.nint(amiss_scow)   ) then

                kc                = kc + 1
                tau_y_scow_g(i,j) =
     >          tau_y_scow_g(i,j) + tau_y_scow(i1,j1)

            endif

         enddo
         enddo

         if (kc.ne.0) then
            tau_y_scow_g(i,j) = tau_y_scow_g(i,j) / float(kc)
         else
            tau_y_scow_g(i,j) = amiss_scow
         endif

c++
      enddo
      enddo
c++


c---- End of test

c     *****
      endif
c     *****




c     ---------------------
c     Read sediment records 
c     ---------------------

c---- Test

c     **********************
      if (c4.eq.'reco') then
c     **********************


c---- Name of files: C. Waelbroeck (pers. com.)

      cfile(1) = 'na87-22_cold.txt'
      cfile(2) = 'ch69-k09_cold.txt'
      cfile(3) = 'su81-18_cold.txt'


c---- Start loop on data files

c++
      do if=1,n_rec
c++


c--   Open file

      if (if.le.3) then
        filn = cfile(if)
      endif

      open (10,file=filn,status='old')


c--   Read record information

      read(10,'(a50   )'   ) c_core
      read(10,'(a50   )'   ) c_cita
      read(10,'(a10,f10.5)') c_lati(1:10),c_lat(if)
      read(10,'(a11,f10.5)') c_long(1:11),c_lon(if)
      read(10,'(a50   )'   ) c_dept
      read(10,'(a10,i2)'   ) c_comm(1:10),i_jum

      do i=1,i_jum
         read(10,*)
      enddo


c--   Read record information (code) 

      read(10,'(a50)') c_code

      open     (99,file='dum')
      write    (99,*) c_code(09:10),' ',
     >                c_code(13:14),' ',
     >                c_code(26:27)
      backspace(99  )
      read     (99,*) i_jum,i_age,i_tem
      close    (99  )

      read(10,*)
      do i=1,i_jum
         read(10,*)
      enddo
      read(10,*)


c--   Print 

      if (if.eq.1) open (98,file='compil.r')

      write(98,'(a50   )'   ) c_core
      write(98,'(a50   )'   ) c_cita
      write(98,'(a10,f10.5)') c_lati(1:10),c_lat(if)
      write(98,'(a11,f10.5)') c_long(1:11),c_lon(if)
      write(98,'(a50   )'   ) c_dept
      write(98,*) ' ',c_code
      write(98,*)


c--   Read temperature record

      it = 0
1     it = it + 1
      read(10,*,err=2,end=2) tim(if,it),tem(if,it,1),tem_er(if,it,1),
     >                                  tem(if,it,2),tem_er(if,it,2)
      goto 1
2     itot_c (if) = it - 1
      close(10)


c---- End loop on data files

c++
      enddo
c++


c---- End of test

c     *****
      endif
c     *****




c     -----------------------------------
c     Read WOA13 annual mean temperatures
c     -----------------------------------

c---- Test

c     **********************
      if (c4.eq.'sstx') then
c     **********************


c---- Read WOA13 vertical levels (depths)

      filename = 'woa13_decav_t00mn01.csv'

      open  (10,file=filename,status='old')
      read  (10,*)
      read  (10,*)
      read  (10,*) (z_WOA(kz),kz=1,k_WOA_z)
      close (10)


c---- Read WOA13 annual mean temperatures 

c--
      do kz=1,1
c--

c        Filename

         if (kz.lt.10) then
            write(c3,200) kz    
200         format('00',i1)
         else if (kz.lt.100) then
            write(c3,201) kz 
201         format('0',i2)
         else
            write(c3,202) kz 
202         format(i3)
         endif

         filename = 'woa13_decav_t00mn01.dat.'//c3


c        Print

         if (mod(kz,10).eq.0      ) write(*,333) filename
         if (    kz    .eq.k_WOA_z) write(*,*)
333      format(' Read ',a100)


c        Read file

         open (10,file=filename,status='old')

         read(10,*)
         do k=1,k_WOA
            read(10,*) lat_WOA(k),lon_WOA(k),tem_WOA_z(k,kz)
         enddo

         close (10)

c--
      enddo
c--


c---- Compute average annual mean SST in model grid cells 

c++
      do i=0,idim+1 
      do j=0,jdim+1 
c++

         kc             = 0
         sst_WOA_g(i,j) = 0.

         do k=1,k_WOA

            if (lat_WOA  (k)*rad    .ge.lat(  j)  -dlat/2. .and.
     >          lat_WOA  (k)*rad    .le.lat(  j)  +dlat/2. .and.
     >          lon_WOA  (k)*rad    .ge.lon(i  )  -dlon/2. .and.
     >          lon_WOA  (k)*rad    .le.lon(i  )  +dlon/2. .and.
     >          nint(tem_WOA_z(k,1)).ne.nint(amiss_sstx)) then
                  kc             = kc             + 1
                  sst_WOA_g(i,j) = sst_WOA_g(i,j) + tem_WOA_z(k,1)
            endif

         enddo

         if (kc.ne.0) then
            sst_WOA_g(i,j) = sst_WOA_g(i,j) / float(kc)
         else
            sst_WOA_g(i,j) = amiss_sstx
         endif

c++
      enddo
      enddo
c++


c---- End of test

c     *****
      endif
c     *****




c     ------------------------------------------------
c     Read STD error of WOA13 annual mean temperatures 
c     ------------------------------------------------

c---- Test

c     **********************
      if (c4.eq.'sstx') then
c     **********************


c---- Read STD error of WOA13 annual mean temperatures 

c--
      do kz=1,1
c--

c        Filename

         if (kz.lt.10) then
            write(c3,200) kz    
         else if (kz.lt.100) then
            write(c3,201) kz 
         else
            write(c3,202) kz 
         endif

         filename = 'woa13_decav_t00se01.dat.'//c3


c        Print

         if (mod(kz,10).eq.0      ) write(*,333) filename
         if (    kz    .eq.k_WOA_z) write(*,*)


c        Read file

         open (10,file=filename,status='old')

         read(10,*)
         do k=1,k_WOA
            read(10,*) lat_WOA(k),lon_WOA(k),tem_WOA_z_se(k,kz)
         enddo

         close (10)

c--
      enddo
c--


c---- Compute average of STD error of annual mean SST in model grid cells 

c++
      do i=0,idim+1 
      do j=0,jdim+1 
c++

         kc                = 0
         sst_WOA_g_se(i,j) = 0.

         do k=1,k_WOA

            if (lat_WOA  (k)*rad       .ge.lat(  j)  -dlat/2. .and.
     >          lat_WOA  (k)*rad       .le.lat(  j)  +dlat/2. .and.
     >          lon_WOA  (k)*rad       .ge.lon(i  )  -dlon/2. .and.
     >          lon_WOA  (k)*rad       .le.lon(i  )  +dlon/2. .and.
     >          nint(tem_WOA_z_se(k,1)).ne.nint(amiss_sstx)) then
                  kc                = kc             + 1
                  sst_WOA_g_se(i,j) = 
     >            sst_WOA_g_se(i,j) + tem_WOA_z_se(k,1)**2
            endif

         enddo

         if (kc.ne.0) then
            sst_WOA_g_se(i,j) = sqrt(sst_WOA_g_se(i,j)) / float(kc)
         else
            sst_WOA_g_se(i,j) = amiss_sstx
         endif

c++
      enddo
      enddo
c++


c---- End of test

c     *****
      endif
c     *****




c     ---------------------------------
c     Read WOA13 annual mean salinities 
c     ---------------------------------

c---- Test

c     **********************
      if (c4.eq.'sssx') then
c     **********************


c---- Read WOA13 annual mean salinities

c     Filename

      filename = 'woa13_decav_s00mn01.dat.001'

c     Read file

      open (10,file=filename,status='old')

      read(10,*)
      do k=1,k_WOA
         read(10,*) lat_WOA_sss(k),
     >              lon_WOA_sss(k),
     >              sss_WOA    (k)
      enddo

      close (10)


c---- Compute average annual mean SSS in model grid cells 

c++
      do i=0,idim+1 
      do j=0,jdim+1 
c++

         kc             = 0
         sss_WOA_g(i,j) = 0.

         do k=1,k_WOA

            if (lat_WOA_sss (k)*rad .ge. lat(  j)  -dlat/2. .and.
     >          lat_WOA_sss (k)*rad .le. lat(  j)  +dlat/2. .and.
     >          lon_WOA_sss (k)*rad .ge. lon(i  )  -dlon/2. .and.
     >          lon_WOA_sss (k)*rad .le. lon(i  )  +dlon/2. .and.
     >          nint(sss_WOA(k))    .ne. nint(amiss_sssx)) then
                  kc             = kc             + 1
                  sss_WOA_g(i,j) = sss_WOA_g(i,j) + sss_WOA(k)
            endif

         enddo

         if (kc.ne.0) then
            sss_WOA_g(i,j) = sss_WOA_g(i,j) / float(kc)
         else
            sss_WOA_g(i,j) = amiss_sssx
         endif

c++
      enddo
      enddo
c++


c---- End of test

c     *****
      endif
c     *****




c     ---------------------------
c     Read WOA94 monthly mean MLD 
c     ---------------------------

c---- Test

c     **********************
      if (c4.eq.'mldx') then
c     **********************


c---- Loop on monthly files

c++
      do it=1,12
c++


c---- Open file

      if (it.lt.10) then
        write(filename,188) it
188     format('mld.pt.00',i1,'.001')
      else
        write(filename,189) it
189     format('mld.pt.0',i2,'.001')
      endif

      open (10,file=filename,status='old')


c---- Jump header in file 

      read(10,*)


c---- Read annual mean MLD 

      do k=1,k_mld
         read(10,*) lat_mld(k   ),
     >              lon_mld(k   ),
     >                  mld(k,it)
      enddo


c---- Close file

      close (10)


c---- End of loop on monthly files

c++
      enddo
c++ 


c---- Compute annual mean MLDs

      do k=1,k_mld

            kc       = 0
            mld(k,0) = 0.
         do it=1,12
            if (nint(mld(k,it)).ne.nint(amiss_mldx)) then
               kc       = kc       + 1
               mld(k,0) = mld(k,0) + mld(k,it)
            endif
         enddo

         if (kc.ne.0) then
            mld(k,0) = mld(k,0) / float(kc)
         endif

      enddo


c---- Average annual mean MLDs in model grid cells

c++
      do i=0,idim+1 
      do j=0,jdim+1 
c++

      kc             = 0
      mld_WOA_g(i,j) = 0.

      do k=1,k_mld

         if (lat_mld (k  ) *rad.ge.lat(  j)  -dlat/2. .and.
     >       lat_mld (k  ) *rad.le.lat(  j)  +dlat/2. .and.
     >       lon_mld (k  ) *rad.ge.lon(i  )  -dlon/2. .and.
     >       lon_mld (k  ) *rad.le.lon(i  )  +dlon/2. .and.
     >       nint(mld(k,0))    .ne.nint(amiss_mldx)        ) then

             kc             = kc + 1
             mld_WOA_g(i,j) =
     >       mld_WOA_g(i,j) + mld(k,0)

         endif

      enddo

      if (kc.ne.0) then
         mld_WOA_g(i,j) = mld_WOA_g(i,j) / float(kc)
      else
         mld_WOA_g(i,j) = amiss_mldx
      endif

c++
      enddo
      enddo
c++


c---- End of test

c     *****
      endif
c     *****




c     ---------------------
c     End of the subroutine
c     ---------------------

      return

      end

c     ******************************************************************
