c23456789012345678901234567890123456789012345678901234567890123456789012


      SUBROUTINE df_dxxx(nN)

c     ******************************************************************
c     This routine returns the matrix df/dx of partial derivatives
c
c     Called by:        fil_lkf	
c                       fil_ekf
c     Calls    :        none	
c
c     Written by       : OM  
c     Last modification: 7/2015
c     ******************************************************************

c     ------------
c     Declarations
c     ------------

c     '''''''''''''''''''''
      implicit none
      include 'commonvar.f'      
c     '''''''''''''''''''''

c---- Argument variables

      integer   nN


c---- Internal variables

      integer   i ,j ,
     >          n1,n2,n,n_c,iskip 

      real*8    df_dx_im1jm1,
     >          df_dx_im1j  ,
     >          df_dx_im1jp1,
     >          df_dx_ijp1  ,
     >          df_dx_ip1jp1,
     >          df_dx_ip1j  ,
     >          df_dx_ip1jm1,
     >          df_dx_ijm1  ,
     >          df_dx_ij

      real*8    uuim1j,uuij,ukij,ukim1j,
     >          vvijm1,vvij,vkij,vkijm1

      real*8    t1,t2,t2a,t2b,t3,t4,t5

      real*8    rds,cm,cp

      real*8    huij,huim1j,
     >          hvij,hvijm1

      real*8    duij_dc,duim1j_dc,
     >          dvij_dc,dvijm1_dc

      real*8    dhuij_dc,dhuim1j_dc,
     >          dhvij_dc,dhvijm1_dc


c---- FUNCTIONS 

      real*8      EExxxxx

      character*8 stringx




c     -------------
c     Preliminaries
c     -------------

c---- Initialize - number of equations 
c                - matrix df_dx 

      n1    = 0
      df_dx = 0.




c     ------------------------------------------
c     Equations for ML temperature: Interior pts
c     ------------------------------------------

c---- Start loop 

c++
      do i=1    ,idim
      do j=jS(i),jN(i)
c++


c---- Equation counter

      n1 = n1 + 1


c---- Geometric factors 

      rds = r_0 * (sin(lat(j)+dlat/2.)-
     >             sin(lat(j)-dlat/2.))

      cm  = cos(lat(j)-dlat/2.)
      cp  = cos(lat(j)+dlat/2.)


c---- MLDs

      huim1j = 0.5 * (hh(i-1,j)+hh(i  ,j))
      huij   = 0.5 * (hh(i  ,j)+hh(i+1,j))

      hvijm1 = 0.5 * (hh(i,j-1)+hh(i,j  ))
      hvij   = 0.5 * (hh(i,j  )+hh(i,j+1))


c---- Zonal velocity at (i-1,j) & (i,j)

c     Ekman + thermal + haline

      uuim1j = uu(i-1,j)
      uuij   = uu(i  ,j)

c     Ekman + haline

      ukim1j = uk(i-1,j)
      ukij   = uk(i  ,j)


c---- Meridional velocity at (i,j-1) & (i,j)

c     Ekman + thermal + haline

      vvijm1 = vv(i,j-1)
      vvij   = vv(i,j  ) 

c     Ekman + haline

      vkijm1 = vk(i,j-1)
      vkij   = vk(i,j  )


c---- df_dx: x = ML temperature

c--
      do n2=1,n_tt
c--

c     x = tt(i-1,j-1)

      t1 = dt/hh(i,j) * huim1j / dx(j)
      t1 =
     >t1 * (ti(i,j)-tt(i,j)) * ggu(j)
      t1 =
     >t1 * (hh(i-1,j)+hh(i,j))

      t2 = dt/hh(i,j) * hvijm1 * cm / rds 
      t2 =
     >t2 * (ti(i,j)-tt(i,j)) * ddv(j-1)
      t2 =
     >t2 * (hh(i,j-1)+hh(i,j))

      df_dx_im1jm1 = t1 
     >             + t2


c     x = tt(i-1,j)

      t1 = dt/dx(j) * 0.5 * (ukim1j+abs(ukim1j))

      t2 = -dt/hh(i,j) * (ti(i,j)-tt(i,j)) * hvij * cp / rds
      t2 = 
     >t2 * ddv(j) * (hh(i,j)+hh(i,j+1))

      t3 = dt/hh(i,j) * (ti(i,j)-tt(i,j)) * hvijm1 * cm / rds 
      t3 = 
     >t3 * ddv(j-1) * (hh(i,j-1)+hh(i,j))

      df_dx_im1j = t1 
     >           + t2 
     >           + t3  


c     x = tt(i-1,j+1)

      t1 = -dt/hh(i,j) * huim1j / dx(j) * (ti(i,j)-tt(i,j)) 
      t1 = 
     >t1 * ggu(j) * (hh(i-1,j)+hh(i,j))

      t2 = -dt/hh(i,j) * hvij * cp / rds * (ti(i,j)-tt(i,j))
      t2 =
     >t2 * ddv(j) * (hh(i,j)+hh(i,j+1))

      df_dx_im1jp1 = t1 
     >             + t2


c     x = tt(i,j+1)

      t1 = -dt/dy * 0.5 * (vkij-abs(vkij))

      t2 = dt/hh(i,j) * (ti(i,j)-tt(i,j)) * huij / dx(j)
      t2 =
     >t2 * ggu(j) * (hh(i,j)+hh(i+1,j))

      t3 = -dt/hh(i,j) * (ti(i,j)-tt(i,j))
      t3 =
     >t3 * huim1j / dx(j) * ggu(j) * (hh(i-1,j)+hh(i,j))

      df_dx_ijp1 = t1 
     >           + t2 
     >           + t3


c     x = tt(i+1,j+1)

      t1 = dt/hh(i,j) * (ti(i,j)-tt(i,j)) * huij / dx(j)
      t1 = 
     >t1 * ggu(j) * (hh(i,j)+hh(i+1,j))

      t2 = dt/hh(i,j) * (ti(i,j)-tt(i,j)) * hvij * cp / rds 
      t2 =
     >t2 * ddv(j) * (hh(i,j)+hh(i,j+1))
 
      df_dx_ip1jp1 = t1 
     >             + t2 


c     x = tt(i+1,j)

      t1 = -dt/dx(j) * 0.5 * (ukij-abs(ukij))

      t2 = dt/hh(i,j) * (ti(i,j)-tt(i,j)) 
      t2 = 
     >t2 * hvij * cp / rds * ddv(j) * (hh(i,j)+hh(i,j+1))

      t3 = -dt/hh(i,j) * (ti(i,j)-tt(i,j))
      t3 =
     >t3 * hvijm1 * cm / rds * ddv(j-1) * (hh(i,j-1)+hh(i,j))

      df_dx_ip1j = t1 
     >           + t2 
     >           + t3 


c     x = tt(i+1,j-1)

      t1 = -dt/hh(i,j) * huij / dx(j) * (ti(i,j)-tt(i,j))
      t1 = 
     >t1 * ggu(j) * (hh(i,j)+hh(i+1,j))

      t2 = -dt/hh(i,j) * hvijm1 * cm / rds * (ti(i,j)-tt(i,j))
      t2 = 
     >t2 * ddv(j-1) * (hh(i,j-1)+hh(i,j))

      df_dx_ip1jm1 = t1 
     >             + t2  


c     x = tt(i,j-1)

      t1 = dt/dy * 0.5 * (vkijm1+abs(vkijm1))

      t2 = -dt/hh(i,j) * (ti(i,j)-tt(i,j))
      t2 =
     >t2 * huij / dx(j) * ggu(j) * (hh(i,j)+hh(i+1,j))

      t3 = dt/hh(i,j) * (ti(i,j)-tt(i,j))
      t3 =
     >t3 * huim1j / dx(j) * ggu(j) * (hh(i-1,j)+hh(i,j))

      df_dx_ijm1 = t1 
     >           + t2 
     >           + t3  


c     xx = tt(i,j)

      t1 = 1.
   
      t2 = -dt/dx(j) * ( -0.5*(ukij  -abs(ukij  ))
     >                   +0.5*(ukim1j+abs(ukim1j)) ) 

      t3 = -dt/dy * ( -0.5*(vkij  -abs(vkij  ))
     >                +0.5*(vkijm1+abs(vkijm1)) )

      t4 = -dt/hh(i,j) * w_i(i,j)

      t5 = -dt/hh(i,j) * w_a 

      df_dx_ij = t1 + t2 + t3 + t4 +t5


c     Collect

      df_dx(n1,n2) = df_dx_im1jm1 * ia(i-1,j-1,n2) 
     >             + df_dx_im1j   * ia(i-1,j  ,n2)
     >             + df_dx_im1jp1 * ia(i-1,j+1,n2)
     >             + df_dx_ijp1   * ia(i  ,j+1,n2)
     >             + df_dx_ip1jp1 * ia(i+1,j+1,n2)
     >             + df_dx_ip1j   * ia(i+1,j  ,n2)
     >             + df_dx_ip1jm1 * ia(i+1,j-1,n2)  
     >             + df_dx_ijm1   * ia(i  ,j-1,n2)
     >             + df_dx_ij     * ia(i  ,j  ,n2)


c--
      enddo
c--


c---- df/dx: x = coefficients for apparent temperature

      n2 = n_tt
c--
      do n=1,ncoe
         n2           = n2 + 1
         df_dx(n1,n2) = dt * w_a/hh(i,j) * EExxxxx(n,i,j,'ta') 
      enddo
c--


c---- df/dx: x = coefficients for interior temperature

c--
      do n=1,ncoe
         n2           = n2 + 1
         df_dx(n1,n2) = dt * w_i(i,j)/hh(i,j) * EExxxxx(n,i,j,'ti')
      enddo
c--


c---- df/dx: x = coefficients for mixed layer depth

c--
      do n=1,ncoe
c--

c     Partial derivatives du(i  ,j  )/dc, where c = coe_h(k)
c                         dv(i  ,j  )/dc, where c =    -
c                         du(i-1,j  )/dc, where c =    - 
c                         dv(i  ,j-1)/dc, where c =    -

      duij_dc = ggu(j) * (tt(i  ,j+1)+
     >                    tt(i+1,j+1)-
     >                    tt(i  ,j-1)-
     >                    tt(i+1,j-1)) * (EExxxxx(n,i  ,j,'hh')+
     >                                    EExxxxx(n,i+1,j,'hh'))
      dvij_dc = ddv(j) * (tt(i+1,j  )+
     >                    tt(i+1,j+1)-
     >                    tt(i-1,j  )-
     >                    tt(i-1,j+1)) * (EExxxxx(n,i,j  ,'hh')+
     >                                    EExxxxx(n,i,j+1,'hh'))

      duim1j_dc = ggu(j  ) * (tt(i-1,j+1)+
     >                        tt(i  ,j+1)-
     >                        tt(i-1,j-1)-
     >                        tt(i  ,j-1)) * (EExxxxx(n,i-1,j,'hh')+
     >                                        EExxxxx(n,i  ,j,'hh'))
      dvijm1_dc = ddv(j-1) * (tt(i+1,j-1)+
     >                        tt(i+1,j  )-
     >                        tt(i-1,j-1)-
     >                        tt(i-1,j  )) * (EExxxxx(n,i,j-1,'hh')+
     >                                        EExxxxx(n,i,j  ,'hh'))


c     Partial derivatives [dh/dc]_u(i  ,j  ), where c = coe_h(k)
c                         [dh/dc]_v(i  ,j  ), where c =    - 
c                         [dh/dc]_u(i-1,j  ), where c =    - 
c                         [dh/dc]_v(i  ,j-1), where c =    - 

      dhuij_dc = 0.5 * (EExxxxx(n,i  ,j,'hh')+EExxxxx(n,i+1,j,'hh'))
      dhvij_dc = 0.5 * (EExxxxx(n,i,j  ,'hh')+EExxxxx(n,i,j+1,'hh'))

      dhuim1j_dc = 0.5*(EExxxxx(n,i-1,j,'hh')+EExxxxx(n,i  ,j,'hh'))
      dhvijm1_dc = 0.5*(EExxxxx(n,i,j-1,'hh')+EExxxxx(n,i,j  ,'hh'))


c     Contribution 1 to df/dx

      t1 = -dt/hh(i,j)**2 * EExxxxx(n,i,j,'hh')
      t1 =
     >t1 * w_i(i,j) * (ti(i,j)-tt(i,j))


c     Contribution 2 to df/dx

      t2a = dt / (hh(i,j)*dx(j)) 
      t2a = 
     >t2a * ( duij_dc  *huij       +
     >        uuij     *dhuij_dc   - 
     >        duim1j_dc*huim1j     -
     >        uuim1j   *dhuim1j_dc ) 
      t2a = 
     >t2a * (ti(i,j)-tt(i,j))

      t2b = dt / (hh(i,j)*rds)
      t2b =
     >t2b * ( dvij_dc  *hvij  *cp         +
     >        vvij     *cp    *dhvij_dc   -
     >        dvijm1_dc*hvijm1*cm         -
     >        vvijm1   *cm    *dhvijm1_dc ) 
      t2b =
     >t2b * (ti(i,j)-tt(i,j))

      t2 = t2a + t2b


c     Contribution 3 to df/dx

      t3 = -dt/hh(i,j)**2 
      t3 =
     >t3 * EExxxxx(n,i,j,'hh') * w_a * (ta(i,j)-tt(i,j))


c     Counter for state variables

      n2 = n2 + 1


c     df/dx

      df_dx(n1,n2) = t1 + t2 + t3



c--
      enddo
c--


c---- df/dx: x = coefficients for zonal velocity

c--
      do n=1,ncoe
c--

c     Contribution 1 to df/dx

      t1 = -dt/dx(j)
      t1 =
     >t1 * 0.5 * (1.-sign(1.,ukij)) * EExxxxx(n,i,j,'uk')
      t1 = 
     >t1 * (tt(i+1,j)-tt(i,j))


c     Contribution 2 to df/dx

      t2 = -dt/dx(j)
      t2 =
     >t2 * 0.5 * (1.+sign(1.,ukim1j)) * EExxxxx(n,i-1,j,'uk')
      t2 =
     >t2 * (tt(i,j)-tt(i-1,j))


c     Contribution 3 to df/dx

      t3 = dt/hh(i,j)
      t3 =
     >t3 * (huij  /dx(j)*EExxxxx(n,i  ,j,'uk')-
     >      huim1j/dx(j)*EExxxxx(n,i-1,j,'uk'))
      t3 =
     >t3 * (ti(i,j)-tt(i,j))


c     Counter for state variables

      n2 = n2 + 1


c     df/dx

      df_dx(n1,n2) = t1 + t2 + t3


c--
      enddo
c--


c---- df/dx: x = coefficients for meridional velocity

c--
      do n=1,ncoe
c--

c     Contribution 1 to df/dx

      t1 = -dt/dy
      t1 =
     >t1 * 0.5 * (1.-sign(1.,vkij)) * EExxxxx(n,i,j,'vk')
      t1 =
     >t1 * (tt(i,j+1)-tt(i,j))


c     Contribution 2 to df/dx

      t2 = -dt/dy
      t2 =
     >t2 * 0.5 * (1.+sign(1.,vkijm1)) * EExxxxx(n,i,j-1,'vk')
      t2 =
     >t2 * (tt(i,j)-tt(i,j-1))


c     Contribution 3 to df/dx

      t3 = dt/hh(i,j)
      t3 =
     >t3 * (hvij  *cp/rds*EExxxxx(n,i,j  ,'vk')-
     >      hvijm1*cm/rds*EExxxxx(n,i,j-1,'vk'))
      t3 =
     >t3 * (ti(i,j)-tt(i,j))


c     Counter for state variables

      n2 = n2 + 1


c     df/dx

      df_dx(n1,n2) = t1 + t2 + t3

c--
      enddo
c--


c---- Test

      if (n2.ne.nN) then
         write(*,*)
         write(*,*) 'STOP 1 in df_dxxx.f: n2.ne.nN'
         write(*,*)
         stop
      endif


c---- End of loop 

c++
      enddo
      enddo
c++




c     ----------------------------------------------
c     Equations for ML temperature: Southern bry pts
c     ----------------------------------------------

c---- Start loop 

c++
      do i=1,idim
c++


c---- Test

      j = jS(i)-1

      do n=1,n_cor
         if (i.eq.i_cor(n) .and. j.eq.j_cor(n)) goto 111
      enddo


c---- Equation counter

      n1 = n1 + 1


c---- df/dx: x = ML temperature 

      do n2=1,n_tt

         if (strx(n2).eq.stringx('tt',i,j)) then
           df_dx(n1,n2) = 1. - dt*w_a/hh(i,j)
         endif 

      enddo


c---- df/dx: x = coefficients for apparent temperature

      n2 = n_tt

      do n=1,ncoe
         n2           = n2 + 1
         df_dx(n1,n2) = dt * w_a/hh(i,j) * EExxxxx(n,i,j,'ta') 
      enddo


c---- df/dx: x = coefficients for ML depth

      do n  = 1,ncoe    ! Skip interior temperature
         n2 = n2 + 1
      enddo

      do n=1,ncoe
                  n2  = n2 + 1
         df_dx(n1,n2) = dt * w_a * (ta(i,j)-tt(i,j))
         df_dx(n1,n2) =
     >   df_dx(n1,n2) * (-1./hh(i,j)**2) * EExxxxx(n,i,j,'hh') 
      enddo

      do iskip= 1,2     ! Skip horizontal velocities
      do n    = 1,ncoe
         n2   = n2 + 1
      enddo
      enddo


c---- Test

      if (n2.ne.nN) then
         write(*,*)
         write(*,*) 'STOP 2 in df_dxxx.f: n2.ne.nN'
         write(*,*)
         stop
      endif


c---- End loop 

c++
111   continue
      enddo
c++




c     ----------------------------------------------
c     Equations for ML temperature: Northern bry pts
c     ----------------------------------------------
 
c---- Start loop

c++
      do i=1,idim
c++


c---- Test

      j = jN(i)+1

      do n=1,n_cor
         if (i.eq.i_cor(n) .and. j.eq.j_cor(n)) goto 112
      enddo


c---- Equation counter

      n1 = n1 + 1


c---- df/dx: x = ML temperature 

      do n2=1,n_tt

         if (strx(n2).eq.stringx('tt',i,j)) then
           df_dx(n1,n2) = 1. - dt*w_a/hh(i,j)
         endif 

      enddo


c---- df/dx: x = coefficients for apparent temperature

      n2 = n_tt

      do n=1,ncoe
         n2           = n2 + 1
         df_dx(n1,n2) = dt * w_a/hh(i,j) * EExxxxx(n,i,j,'ta') 
      enddo


c---- df/dx: x = coefficients for ML depth

      do n  = 1,ncoe    ! Skip interior temperature
         n2 = n2 + 1
      enddo

      do n=1,ncoe
                  n2  = n2 + 1
         df_dx(n1,n2) = dt * w_a * (ta(i,j)-tt(i,j))
         df_dx(n1,n2) =
     >   df_dx(n1,n2) * (-1./hh(i,j)**2) * EExxxxx(n,i,j,'hh')  
      enddo

      do iskip= 1,2     ! Skip horizontal velocities
      do n    = 1,ncoe
         n2   = n2 + 1
      enddo
      enddo


c---- Test

      if (n2.ne.nN) then
         write(*,*)
         write(*,*) 'STOP 3 in df_dxxx.f: n2.ne.nN'
         write(*,*)
         stop
      endif


c---- End loop

c++
112   continue
      enddo
c++




c     ---------------------------------------------
c     Equations for ML temperature: Western bry pts
c     ---------------------------------------------

c---- Start loop 

c++
      do j=1,jdim
c++


c---- Test

      i = iW(j)-1 

      do n=1,n_cor
         if (i.eq.i_cor(n) .and. j.eq.j_cor(n)) goto 113
      enddo


c---- Equation counter

      n1 = n1 + 1


c---- df/dx: x = ML temperature 

      do n2=1,n_tt

         if (strx(n2).eq.stringx('tt',i,j)) then
           df_dx(n1,n2) = 1. - dt*w_a/hh(i,j)
         endif 

      enddo


c---- df/dx: x = coefficients for apparent temperature

      n2 = n_tt

      do n=1,ncoe
         n2           = n2 + 1
         df_dx(n1,n2) = dt * w_a/hh(i,j) * EExxxxx(n,i,j,'ta') 
      enddo


c---- df/dx: x = coefficients for ML depth

      do n  = 1,ncoe    ! Skip interior temperature
         n2 = n2 + 1
      enddo

      do n=1,ncoe
                  n2  = n2 + 1
         df_dx(n1,n2) = dt * w_a *(ta(i,j)-tt(i,j))
         df_dx(n1,n2) =
     >   df_dx(n1,n2) * (-1./hh(i,j)**2) * EExxxxx(n,i,j,'hh') 
      enddo

      do iskip= 1,2     ! Skip horizontal velocities
      do n    = 1,ncoe
         n2   = n2 + 1
      enddo
      enddo


c---- Test

      if (n2.ne.nN) then
         write(*,*)
         write(*,*) 'STOP 4 in df_dxxx.f: n2.ne.nN'
         write(*,*)
         stop
      endif


c---- End of loop

c++
113   continue
      enddo
c++




c     ---------------------------------------------
c     Equations for ML temperature: Eastern bry pts 
c     ---------------------------------------------

c---- Start loop

c++
      do j=1,jdim
c++


c---- Test

      i = iE(j)+1 

      do n=1,n_cor
         if (i.eq.i_cor(n) .and. j.eq.j_cor(n)) goto 114
      enddo


c---- Equation counter

      n1 = n1 + 1


c---- df/dx: x = ML temperature 

      do n2=1,n_tt

         if (strx(n2).eq.stringx('tt',i,j)) then
           df_dx(n1,n2) = 1. - dt*w_a/hh(i,j)
         endif 

      enddo


c---- df/dx: x = coefficients for apparent temperature

      n2 = n_tt

      do n=1,ncoe
         n2           = n2 + 1
         df_dx(n1,n2) = dt * w_a/hh(i,j) * EExxxxx(n,i,j,'ta') 
      enddo


c---- df/dx: x = coefficients for ML depth

      do n  = 1,ncoe    ! Skip interior temperature
         n2 = n2 + 1
      enddo

      do n=1,ncoe
                  n2  = n2 + 1
         df_dx(n1,n2) = dt * w_a *(ta(i,j)-tt(i,j))
         df_dx(n1,n2) =
     >   df_dx(n1,n2) * (-1./hh(i,j)**2) * EExxxxx(n,i,j,'hh') 
      enddo

      do iskip= 1,2     ! Skip horizontal velocities
      do n    = 1,ncoe
         n2   = n2 + 1
      enddo
      enddo


c---- Test

      if (n2.ne.nN) then
         write(*,*)
         write(*,*) 'STOP 5 in df_dxxx.f: n2.ne.nN'
         write(*,*)
         stop
      endif


c---- End loop

c++
114   continue
      enddo
c++




c     ----------------------------------------
c     Equations for ML temperature: Corner pts
c     ----------------------------------------

c---- Start loop 

c++
      do n_c=1,n_cor 
c++


c---- Indices

      i = i_cor(n_c)
      j = j_cor(n_c)


c---- Equation counter

      n1 = n1 + 1


c---- df/dx: x = ML temperature 

      do n2=1,n_tt

         if (strx(n2).eq.stringx('tt',i,j)) then
           df_dx(n1,n2) = 1. - dt*w_a/hh(i,j)
         endif 

      enddo


c---- df/dx: x = coefficients for apparent temperature

      n2 = n_tt

      do n=1,ncoe
         n2           = n2 + 1
         df_dx(n1,n2) = dt * w_a/hh(i,j) * EExxxxx(n,i,j,'ta') 
      enddo


c---- df/dx: x = coefficients for ML depth

      do n  = 1,ncoe    ! Skip interior temperature
         n2 = n2 + 1
      enddo

      do n=1,ncoe
                  n2  = n2 + 1
         df_dx(n1,n2) = dt * w_a *(ta(i,j)-tt(i,j))
         df_dx(n1,n2) =
     >   df_dx(n1,n2) * (-1./hh(i,j)**2) * EExxxxx(n,i,j,'hh') 
      enddo

      do iskip= 1,2     ! Skip horizontal velocities
      do n    = 1,ncoe
         n2   = n2 + 1
      enddo
      enddo


c---- Test

      if (n2.ne.nN) then
         write(*,*)
         write(*,*) 'STOP 6 in df_dxxx.f: n2.ne.nN'
         write(*,*)
         stop
      endif


c---- End of loop

c++
      enddo
c++




c     --------------------------
c     Equations for coefficients
c     --------------------------

c---- Apparent temperature

      do n=1,ncoe
         n1           = n1   + 1
         n2           = n_tt + n
         df_dx(n1,n2) = 1.
      enddo


c---- Interior temperature

      do n=1,ncoe
         n1           = n1   + 1
         n2           = n_tt + ncoe*1 + n
         df_dx(n1,n2) = 1.
      enddo


c---- Mixed layer depth

      do n=1,ncoe
         n1           = n1   + 1
         n2           = n_tt + ncoe*2 + n
         df_dx(n1,n2) = 1.
      enddo


c---- Zonal velocity (Ekman + saline) 

      do n=1,ncoe
         n1           = n1   + 1
         n2           = n_tt + ncoe*3 + n
         df_dx(n1,n2) = 1.
      enddo


c---- Meridional velocity (Ekman + saline) 

      do n=1,ncoe
         n1           = n1   + 1
         n2           = n_tt + ncoe*4 + n
         df_dx(n1,n2) = 1.
      enddo


c---- Test

      if (n2.ne.nN) then
        write(*,*)
        write(*,*) 'STOP 7 in df_dxxx.f: n2.ne.nN'
        write(*,*)
        stop
      endif




c     ----
c     Test
c     ----     

      if (n1.ne.nN) then
        write(*,*)
        write(*,*) 'STOP in df_dxxx.f: n1.ne.nN'
        write(*,*)
        stop
      endif




c     ---------------------
c     End of the subroutine
c     ---------------------

      return

      end

c     ******************************************************************
