c23456789012345678901234567890123456789012345678901234567890123456789012


      SUBROUTINE selxxxx(n)

c     ******************************************************************
c     This routine returns the sediment SST record(s) for the inversion
c
c     Called by:      	main 
c     Calls    :        none	
c
c     Written by       : OM  
c     Last modification: 7/2015
c     ******************************************************************

c     ------------
c     Declarations
c     ------------

c     '''''''''''''''''''''
      implicit none
      include 'commonvar.f'      
c     '''''''''''''''''''''

c---- Argument variables

      integer   n


c---- Internal variables

      integer   it,k,kmax

      real*8    lon_dat,
     >          lat_dat

      character cfile0*50


c---- FUNCTION statement

      integer   indexxx




c     ----------------------------------------
c     Sediment SST record(s) for the inversion 
c     ----------------------------------------

c---- Records from CH69-K-09, NA87-22, SU81-18 (Waelbroeck, pers. comm.)

c++
      if (n.le.3) then
c++


c--      Longitude & latitude of sediment core 

         lon_dat = rad * c_lon(n)
         lat_dat = rad * c_lat(n) 


c--      Longitude & latitude indices of sediment core

c        ---------------------------------------------
         i_lon_dat(n) = indexxx(lon_dat,lat_dat,'lon')
         i_lat_dat(n) = indexxx(lon_dat,lat_dat,'lat') 
c        ---------------------------------------------


c--      Number of data in data file
c        Times in model yr
c        Annual mean SSTs 
c        Error in annual mean SST

         itot_dat(n) = itot_c(n)

         do it=1,itot_dat(n) 
            tim_dat   (n,it) =                -tim(n,it   ) * 1000
            tem_dat   (n,it) = (tem   (n,it,1)+tem(n,it,2)) / 2.
            tem_dat_er(n,it) =  tem_er(n,it,1)**2
     >                       +  tem_er(n,it,2)**2
            tem_dat_er(n,it) = sqrt(tem_dat_er(n,it)) / 2.
         enddo


c--      Filename 

         cfile0 = cfile(n)

         kmax=50
         do k=50,1,-1
            if (cfile0(k:k).eq.' ') kmax=k-1
            if (kmax       .eq.k  ) goto 555
         enddo
555      continue


c--      Write

         open (99,file=cfile0(1:kmax)//'.r')
         do it=itot_dat(n),1,-1
            write(99,'(3f11.3)') tim_dat   (n,it),
     >                           tem_dat   (n,it),
     >                           tem_dat_er(n,it)
         enddo
         close (99)

c++
      endif
c++




c     ---------------------
c     End of the subroutine
c     ---------------------

      return

      end

c     ******************************************************************
