c23456789012345678901234567890123456789012345678901234567890123456789012


      SUBROUTINE setting

c     ******************************************************************
c     This routine sets the - latitudes & longitudes 
c                           - grid indices 
c                           - parameters for df/dx 
c
c     Called by:      	main 
c     Calls    :        none	
c
c     Written by       : OM  
c     Last modification: 7/2015 
c     ******************************************************************

c     ------------
c     Declarations
c     ------------

c     '''''''''''''''''''''
      implicit none
      include 'commonvar.f'      
c     '''''''''''''''''''''

c---- Internal variables

      integer	i,j,n




c     --------------------------
c     Latitudes of T-carrier pts 
c     --------------------------

c---- Latitudinal spacing

      dlat = (lat_N-lat_S) / float(jdim)


c---- Latitudes of T-carrier pts

         lat(0) = lat_S    - dlat/2.
      do j=1,jdim+1
         lat(j) = lat(j-1) + dlat
      enddo


c---- Latitudinal spacing 

      dy = r_0 * dlat


c---- Print

      open (99,file='lat.r')
      do j=0,jdim+1
         write(99,*) j,lat(j)/rad
      enddo
      close (99)      

 


c     ---------------------------
c     Longitudes of T-carrier pts
c     ---------------------------

c---- Zonal spacing

      dlon = (lon_E-lon_W) / float(idim)


c---- Longitudes of T-carrier pts

         lon(0) = lon_W    - dlon/2.
      do i=1,idim+1
         lon(i) = lon(i-1) + dlon
      enddo


c---- Zonal spacings

      do j=0,jdim+1
         dx(j) = r_0 * dcos(lat(j)) * dlon
      enddo


c---- Print

      open (99,file='lon.r')
      do i=0,idim+1 
         write(99,*) i,lon(i)/rad
      enddo
      close (99)




c     -----------------------------------
c     Longitude indices for T-carrier pts
c    
c     Notes
c     -----
c     ipt(,) = -1 means an exterior pt
c     ipt(,) =  0 means an bry      pt
c     ipt(,) =  1 means an interior pt
c     -----------------------------------------

c---- Exterior pts (default) 

      ipt = -1


c---- Bry & interior pts

c++
      do j=0,jdim+1
c++

      if (j.eq.0) then 

         do i = 0,idim+1
            ipt(i,j) = 0 
         enddo

      else if (j.le.10) then

         iW(j) = 1 
         iE(j) = idim
         do i  = 0,idim+1
            if      (i.eq.iW(j)-1 .or . i.eq.iE(j)+1) then
                 ipt(i,j) = 0
            else if (i.ge.iW(j)   .and. i.le.iE(j)  ) then
                 ipt(i,j) = 1
            endif
         enddo


      else if (j.eq.11) then

         iW(j) = 6 
         iE(j) = idim
         do i  = 0,idim+1
            if (i.le.iW(j)-1 .or. i.eq.iE(j)+1) then
                 ipt(i,j) = 0
            else if (i.ge.iW(j)   .and. i.le.iE(j)  ) then
                 ipt(i,j) = 1
            endif
         enddo

      else if (j.eq.jdim) then

         iW(j) = 6 
         iE(j) = idim
         do i  = 0,idim+1
            if      (i.ge.iW(j)-1 .and. 
     >               i.le.iW(j)-1 .or . i.eq.iE(j)+1) then
                 ipt(i,j) = 0
            else if (i.ge.iW(j)   .and. i.le.iE(j)  ) then
                 ipt(i,j) = 1
            endif
         enddo

      else

         do i=0,idim+1
            if (i.ge.5) ipt(i,j) = 0 
         enddo

      endif

c++
      enddo
c++




c     ----------------------------------
c     Latitude indices for T-carrier pts
c     ----------------------------------

c++
      do i=1,idim
c++

      if (i.le.5) then
         jS(i) = 1
         jN(i) = jdim - 2    
      else 
         jS(i) = 1 
         jN(i) = jdim
      endif

c++
      enddo
c++ 




c     ----------------------------------------------
c     Indices for corner pts & adjacent interior pts
c     ----------------------------------------------

c---- Assign
c
c     Note
c     ----
c     Corner at (0,10) is removed because:
c     - its shallow MLD (7.69 m) leads to very rapid T error growth 
c     - it is also on land

      n        = 1 
      i_cor(n) = 0
      j_cor(n) = 0

      n        = n + 1
      i_cor(n) = idim+1 
      j_cor(n) = 0 

      n        = n + 1
      i_cor(n) = idim+1 
      j_cor(n) = jdim+1 

      n         = n + 1
      i_cor(n) =  5  
      j_cor(n) = jdim+1 

      n         = n + 1
      i_cor(n) =  5 
      j_cor(n) =  jdim-1

      n         = n + 1
      i_cor(n) =  0 
      j_cor(n) =  jdim-1


c---- Test

      if (n.ne.n_cor) then
         write(*,*)
         write(*,*) 'In setting: n.ne.n_cor'
         write(*,*)
         stop
      endif
 



c     --------------------
c     Parameters for df/dx
c     --------------------

c---- gamma^{u(i,j)} & gamma^{u(i-1,j)}

      do j=1,jdim

         ggu(j) = alpha*gg / (16*omega*r_0)      
         ggu(j) =
     >   ggu(j) / (cos(lat(j+1))-cos(lat(j-1)))

      enddo


c---- delta^{vv(i,j)} & delta^{vv(i,j-1)}

      do j=1-1,jdim

         ddv(j) = alpha*gg / (16*omega*r_0)      
         ddv(j) =
     >   ddv(j) / ( sin(2*(lat(j)+dlat/2.)) * dlon)

      enddo




c     ---------------------
c     End of the subroutine
c     ---------------------

      return

      end

c     ******************************************************************
