c23456789012345678901234567890123456789012345678901234567890123456789012


      SUBROUTINE smoothe

c     ******************************************************************
c     This routine applies the smoother of Bryson & Ho (1975, p. 394) 
c
c     Note
c     ----
c     The dynamical equations are linearized around a constant state
c
c     Called by:        main 
c     Calls    :        writing
c                       wr_xmxx
c                       wr_xfil
c                       zzRRHob
c                       choldc
c                       cholsl
c                       x_to_sv
c                       freezin
c
c     Written by       : OM  
c     Last modification: 7/2015
c     ******************************************************************

c     ------------
c     Declarations
c     ------------

c     '''''''''''''''''''''
      implicit none
      include 'commonvar.f'      
c     '''''''''''''''''''''

c---- Internal variables 

      integer   n1,n2,nN,ip,ip1,ip2,it

      real*8    lambda (ndim     ),
     >          LLambda(ndim,ndim),
     >          df_dx_T(ndim,ndim),
     >          R_1H   (pdim,ndim),
     >          H_TR_1 (ndim,pdim),
     >          SS     (ndim,ndim),
     >          I_PS   (ndim,ndim),
     >          x1     (ndim     ),
     >          x2     (ndim     ),
     >          d_x    (ndim     ),time

      real*8    df_dx_T_L_df_dx(ndim,ndim)

      real*8    pp(pdim),
     >          bb(pdim),RR_1(pdim,pdim)

      real*8    x_smo0(ndim)

      integer   nP




c     --------------
c     Compute df/dx'
c     --------------

c---- Dimension of state vector

      nN = n_tt + nvar*ncoe


c---- Transpose df/dx

      df_dx_T(1:nN,1:nN) = transpose(df_dx(1:nN,1:nN))
 



c     ---------
c     Time loop
c     ---------

c---- Terminal condition

      lambda (1:nN     ) = 0.
      LLambda(1:nN,1:nN) = 0.


c---- Write

      P_smo(1:nN,1:nN) = P_fil(1:nN,1:nN)

c     ----------------------------------------     
      call writing('tt_smo_xy'    ,50,itot_fs)
      call writing('ta_smo_xy'    ,51,itot_fs)
      call writing('uu_smo_xy'    ,53,itot_fs)
      call writing('vv_smo_xy'    ,54,itot_fs)
      call writing('hh_smo_xy'    ,55,itot_fs)
      call writing('er_smo_xy'    ,56,itot_fs)

      call writing('tt_smo_na8722',73,itot_fs)
      call writing('tt_smo_ch69k9',74,itot_fs)
      call writing('tt_smo_su8118',75,itot_fs)

      call writing('sf_smo_00'    ,84,itot_fs)
      call writing('sf_smo_09'    ,85,itot_fs)
      call writing('sf_smo_17'    ,86,itot_fs)

      call writing('us_xy'       ,93,itot_fs)    
      call writing('vs_xy'       ,94,itot_fs)        
      call writing('er_us_xy'    ,95,itot_fs)
      call writing('er_vs_xy'    ,96,itot_fs)
c     ----------------------------------------


c---- Reverse time loop

c     ********************
      do it=itot_fs-1,0,-1
c     ********************


c---- Time in kyr B.P. (<0) 

      time = it*dt/yr - time_start

c     Print

      write(*,98) time

98    format('Smoother: t =',f10.2,' yr')


c---- Read x(i+1,-) 
c          x(i+1,+) (not used) & P(i+1,+)

c     -----------------------------
      call wr_xmxx('readx',it+1,nN)
      call wr_xfil('readx',it+1,nN)
c     -----------------------------


c---- Get z(i+1) & H(i+1) & R(i+1)

c     ---------------------------
      call zzRRHob(time+dt/yr,nP)
c     ---------------------------

c     Print & convert data to perturbation data

      if (nP.gt.0) then

c        Print

         write(*,*)
         do ip=1,nP
            write(*,889) ip,' ',c_obs(ip),zz(ip),sqrt(RR(ip,ip))
         enddo
         write(*,*)
889      format(i4,a1,a4,2f11.4)

c        Convert to perturbation data

c        --------------------------------------------------------
         zz(1:nP) = zz(1:nP) - matmul(Hob(1:nP,1:nN),x_ref(1:nN))
c        --------------------------------------------------------

      endif


c---- Get R(i+1)^-1

      PP1(1:nP,1:nP) = RR(1:nP,1:nP)
c     --------------------------------------
      call choldc(PP1,nP,pdim,pp,'RR      ')
c     --------------------------------------

      do ip2=1,nP
         bb      = 0.
         bb(ip2) = 1.
c        ------------------------------------------
         call cholsl(PP1,nP,pdim,pp,bb,RR_1(1,ip2))
c        ------------------------------------------
      enddo


c---- Get S(i+1) = H(i+1)' R(i+1)^-1 H(i+1)

      R_1H  (1:nP,1:nN) = matmul   (RR_1  (1:nP,1:nP),Hob(1:nP,1:nN))
      H_TR_1(1:nN,1:nP) = transpose(R_1H  (1:nP,1:nN)               )
      SS    (1:nN,1:nN) = matmul   (H_TR_1(1:nN,1:nP),Hob(1:nP,1:nN))


c---- Get [I - P(i+1,+)S(i+1)]

      I_PS(1:nN,1:nN) = -matmul(P_fil(1:nN,1:nN),SS(1:nN,1:nN))
   
      do n1=1,nN
         I_PS(n1,n1) = 1. + I_PS(n1,n1)
      enddo


c---- Get z(i+1) - H(i+1)x(i+1,-)

      zz_Hx(1:nP) = zz(1:nP) - matmul(Hob(1:nP,1:nN),xm(1:nN))


c---- Get H(i+1)' R(i+1)^-1 [ z(i+1) - H(i+1)x(i+1,-) ]

      x1(1:nN) = matmul(H_TR_1(1:nN,1:nP),zz_Hx(1:nP))


c---- Get df/dx' l(i+1)

      x2(1:nN) = matmul(df_dx_T(1:nN,1:nN),lambda(1:nN))


c---- Get l(i) = [ I - P(i+1,+)S(i+1) ]' [ x2 - x1 ] 

      NN1   (1:nN,1:nN) = transpose(I_PS(1:nN,1:nN))
      d_x   (1:nN     ) = x2(1:nN) - x1(1:nN)
      lambda(1:nN     ) = matmul(NN1(1:nN,1:nN),d_x(1:nN))


c---- Get x(i,+) & P(i,+)

c     ---------------------------
      call wr_xfil('readx',it,nN)
c     ---------------------------


c---- Get x(i,N) = x(i,+) - P(i,+) df/dx' l(i)

      NN1  (1:nN,1:nN) = matmul(P_fil(1:nN,1:nN),df_dx_T(1:nN,1:nN))
      d_x  (1:nN     ) = matmul(NN1  (1:nN,1:nN),lambda (1:nN     ))
      x_smo(1:nN     ) = x_fil(1:nN) - d_x(1:nN)


c---- Get df/dx' L(i+1) df/dx

      NN1            (1:nN,1:nN) = matmul(df_dx_T(1:nN,1:nN),
     >                                    LLambda(1:nN,1:nN))
      df_dx_T_L_df_dx(1:nN,1:nN) = matmul(NN1    (1:nN,1:nN),
     >                                    df_dx  (1:nN,1:nN))


c---- Get   [ I - P(i+1,+)S(i+1)]' df/dx' L(i+1) df/dx 
c         x [ I - P(i+1,+)S(i+1)]

      NN1(1:nN,1:nN) = transpose(I_PS           (1:nN,1:nN))
      NN2(1:nN,1:nN) = matmul   (NN1            (1:nN,1:nN),
     >                           df_dx_T_L_df_dx(1:nN,1:nN))
      NN1(1:nN,1:nN) = matmul   (NN2            (1:nN,1:nN),
     >                           I_PS           (1:nN,1:nN))


c---- Get S(i+1) [ I - P(i+1,+)S(i+1) ]

      NN2(1:nN,1:nN) = matmul(SS(1:nN,1:nN),I_PS(1:nN,1:nN))


c---- Get L(i) =        [ I - P(i+1,+)S(i+1)]' df/dx' L(i+1) df/dx
c              x        [ I - P(i+1,+)S(i+1)]
c              + S(i+1) [ I - P(i+1,+)S(i+1) ]

      LLambda(1:nN,1:nN) = NN1(1:nN,1:nN) + NN2(1:nN,1:nN)


c---- Get df/dx' L(i) df/dx

      NN1            (1:nN,1:nN) = matmul(df_dx_T(1:nN,1:nN),
     >                                    LLambda(1:nN,1:nN))
      df_dx_T_L_df_dx(1:nN,1:nN) = matmul(NN1    (1:nN,1:nN),
     >                                    df_dx  (1:nN,1:nN))


c---- Get P(i,+) df/dx' L(i) df/dx P(i,+)

      NN1(1:nN,1:nN) = matmul(P_fil          (1:nN,1:nN),
     >                        df_dx_T_L_df_dx(1:nN,1:nN))
      NN2(1:nN,1:nN) = matmul(NN1            (1:nN,1:nN),
     >                        P_fil          (1:nN,1:nN)) 


c---- Get P(i,N) = P(i,+) - P(i,+) df/dx' L(i) df/dx P(i,+)

      P_smo(1:nN,1:nN) = P_fil(1:nN,1:nN) - NN2(1:nN,1:nN)


c---- Get field of - apparent temperature 
c                  - interior temperature 
c                  - zonal      Ekman velocity
c                  - meridional Ekman velocity

      x_smo0 = x_ref + x_smo

c     -----------------------------
      call x_to_sv(x_smo0,P_smo,nN)
c     -----------------------------

c     Test for sub-freezing T

c     ------------
      call freezin
c     ------------


c---- Write: Every 100 yr  

      if (mod(it,1000).eq.0) then

c        -------------------------------
         call writing('tt_smo_xy',50,it)
         call writing('ta_smo_xy',51,it)
         call writing('uu_smo_xy',53,it)
         call writing('vv_smo_xy',54,it)
         call writing('hh_smo_xy',55,it)
         call writing('er_smo_xy',56,it)

         call writing('us_xy'    ,93,it)
         call writing('vs_xy'    ,94,it)
         call writing('er_us_xy' ,95,it)
         call writing('er_vs_xy' ,96,it)
c        -------------------------------

      endif


c---- Write: Every yr 

      if (mod(it,10).eq.0) then

c        -----------------------------------
         call writing('tt_smo_na8722',73,it)    
         call writing('tt_smo_ch69k9',74,it)           
         call writing('tt_smo_su8118',75,it)   
c        -----------------------------------

      endif


c---- Write: Every yr for which data is available

      if (nP.gt.0) then

c        -------------------------------
         call writing('res_smo'  ,80,it)          

         call writing('tt_smo_xy',50,it)
         call writing('ta_smo_xy',51,it)
         call writing('uu_smo_xy',53,it)
         call writing('vv_smo_xy',54,it)
         call writing('hh_smo_xy',55,it)
         call writing('er_smo_xy',56,it)
 
         call writing('sf_smo_00',84,it)         
         call writing('sf_smo_09',85,it)        
         call writing('sf_smo_17',86,it)      
c        -------------------------------

      endif


c---- End of reverse time loop

c     *****
      enddo
c     *****




c     ---------------------
c     End of the subroutine
c     ---------------------

      return

      end

c     ******************************************************************
