c23456789012345678901234567890123456789012345678901234567890123456789012


      SUBROUTINE sv_to_x(xx,nN)

c     ******************************************************************
c     This routine constructs the state vector from the state variables
c
c     Called by:        fil_lkf 
c     Calls    :        none	
c
c     Written by       : OM  
c     Last modification: 7/2015
c     ******************************************************************

c     ------------
c     Declarations
c     ------------

c     '''''''''''''''''''''
      implicit none
      include 'commonvar.f'      
c     '''''''''''''''''''''

c---- Argument variables

      integer   nN
 
      real*8    xx(nN)
 

c---- Internal variables 

      integer   i,j,n,n2




c     --------------
c     ML temperature
c     --------------

c---- Initialize dimension of state vector

      n2 = 0


c---- Interior pts

      do i=1    ,idim
      do j=jS(i),jN(i) 
    
         n2     = n2 + 1
         xx(n2) = tt(i,j)

      enddo
      enddo


c---- Southern bry (excluding corners)

      do i=1,idim

         do n=1,n_cor
            if (i      .eq.i_cor(n) .and.
     >          jS(i)-1.eq.j_cor(n)) goto 101 
         enddo 

         n2     = n2 + 1
         xx(n2) = tt(i,jS(i)-1)
101      continue

      enddo


c---- Northern bry (excluding corners)

      do i=1,idim

         do n=1,n_cor
            if (i      .eq.i_cor(n) .and.
     >          jN(i)+1.eq.j_cor(n)) goto 102
         enddo

         n2     = n2 + 1
         xx(n2) = tt(i,jN(i)+1)
102      continue

      enddo


c---- Western bry (excluding corners)

      do j=1,jdim

         do n=1,n_cor
            if (iW(j)-1.eq.i_cor(n) .and.
     >          j      .eq.j_cor(n)) goto 103
         enddo

         n2     = n2 + 1
         xx(n2) = tt(iW(j)-1,j)
103      continue

      enddo


c---- Eastern bry (excluding corners)

      do j=1,jdim

         do n=1,n_cor
            if (iE(j)+1.eq.i_cor(n) .and.
     >          j      .eq.j_cor(n)) goto 104
         enddo

         n2     = n2 + 1
         xx(n2) = tt(iE(j)+1,j)
104      continue

      enddo


c---- Corners

      do n=1,n_cor 

         n2     = n2 + 1
         xx(n2) = tt(i_cor(n),j_cor(n))

      enddo




c     ------------
c     Coefficients
c     ------------

c---- Apparent temperature

      do n=1,ncoe
         n2     = n2 + 1 
         xx(n2) = coe_ta(n)         
      enddo


c---- Interior temperature

      do n=1,ncoe
         n2     = n2 + 1
         xx(n2) = coe_ti(n)
      enddo


c---- Mixed layer depth

      do n=1,ncoe
         n2     = n2 + 1
         xx(n2) = coe_hh(n)
      enddo


c---- Zonal velocity (Ekman + haline) 

      do n=1,ncoe
         n2     = n2 + 1
         xx(n2) = coe_uk(n)
      enddo


c---- Meridional velocity (Ekman + haline) 

      do n=1,ncoe
         n2     = n2 + 1
         xx(n2) = coe_vk(n)
      enddo




c     ----
c     Test 
c     ----

      if (n2.ne.nN) then
        write(*,*)
        write(*,*) 'STOP in sv_to_x.f: n2.ne.nN'
        write(*,*)
        stop
      endif




c     ---------------------
c     End of the subroutine
c     ---------------------

      return

      end

c     ******************************************************************
