c23456789012345678901234567890123456789012345678901234567890123456789012


      REAL*8 FUNCTION uuxxxxx(i,j,i_E,i_T,i_S) 

c     ******************************************************************
c     This routine returns a zonal velocity 
c
c     Called by:        mod_sta
c                       writing
c                       x_to_sv
c                       zzRRHob
c     Calls    :        none 
c
c     Written by       : OM  
c     Last modification: 7/2015
c     ******************************************************************

c     ------------
c     Declarations
c     ------------

c     '''''''''''''''''''''
      implicit none
      include 'commonvar.f'
c     '''''''''''''''''''''

c---- Argument variables

      integer   i,i0,j

      integer   i_E,
     >          i_T,
     >          i_S


c---- Local variables

      real*8    uu_E,
     >          uu_T,
     >          uu_S

      real*8    f0,h0,tau_y0




c     --------------------
c     Zonal Ekman velocity 
c     --------------------

c---- Mixed layer depth at u-carrier pt

      h0 = 0.5 * (hh(i,j)+hh(i+1,j))


c---- Coriolis parameter at u-carrier pt

      f0 = 2. * omega * sin(lat(j)) 


c---- Meridional wind stress at u-carrier pt

      tau_y0 = tau_y_scow_g(i,j)


c---- Zonal Ekman velocity at u-carrier pt

      uu_E = tau_y0 / (f0*h0*rho) 




c     --------------------------
c     Zonal geostrophic velocity 
c     --------------------------

c---- Test

      if (ipt(i  ,j+1).eq.-1 .or.
     >    ipt(i+1,j+1).eq.-1 .or.
     >    ipt(i  ,j-1).eq.-1 .or.
     >    ipt(i+1,j-1).eq.-1) then
          write(*,*)
          write(*,*) 'STOP in uuxxxxx.f: More coding is needed'
          write(*,*)
          stop 
       endif 


c---- Zonal geostrophic velocity: Thermal contribution 

      uu_T = alpha * ( 0.5*(tt(i,j+1)+tt(i+1,j+1))-
     >                 0.5*(tt(i,j-1)+tt(i+1,j-1)) )
      uu_T =
     >uu_T / (cos(lat(j+1))-cos(lat(j-1)))
      uu_T =
     >uu_T * gg*h0 / (4*r_0*omega) 


c---- Zonal geostrophic velocity: Haline contribution

      uu_S = -beta  * ( 0.5*(s0(i,j+1)+s0(i+1,j+1))-
     >                  0.5*(s0(i,j-1)+s0(i+1,j-1)) ) 
      uu_S =
     >uu_S / (cos(lat(j+1))-cos(lat(j-1)))
      uu_S = 
     >uu_S * gg*h0 / (4*r_0*omega) 




c     --------------
c     Zonal velocity
c     --------------

      uuxxxxx = i_E * uu_E
     >        + i_T * uu_T
     >        + i_S * uu_S




c     -------------------
c     End of the function 
c     -------------------

      return

      end

c     ******************************************************************
