c23456789012345678901234567890123456789012345678901234567890123456789012


      REAL*8 FUNCTION vvxxxxx(i,j,i_E,i_T,i_S)

c     ******************************************************************
c     This routine returns a meridional Ekman velocity 
c
c     Called by:        mod_sta
c                       writing
c                       x_to_sv
c                       zzRRHob
c     Calls    :        none 
c
c     Written by       : OM  
c     Last modification: 7/2015
c     ******************************************************************

c     ------------
c     Declarations
c     ------------

c     '''''''''''''''''''''
      implicit none
      include 'commonvar.f'
c     '''''''''''''''''''''

c---- Argument variables

      integer   i,j

      integer   i_E,
     >          i_T,
     >          i_S


c---- Local variables

      real*8    vv_E,
     >          vv_T,
     >          vv_S

      real*8    f0,h0,tau_x0




c     -------------------------
c     Meridional Ekman velocity
c     -------------------------

c---- Mixed layer depth at v-carrier pt

      h0 = 0.5 * (hh(i,j)+hh(i,j+1))


c---- Coriolis parameter at v-varrier pt 

      f0 = 2. * omega * sin(lat(j)+dlat/2.) 


c---- Zonal wind stress at v-carrier pt

      tau_x0 = tau_x_scow_g(i,j)


c---- Meridional Ekman velocity at v-carrier pt 

      vv_E = -tau_x0 / (f0*h0*rho) 




c     -------------------------------
c     Meridional geostrophic velocity
c     -------------------------------

c---- Test

      if (ipt(i+1,j  ).eq.-1 .or.
     >    ipt(i+1,j+1).eq.-1 .or.
     >    ipt(i-1,j  ).eq.-1 .or.
     >    ipt(i-1,j+1).eq.-1) then 
          write(*,*)
          write(*,*) 'STOP in vvxxxxx.f: More coding is needed'
          write(*,*)
          stop
       endif


c---- Meridional geostrophic velocity: Thermal contribution 

      vv_T = alpha * ( 0.5*(tt(i+1,j)+tt(i+1,j+1))-
     >                 0.5*(tt(i-1,j)+tt(i-1,j+1)) )
      vv_T =
     >vv_T / ( cos(lat(j)+dlat/2.)*
     >         sin(lat(j)+dlat/2.)* 2*dlon )
      vv_T =
     >vv_T * gg*h0 / (4*r_0*omega)


c---- Meridional geostrophic velocity: Haline contribution

      vv_S = -beta * ( 0.5*(s0(i+1,j)+s0(i+1,j+1))-
     >                 0.5*(s0(i-1,j)+s0(i-1,j+1)) )
      vv_S =
     >vv_S / ( cos(lat(j)+dlat/2.)*
     >         sin(lat(j)+dlat/2.)* 2*dlon )
      vv_S =
     >vv_S * gg*h0 / (4*r_0*omega)




c     -------------------
c     Meridional velocity
c     -------------------

      vvxxxxx = i_E * vv_E
     >        + i_T * vv_T
     >        + i_S * vv_S




c     -------------------
c     End of the function 
c     -------------------

      return

      end

c     ******************************************************************
