c23456789012345678901234567890123456789012345678901234567890123456789012


      SUBROUTINE w_ixxxx

c     ******************************************************************
c     This routine returns the vertical interior velocities w_i(,) 
c
c     Called by:        fil_lkf
c                       fil_ekf
c                       w_ixxxx	
c     Calls    :        none	
c
c     Written by       : OM  
c     Last modification: 7/2015
c     ******************************************************************

c     ------------
c     Declarations
c     ------------

c     '''''''''''''''''''''
      implicit none
      include 'commonvar.f'      
c     '''''''''''''''''''''

c---- Internal variables

      integer   i,j,n

      real*8    uh_w,uh_e,
     >          vh_s,vh_n,dy0 




c     ----------------------------
c     Vertical interior velocities
c     ----------------------------

c++
      do i=1    ,idim
      do j=jS(i),jN(i)
c++

         uh_e = uu(i  ,j) * 0.5 * (hh(i  ,j)+hh(i+1,j))
         uh_w = uu(i-1,j) * 0.5 * (hh(i-1,j)+hh(i  ,j))
c--
         vh_n = vv(i,j  ) * cos(lat(j)+dlat/2.) 
         vh_n =
     >   vh_n * 0.5 * (hh(i,j  )+hh(i,j+1))

         vh_s = vv(i,j-1) * cos(lat(j)-dlat/2.)
         vh_s =
     >   vh_s * 0.5 * (hh(i,j-1)+hh(i,j  ))
c--
         dy0  = r_0 * (sin(lat(j)+dlat/2.)-
     >                 sin(lat(j)-dlat/2.))
c--
         w_i(i,j) = (uh_e-uh_w)/dx(j)
         w_i(i,j) =
     >   w_i(i,j) + (vh_n-vh_s)/dy0 


c++
      enddo
      enddo
c++
  



c     ---------------------
c     End of the subroutine 
c     ---------------------

      return

      end

c     ******************************************************************
 
