c23456789012345678901234567890123456789012345678901234567890123456789012


      SUBROUTINE writing(c14,ifile,it)

c     ******************************************************************
c     This routine writes in output files 
c
c     Called by:     	mod_sta
c                       fil_lkf
c                       fil_ekf 
c                       smoothe	
c     Calls    :        none


c     Written by       : OM 
c     Last modification: 8/2015 
c     ******************************************************************

c     ------------
c     Declarations
c     ------------

c     '''''''''''''''''''''
      implicit none
      include 'commonvar.f'      
c     '''''''''''''''''''''

c---- Argument variables

      character	c14*14

      integer	ifile,it


c---- Internal variables 

      integer	i,j,j1,j2,n,n1,n2,ip,i_c

      real*8    ta_p(0:idim+1,0:jdim+1),
     >          uu_p(0:idim+1,0:jdim+1),
     >          vv_p(0:idim+1,0:jdim+1),
     >          hh_p(0:idim+1,0:jdim+1)

      real*8     fac
      parameter (fac=100.)      

      real*8    zm(pdim)

      real*8    t1,t2,e1,e2,phi1,phi2,phi10,er_phi10

      real*8    dphi10_dt1,
     >          dphi10_dt2,cv

      character c8*8,c50*50

      integer   nP
      common/nP/nP


c---- FUNCTION statement

      real*8    EExxxxx,
     >          uuxxxxx,
     >          vvxxxxx

      character stringx*8




c     -----------------------------------
c     Horizontal field: ML zonal velocity 
c     -----------------------------------

c++
      if (c14(1:9).eq.'uu_sim_xy' .or.
     >    c14(1:9).eq.'uu_fil_xy' .or.
     >    c14(1:9).eq.'uu_smo_xy') then
c++

        if (idim+1.lt.10) then
          write(c8,102) idim+1
102       format('(0',i1,'f8.3)')
        else if (idim+1.lt.100) then
          write(c8,103) idim+1
103       format('(',i2,'f8.3)')
        else
          write(*,*)
          write(*,*) 'STOP in writing.f: More coding is needed'
          write(*,*)
          stop
        endif

        uu_p = amiss_uvht / fac
        do j = 1      ,jdim
        do i = iW(j)-1,iE(j)
           uu_p(i,j) = uu(i,j) 
        enddo
        enddo
c--
        if (c14(4:6).eq.'sim') write(ifile,99) it*dt/yr
        if (c14(4:6).eq.'fil') write(ifile,99) it*dt/yr-time_start
        if (c14(4:6).eq.'smo') write(ifile,99) it*dt/yr-time_start

        do j=jdim,1,-1
           write(ifile,c8) (uu_p(i,j)*fac,i=0,idim)      
        enddo
        write(ifile,*)
      
c++
      endif
c++




c     ----------------------------------------
c     Horizontal field: ML meridional velocity 
c     ----------------------------------------

c++
      if (c14(1:9).eq.'vv_sim_xy' .or.
     >    c14(1:9).eq.'vv_fil_xy' .or.
     >    c14(1:9).eq.'vv_smo_xy') then
c++

        if (idim.lt.10) then
          write(c8,104) idim
104       format('(0',i1,'f8.3)')
        else if (idim.lt.100) then
          write(c8,105) idim
105       format('(',i2,'f8.3)')
        else
          write(*,*)
          write(*,*) 'STOP in writing.f: More coding is needed'
          write(*,*)
          stop
        endif

        vv_p = amiss_uvht / fac
        do i = 1      ,idim
        do j = jS(i)-1,jN(i)
           vv_p(i,j) = vv(i,j)
        enddo
        enddo

c--
        if (c14(4:6).eq.'sim') write(ifile,99) it*dt/yr
        if (c14(4:6).eq.'fil') write(ifile,99) it*dt/yr-time_start
        if (c14(4:6).eq.'smo') write(ifile,99) it*dt/yr-time_start

        do j=jdim,0,-1
           write(ifile,c8) (vv_p(i,j)*fac,i=1,idim) 
        enddo
        write(ifile,*)

c++
      endif
c++




c     -------------------------------------------
c     Horizontal field: ML zonal velocity u*(x,y)
c     -------------------------------------------

c++
      if (c14(1:5).eq.'us_xy') then
c++

        if (idim+1.lt.10) then
          write(c8,102) idim+1
        else if (idim+1.lt.100) then
          write(c8,103) idim+1
        else
          write(*,*)
          write(*,*) 'STOP in writing.f: More coding is needed'
          write(*,*)
          stop
        endif

        do j = 1      ,jdim
        do i = iW(j)-1,iE(j)
           uu_p(i,j) = 0. 
           do n=1,ncoe
              uu_p(i,j) = 
     >        uu_p(i,j) + coe_uk(n)*EExxxxx(n,i,j,'uk') 
           enddo
        enddo
        enddo

        write(ifile,99) it*dt/yr-time_start
        do j=jdim,1,-1
           write(ifile,c8) (uu_p(i,j)*fac,i=0,idim)      
        enddo
        write(ifile,*)
      
c++
      endif
c++




c     ------------------------------------------------
c     Horizontal field: ML meridional velocity v*(x,y)
c     ------------------------------------------------

c++
      if (c14(1:5).eq.'vs_xy') then
c++

        if (idim.lt.10) then
          write(c8,104) idim
        else if (idim.lt.100) then
          write(c8,105) idim
        else
          write(*,*)
          write(*,*) 'STOP in writing.f: More coding is needed'
          write(*,*)
          stop
        endif

        do i=1      ,idim
        do j=jS(i)-1,jN(i)
           vv_p(i,j) = 0. 
           do n=1,ncoe
              vv_p(i,j) =
     >        vv_p(i,j) + coe_vk(n)*EExxxxx(n,i,j,'vk')
           enddo 
        enddo
        enddo

        write(ifile,99) it*dt/yr-time_start
        do j=jdim,0,-1
           write(ifile,c8) (vv_p(i,j)*fac,i=1,idim) 
        enddo
        write(ifile,*)

c++
      endif
c++




c     ----------------------------------------------------
c     Horizontal field: Error in ML zonal velocity u*(x,y)
c     ----------------------------------------------------

c++
      if (c14(1:8).eq.'er_us_xy') then
c++

        if (idim+1.lt.10) then
          write(c8,102) idim+1
        else if (idim+1.lt.100) then
          write(c8,103) idim+1
        else
          write(*,*)
          write(*,*) 'STOP in writing.f: More coding is needed'
          write(*,*)
          stop
        endif

        do j = 1      ,jdim
        do i = iW(j)-1,iE(j)
           uu_p(i,j) = 0. 
           do n1=1,ncoe
           do n2=1,ncoe
              uu_p(i,j) =
     >        uu_p(i,j) + EExxxxx(n1,i,j,'uk')*
     >                    EExxxxx(n2,i,j,'uk')*pp_coe_uk(n1,n2)
           enddo
           enddo
           uu_p(i,j) = sqrt(uu_p(i,j))

        enddo
        enddo

        write(ifile,99) it*dt/yr-time_start
        do j=jdim,1,-1
           write(ifile,c8) (uu_p(i,j)*fac,i=0,idim)      
        enddo
        write(ifile,*)
      
c++
      endif
c++




c     ---------------------------------------------------------
c     Horizontal field: Error in ML meridional velocity v*(x,y)
c     ---------------------------------------------------------

c++
      if (c14(1:8).eq.'er_vs_xy') then
c++

        if (idim.lt.10) then
          write(c8,104) idim
        else if (idim.lt.100) then
          write(c8,105) idim
        else
          write(*,*)
          write(*,*) 'STOP in writing.f: More coding is needed'
          write(*,*)
          stop
        endif

        do i=1      ,idim
        do j=jS(i)-1,jN(i)
           vv_p(i,j) = 0. 
           do n1=1,ncoe
           do n2=1,ncoe
              vv_p(i,j) =
     >        vv_p(i,j) + EExxxxx(n1,i,j,'vk')*
     >                    EExxxxx(n2,i,j,'vk')*pp_coe_vk(n1,n2)
           enddo
           enddo
           vv_p(i,j) = sqrt(vv_p(i,j))

        enddo
        enddo

        write(ifile,99) it*dt/yr-time_start
        do j=jdim,0,-1
           write(ifile,c8) (vv_p(i,j)*fac,i=1,idim) 
        enddo
        write(ifile,*)

c++
      endif
c++




c     --------------------------
c     Horizontal field: ML depth
c     --------------------------

c++
      if (c14(1:9).eq.'hh_sim_xy' .or.
     >    c14(1:9).eq.'hh_fil_xy' .or.
     >    c14(1:9).eq.'hh_smo_xy') then
c++

        if (idim+2.lt.10) then
          write(c8,100) idim+2
        else if (idim+2.lt.100) then
          write(c8,101) idim+2
        else
          write(*,*)
          write(*,*) 'STOP in writing.f: More coding is needed'
          write(*,*)
          stop
        endif
c--
        hh_p = amiss_uvht 

        do i=0,idim+1
        do j=0,jdim+1
           if (ipt(i,j).ge.0) hh_p(i,j) = hh(i,j)
        enddo
        enddo

c--
       if (c14(4:6).eq.'sim') write(ifile,99) it*dt/yr
       if (c14(4:6).eq.'fil') write(ifile,99) it*dt/yr-time_start
       if (c14(4:6).eq.'smo') write(ifile,99) it*dt/yr-time_start

       do j=jdim+1,0,-1
          write(ifile,c8) (hh_p(i,j),i=0,idim+1)
       enddo
       write(ifile,*)

c++
      endif
c++




c     --------------------------------
c     Horizontal field: ML temperature 
c     --------------------------------

c++
      if (c14(1:9).eq.'tt_sim_xy' .or.
     >    c14(1:9).eq.'tt_fil_xy' .or.
     >    c14(1:9).eq.'tt_smo_xy') then
c++

        if (idim+2.lt.10) then
          write(c8,100) idim+2
100       format('(0',i1,'F8.2)')
        else if (idim+2.lt.100) then
          write(c8,101) idim+2
101       format('(',i2,'F8.2)')
        else
          write(*,*)
          write(*,*) 'STOP in writing.f: More coding is needed'
          write(*,*)
          stop
        endif
c--
        if (c14(4:6).eq.'sim') write(ifile,99) it*dt/yr
        if (c14(4:6).eq.'fil') write(ifile,99) it*dt/yr-time_start
        if (c14(4:6).eq.'smo') write(ifile,99) it*dt/yr-time_start
 
        do j=jdim+1,0,-1
           write(ifile,c8) (tt(i,j),i=0,idim+1) 
        enddo
        write(ifile,*)

c++
      endif
c++




c     -----------------------------
c     Horizontal field: ML salinity 
c     -----------------------------

c++
      if (c14(1:9).eq.'s0_sim_xy') then
c++

        if (idim+2.lt.10) then
          write(c8,143) idim+2
143       format('(0',i1,'F8.3)')
        else if (idim+2.lt.100) then
          write(c8,144) idim+2
144       format('(',i2,'F8.3)')
        else
          write(*,*)
          write(*,*) 'STOP in writing.f: More coding is needed'
          write(*,*)
          stop
        endif
c--
        write(ifile,99) it*dt/yr
 
        do j=jdim+1,0,-1
           write(ifile,c8) (s0(i,j),i=0,idim+1)
        enddo
        write(ifile,*)

c++
      endif
c++




c     --------------------------------------------------
c     Horizontal field: Apparent atmospheric temperature 
c     --------------------------------------------------

c++
      if (c14(1:9).eq.'ta_sim_xy' .or.
     >    c14(1:9).eq.'ta_fil_xy' .or.
     >    c14(1:9).eq.'ta_smo_xy') then
c++

        if (idim+2.lt.10) then
          write(c8,100) idim+2
        else if (idim+2.lt.100) then
          write(c8,101) idim+2
        else
          write(*,*)
          write(*,*) 'STOP in writing.f: More coding is needed'
          write(*,*)
          stop
        endif
c--

        ta_p = amiss_uvht
 
        do i=0,idim+1
        do j=0,jdim+1
           if (ipt(i,j).ge.0) ta_p(i,j) = ta(i,j)
        enddo
        enddo

c--
       if (c14(4:6).eq.'sim') write(ifile,99) it*dt/yr
       if (c14(4:6).eq.'fil') write(ifile,99) it*dt/yr-time_start
       if (c14(4:6).eq.'smo') write(ifile,99) it*dt/yr-time_start

       do j=jdim+1,0,-1
          write(ifile,c8) (ta_p(i,j),i=0,idim+1)
       enddo
       write(ifile,*)

c++
      endif
c++




c     -----------------------------------------
c     Horizontal field: Error in ML temperature 
c     -----------------------------------------

c++
      if (c14(1:9).eq.'er_fil_xy' .or.
     >    c14(1:9).eq.'er_smo_xy') then
c++

        if (idim+2.lt.10) then
          write(c8,201) idim+2
201       format('(0',i1,'f8.2)') 
        else if (idim+2.lt.100) then
          write(c8,202) idim+2
202       format('(',i2,'f8.2)')
        else
          write(*,*)
          write(*,*) 'STOP in writing.f: More coding is needed'
          write(*,*)
          stop
        endif
c--
        if (c14(4:6).eq.'fil') write(ifile,99) it*dt/yr-time_start
        if (c14(4:6).eq.'smo') write(ifile,99) it*dt/yr-time_start
 
        do j=jdim+1,0,-1
           write(ifile,c8) (er_tt(i,j),i=0,idim+1)
        enddo
        write(ifile,*)

c++
      endif
c++




c     -----------
c     Time series
c     ----------- 

c---- Filtered ML temperature at sediment core locations 

c++
      if (c14(1:13).eq.'tt_fil_na8722' .or.
     >    c14(1:13).eq.'tt_fil_ch69k9' .or.
     >    c14(1:13).eq.'tt_fil_su8118') then
c++

          if (c14(8:13).eq.'na8722') i_c = 1
          if (c14(8:13).eq.'ch69k9') i_c = 2
          if (c14(8:13).eq.'su8118') i_c = 3

          write(ifile,*) it*dt/yr-time_start          ,
     >                   tt   (i_lon_dat(i_c),i_lat_dat(i_c)),
     >                   er_tt(i_lon_dat(i_c),i_lat_dat(i_c))
c++
      endif
c++


c---- Smoothed ML temperature at sediment core locations

c++
      if (c14(1:13).eq.'tt_smo_na8722' .or.
     >    c14(1:13).eq.'tt_smo_ch69k9' .or.
     >    c14(1:13).eq.'tt_smo_su8118') then
c++

          if (c14(8:13).eq.'na8722') i_c = 1
          if (c14(8:13).eq.'ch69k9') i_c = 2
          if (c14(8:13).eq.'su8118') i_c = 3

          write(ifile,*) it*dt/yr-time_start          ,
     >                   tt   (i_lon_dat(i_c),i_lat_dat(i_c)),
     >                   er_tt(i_lon_dat(i_c),i_lat_dat(i_c))
c++
      endif
c++


c---- Filtering residuals

c++
      if (c14(1:7).eq.'res_fil') then
c++

c        Data as predicted from x(i,-)

         do ip=1,nP
            zm(ip) = 0.
            do n=1,ndim
               zm(ip) = zm(ip) + Hob(ip,n)*xm(n)
            enddo
         enddo

c        Write 

         do ip=1,nP
            write(ifile,'(6f10.3)') it*dt/yr-time_start,
     >                              zz       (ip)      ,
     >                              zm       (ip)      ,
     >                              HPH_T_p_R(ip,ip)
         enddo

 
c++
      endif
c++


c---- Smoothing residuals

c++
      if (c14(1:7).eq.'res_smo') then
c++

c        Data as predicted from x(i,-)

         do ip=1,nP
            zm(ip) = 0.
            do n=1,ndim
               zm(ip) = zm(ip) + Hob(ip,n)*xm(n)
            enddo
         enddo

c        Write 

         do ip=1,nP
            write(ifile,'(5f10.3)') it*dt/yr-time_start,
     >                              zz     (ip)        ,
     >                              sqrt(RR(ip,ip))    ,
     >                              zm     (ip)
         enddo


c++
      endif
c++



c---- Value & std of latitude of 10-degC ML temperature isotherm 

c++
      if (c14(1:6).eq.'sf_fil' .or.
     >    c14(1:6).eq.'sf_smo') then
c++


c     Longitude index

      open     (99,file='dum')
      write    (99,*) c14(8:9)
      backspace(99  )
      read     (99,*) i
      close    (99  )


c     Loop over latitudes

c--
      do j=0,jdim
c--


c     Start test 

      if (tt(i,j).gt.10. .and. tt(i,j+1).lt.10. .or.
     >    tt(i,j).lt.10. .and. tt(i,j+1).gt.10.) then

           t1         =    tt(i,j  )
           t2         =    tt(i,j+1)
           e1         = er_tt(i,j  )
           e2         = er_tt(i,j+1)
           phi1       = lat  (  j  ) / rad
           phi2       = lat  (  j+1) / rad

c          Latitude of 10-deg isotherm

           phi10 = (abs(t2-10.)*phi1+
     >              abs(t1-10.)*phi2)/abs(t2-t1)

c          std of latitude of 10-deg isotherm

           dphi10_dt1 = (phi2 *sign(1.d0,t1-10.)+
     >                   phi10*sign(1.d0,t2-t1 )) / abs(t2-t1)

           dphi10_dt2 = (phi1 *sign(1.d0,t2-10.)-
     >                   phi10*sign(1.d0,t2-t1 )) / abs(t2-t1)

           do n1=1,n_tt
           do n2=1,n_tt
              if (strx(n1).eq.stringx('tt',i,j  ) .and.
     >            strx(n2).eq.stringx('tt',i,j+1)) then
                  cv = P_fil(n1,n2)
                  goto 112
              endif
           enddo
           enddo

112        er_phi10 = sqrt(  (dphi10_dt1*e1)**2
     >               +       (dphi10_dt2*e2)**2
     >               +      2*dphi10_dt1*dphi10_dt2*cv )

c         Write

          write(ifile,'(f13.3,6f10.3)') it*dt/yr-time_start       ,
     >                                     phi10                  ,
     >                                  er_phi10                  ,
     >                                  2*dphi10_dt1*dphi10_dt2*cv,cv,
     >                                  dphi10_dt1                ,
     >                                  dphi10_dt2

c     End of test

      endif 


c     End of loop over latitudes

c--
      enddo
c--


c---- End of test

c++
      endif
c++




c     -------
c     Formats
c     -------

99    format('Time=',f10.3,' yr')




c     ---------------------
c     End of the subroutine
c     ---------------------

      return

      end

c     ******************************************************************
