c23456789012345678901234567890123456789012345678901234567890123456789012


      SUBROUTINE x_to_sv(xx,Px,nN)

c     ******************************************************************
c     This routine extracts the state variables & their errors from the 
c     state vector 
c
c     Called by:      	fil_lkf 
c     Calls    :     	none	
c
c     Written by       : OM  
c     Last modification: 7/2015
c     ******************************************************************

c     ------------
c     Declarations
c     ------------

c     '''''''''''''''''''''
      implicit none
      include 'commonvar.f'      
c     '''''''''''''''''''''

c---- Argument variables

      integer   nN

      real*8    xx(nN  ),  
     >          Px(nN,nN)
 

c---- Internal variables 

      integer   i,j,n,na,nb,n2


c---- FUNCTIONs

      real*8    EExxxxx,
     >          uuxxxxx,
     >          vvxxxxx

      character*8 stringx




c     --------------
c     ML temperature
c     --------------

c---- Initialize - dimension of state vector
c                  ML temperature error

      n2    = 0
      er_tt = amiss_uvht


c---- Interior pts

      do i=1    ,idim
      do j=jS(i),jN(i) 

            n2      = n2 + 1
            tt(i,j) =      xx(n2   )
         er_tt(i,j) = sqrt(Px(n2,n2))

      enddo
      enddo


c---- Southern bry pts (excluding corners)

      do i=1,idim

         do n=1,n_cor
            if (i      .eq.i_cor(n) .and.
     >          jS(i)-1.eq.j_cor(n)) goto 101
         enddo

            n2            = n2 + 1
            tt(i,jS(i)-1) =      xx(n2   )
         er_tt(i,jS(i)-1) = sqrt(Px(n2,n2))
101      continue

      enddo


c---- Northern bry pts (excluding corners)

      do i=1,idim

         do n=1,n_cor
            if (i      .eq.i_cor(n) .and.
     >          jN(i)+1.eq.j_cor(n)) goto 102
         enddo

         n2               = n2 + 1
            tt(i,jN(i)+1) =      xx(n2   )
         er_tt(i,jN(i)+1) = sqrt(Px(n2,n2))
102      continue

      enddo


c---- Western bry pts (excluding corners)

      do j=1,jdim

         do n=1,n_cor
            if (iW(j)-1.eq.i_cor(n) .and.
     >          j      .eq.j_cor(n)) goto 103
         enddo

         n2               = n2 + 1
            tt(iW(j)-1,j) =      xx(n2   )
         er_tt(iW(j)-1,j) = sqrt(Px(n2,n2))
103      continue

      enddo


c---- Eastern bry pts (excluding corners)

      do j=1,jdim

         do n=1,n_cor
            if (iE(j)+1.eq.i_cor(n) .and.
     >          j      .eq.j_cor(n)) goto 104
         enddo

         n2               = n2 + 1
            tt(iE(j)+1,j) =      xx(n2   )
         er_tt(iE(j)+1,j) = sqrt(Px(n2,n2))
104      continue

      enddo


c---- Corner pts

      do n=1,n_cor 

         n2                       = n2 + 1
            tt(i_cor(n),j_cor(n)) =      xx(n2   )
         er_tt(i_cor(n),j_cor(n)) = sqrt(Px(n2,n2))

      enddo




c     --------------------
c     Apparent temperature
c     --------------------

c---- Coefficients

      do n=1,ncoe
         n2           = n2 + 1 
            coe_ta(n) =      xx(n2   )          
         er_coe_ta(n) = sqrt(Px(n2,n2))
      enddo


c---- Field

      ta = amiss_uvht

      do i=0,idim+1
      do j=0,jdim+1

         if (ipt(i,j).ge.0) then
           ta(i,j) = ta_r(i,j)    
           do n=1,ncoe
              ta(i,j) = ta(i,j) + coe_ta(n)*EExxxxx(n,i,j,'ta')
           enddo
        endif

      enddo
      enddo




c     ---------------------
c     Interior temperature
c     ---------------------

c---- Coefficients

      do n=1,ncoe
         n2           = n2 + 1
            coe_ti(n) =      xx(n2   )
         er_coe_ti(n) = sqrt(Px(n2,n2))
      enddo


c---- Field

      ti = amiss_uvht

      do i=0,idim+1
      do j=0,jdim+1

         if (ipt(i,j).ge.0) then
           ti(i,j) = ti_r(i,j) 
           do n=1,ncoe
              ti(i,j) = ti(i,j) + coe_ti(n)*EExxxxx(n,i,j,'ti')
           enddo
        endif

      enddo
      enddo




c     -----------------
c     Mixed layer depth
c     -----------------

c---- Coefficients

      do n=1,ncoe
         n2           = n2 + 1
            coe_hh(n) =      xx(n2   )
         er_coe_hh(n) = sqrt(Px(n2,n2))
      enddo


c---- Field

      hh = amiss_uvht

      do i=0,idim+1
      do j=0,jdim+1

         if (ipt(i,j).ge.0) then
            hh(i,j) = hh_r(i,j) 
            do n=1,ncoe
               hh(i,j) = hh(i,j) + coe_hh(n)*EExxxxx(n,i,j,'hh')
            enddo
         endif

      enddo
      enddo




c     ----------------
c     Zonal velocities
c     ----------------

c---- Coefficients

      do n=1,ncoe

         n2           = n2 + 1
            coe_uk(n) =      xx(n2   )
         er_coe_uk(n) = sqrt(Px(n2,n2))

         do na=1,ncoe
            do nb=n_tt+1,nN 
               if (strx(nb).eq.stringx('uk',na,0)) then
                  pp_coe_uk(n,na) = Px(n2,nb)
               endif 
            enddo
        enddo

      enddo


c---- Field

      uu = amiss_uvht

      do i=0,idim
      do j=0,jdim+1

         if (ipt(i,j).eq.1 .or. ipt(i+1,j).eq.1) then
            uk(i,j) = uk_r(i,j) 
            do n=1,ncoe
               uk(i,j) = uk(i,j) + coe_uk(n)*EExxxxx(n,i,j,'uk')
            enddo
            uu(i,j) = uk(i,j) + uuxxxxx(i,j,0,1,0) 
         endif

      enddo
      enddo




c     ---------------------
c     Meridional velocities
c     ---------------------

c---- Coefficients

      do n=1,ncoe

         n2           = n2 + 1
            coe_vk(n) =      xx(n2   )
         er_coe_vk(n) = sqrt(Px(n2,n2))

         do na=1,ncoe
            do nb=n_tt+1,nN
               if (strx(nb).eq.stringx('vk',na,0)) then
                  pp_coe_vk(n,na) = Px(n2,nb)
               endif
            enddo
        enddo

      enddo
         
         
c---- Field

      vv = amiss_uvht

      do i=0,idim+1
      do j=0,jdim

         if (ipt(i,j).eq.1 .or. ipt(i,j+1).eq.1) then
            vk(i,j) = vk_r(i,j) 
            do n=1,ncoe
               vk(i,j) = vk(i,j) + coe_vk(n)*EExxxxx(n,i,j,'vk')
            enddo
            vv(i,j) = vk(i,j) + vvxxxxx(i,j,0,1,0)
         endif

      enddo
      enddo




c     ----
c     Test
c     ----

      if (n2.ne.nN) then
        write(*,*)
        write(*,*) 'STOP in x_to_sv.f: n2.ne.nN'
        write(*,*)
        stop
      endif




c     ---------------------
c     End of the subroutine
c     ---------------------

      return

      end

c     ******************************************************************
