c23456789012345678901234567890123456789012345678901234567890123456789012


      SUBROUTINE zzRRHob(time,nP)

c     ******************************************************************
c     This routine constructs - the measurement vector
c                             - the measurement error covariance matrix
c                             - the measurement matrix 
c
c     Called by:        fil_lkf
c                       fil_ekf
c                       smoothe	
c     Calls    :     	coepoly	
c
c     Written by       : OM  
c     Last modification: 8/2015
c     ******************************************************************

c     ------------
c     Declarations
c     ------------

c     '''''''''''''''''''''
      implicit none
      include 'commonvar.f'      
c     '''''''''''''''''''''

c---- Argument variable

      real*8    time

      integer   nP


c---- Internal variables 

      integer   i,j,n,n0,it0

      integer   n1,n2

      character*8 strz


c---- FUNCTIONs 

      real*8    uuxxxxx,
     >          vvxxxxx

      character*8 stringx




c     -------------------------------------------------
c     Measurement vector z(i) of z(i) = H(i)x(i) + v(i)
c          -      matrix H(i) of z(i) = H(i)x(i) + v(i) 
c          -      error covariance matrix RR(i,i)
c     -------------------------------------------------

c---- Default values

      nP  = 0
      zz  = 0.
      RR  = 0.
      Hob = 0.


c---- Sediment data

c++
      do n  =1,n_rec
      do it0=1,itot_dat(n)
c++

         if (nint(time*100).eq.nint(tim_dat(n,it0)*100)) then

c           Increment # of data

            nP = nP + 1

c           c_obs(i)

            c_obs(nP) = cfile(n)

c           z(i) & R(i)

            zz(nP   ) = tem_dat   (n,it0)
            RR(nP,nP) = tem_dat_er(n,it0)**2 

c           H(i) 

            strz = stringx('tt',i_lon_dat(n),i_lat_dat(n))

            do n0=1,ndim
               if (strz.eq.strx(n0)) Hob(nP,n0) = 1. 
            enddo

         endif

c++
      enddo 
      enddo
c++


c---- Instrumental data: Temperature 

c++
      if (nint(time*100).eq.0) then
c++

c        Increment # of data & z(i) & R(i) & H(i)

         do i=0,idim+1
         do j=0,jdim+1

            if (ipt(i,j).ge.0) then
                     nP  = nP + 1
               c_obs(nP) = 'tt'
               zz(nP   ) = sst_WOA_g   (i,j)
               RR(nP,nP) = sst_WOA_g_se(i,j)**2
               strz   = stringx('tt',i,j)
               do n0  = 1,ndim
                  if (strz.eq.strx(n0)) Hob(nP,n0) = 1.
               enddo
           endif

         enddo
         enddo 

c++
      endif
c++ 


c---- Instrumental data: Polynomial coefficients for apparent T

c++
      if (nint(time*100).eq.0) then
c++

c        Apparent temperatures

         ta = amiss_uvht

         do i=0,idim+1
         do j=0,jdim+1
            if (ipt(i,j).ge.0) ta(i,j) = sst_WOA_g(i,j)
         enddo
         enddo

c        Polynomial coefficients 

c        ----------------------
         call coepoly('coe_ta')
c        ----------------------

c        Increment # of data & z(i) & R(i) & H(i)

         RR(nP+1:nP+ncoe,
     >      nP+1:nP+ncoe) = P_coe_ta(1:ncoe,1:ncoe)

         do n=1,ncoe

                  nP  = nP + 1
            c_obs(nP) =         'ta'
            zz   (nP) =      coe_ta(n  )
            strz      = stringx('ta',n,0)
            do n0     = 1,ndim
               if (strz.eq.strx(n0)) Hob(nP,n0) = 1.
            enddo

         enddo

c++
      endif
c++ 


c---- Instrumental data: Polynomial coefficients for interior T

c++
      if (nint(time*100).eq.0) then
c++

c        Interior temperatures

         ti = amiss_uvht

         do i=0,idim+1
         do j=0,jdim+1
            if (ipt(i,j).ge.0) ti(i,j) = sst_WOA_g(i,j)
         enddo
         enddo

c        Polynomial coefficients 

c        ----------------------
         call coepoly('coe_ti')
c        ----------------------

c        Increment # of data & z(i) & R(i) & H(i)

         RR(nP+1:nP+ncoe,
     >      nP+1:nP+ncoe) = P_coe_ti(1:ncoe,1:ncoe)

         do n=1,ncoe

                  nP  = nP + 1
            c_obs(nP) =         'ti'
            zz   (nP) =      coe_ti(n  )
            strz      = stringx('ti',n,0)
            do n0     = 1,ndim
               if (strz.eq.strx(n0)) Hob(nP,n0) = 1.
            enddo

         enddo

c++
      endif
c++ 


c---- Instrumental data: Polynomial coefficients for ML depths 

c++
      if (nint(time*100).eq.0) then
c++

c        ML depths

         hh = amiss_uvht

         do i=0,idim+1
         do j=0,jdim+1
            if (ipt(i,j).ge.0) hh(i,j) = mld_WOA_g(i,j)
         enddo
         enddo

c        Polynomial coefficients 

c        ----------------------
         call coepoly('coe_hh')
c        ----------------------

c        Increment # of data & z(i) & R(i) & H(i)

         RR(nP+1:nP+ncoe,
     >      nP+1:nP+ncoe) = P_coe_hh(1:ncoe,1:ncoe)
      
         do n=1,ncoe

                  nP  = nP + 1
            c_obs(nP) =      'hh'
            zz(nP   ) =   coe_hh(n  )
            strz   = stringx('hh',n,0)
            do n0  = 1,ndim
               if (strz.eq.strx(n0)) Hob(nP,n0) = 1.
            enddo

         enddo

c++
      endif
c++ 


c---- Instrumental data: Polynomial coefficients for zonal velocities 

c++
      if (nint(time*100).eq.0) then
c++

c        Zonal velocities

         uk = amiss_uvht

         do i=0,idim
         do j=0,jdim+1
            if (ipt(i  ,j).eq.1 .or. 
     >          ipt(i+1,j).eq.1) uk(i,j) = uuxxxxx(i,j,1,0,1)
         enddo
         enddo

c        Polynomial coefficients 

c        ----------------------
         call coepoly('coe_uk')
c        ----------------------

c        Increment # of data & z(i) & R(i) & H(i)

         RR(nP+1:nP+ncoe,
     >      nP+1:nP+ncoe) = P_coe_uk(1:ncoe,1:ncoe)

         do n=1,ncoe
            
                  nP  = nP + 1
            c_obs(nP) =         'uk'
            zz(nP   ) =      coe_uk(n  )
            strz   = stringx('uk',n,0)
            do n0  = 1,ndim
               if (strz.eq.strx(n0)) Hob(nP,n0) = 1.
            enddo
   
         enddo

c++
      endif
c++ 


c---- Instrumental data: Polynomial coefficients for meridional velocities 

c++
      if (nint(time*100).eq.0) then
c++

c        Meridional velocities

         vk = amiss_uvht

         do i=0,idim+1
         do j=0,jdim
            if (ipt(i,j  ).eq.1 .or. 
     >          ipt(i,j+1).eq.1) vk(i,j) = vvxxxxx(i,j,1,0,0)
         enddo
         enddo

c        Polynomial coefficients 

c        ----------------------
         call coepoly('coe_vk')
c        ----------------------

c        Increment # of data & z(i) & R(i) & H(i)

         RR(nP+1:nP+ncoe,
     >      nP+1:nP+ncoe) = P_coe_vk(1:ncoe,1:ncoe)

         do n=1,ncoe
            
                  nP  = nP + 1
            c_obs(nP) =      'vk'
            zz(nP   ) =      coe_vk(n  )
            strz      = stringx('vk',n,0)
            do n0  = 1,ndim
               if (strz.eq.strx(n0)) Hob(nP,n0) = 1.
            enddo
   
         enddo

c++
      endif
c++ 




c     ---------------------
c     End of the subroutine
c     ---------------------

      return

      end

c     ******************************************************************
